package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.BasketConstituentsReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class BasketConstituentsReportTypeFormatValidator implements Validator<BasketConstituentsReport> {

	private List<ComparisonResult> getComparisonResults(BasketConstituentsReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("identifier", o.getIdentifier(), 1, of(210), of(Pattern.compile("^[a-zA-Z0-9\\x20-\\x7E&&[^;]]{1,210}$")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, BasketConstituentsReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("BasketConstituentsReport", ValidationResult.ValidationType.TYPE_FORMAT, "BasketConstituentsReport", path, "", res.getError());
				}
				return success("BasketConstituentsReport", ValidationResult.ValidationType.TYPE_FORMAT, "BasketConstituentsReport", path, "");
			})
			.collect(toList());
	}

}
