package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.SpreadLeg1;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class SpreadLeg1Validator implements Validator<SpreadLeg1> {

	private List<ComparisonResult> getComparisonResults(SpreadLeg1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("spreadLeg1Monetary", (BigDecimal) o.getSpreadLeg1Monetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg1Decimal", (BigDecimal) o.getSpreadLeg1Decimal() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg1Basis", (BigDecimal) o.getSpreadLeg1Basis() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadLeg1Notation", (PriceNotationEnum) o.getSpreadLeg1Notation() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadLeg1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadLeg1", ValidationResult.ValidationType.CARDINALITY, "SpreadLeg1", path, "", res.getError());
				}
				return success("SpreadLeg1", ValidationResult.ValidationType.CARDINALITY, "SpreadLeg1", path, "");
			})
			.collect(toList());
	}

}
