package drr.regulation.cftc.rewrite.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.cftc.rewrite.ClearingSwapUTIsReport;
import drr.regulation.cftc.rewrite.validation.ClearingSwapUTIsReportTypeFormatValidator;
import drr.regulation.cftc.rewrite.validation.ClearingSwapUTIsReportValidator;
import drr.regulation.cftc.rewrite.validation.exists.ClearingSwapUTIsReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.52.1
 */
@RosettaMeta(model=ClearingSwapUTIsReport.class)
public class ClearingSwapUTIsReportMeta implements RosettaMetaData<ClearingSwapUTIsReport> {

	@Override
	public List<Validator<? super ClearingSwapUTIsReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super ClearingSwapUTIsReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ClearingSwapUTIsReport> validator(ValidatorFactory factory) {
		return factory.<ClearingSwapUTIsReport>create(ClearingSwapUTIsReportValidator.class);
	}

	@Override
	public Validator<? super ClearingSwapUTIsReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ClearingSwapUTIsReport>create(ClearingSwapUTIsReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ClearingSwapUTIsReport> validator() {
		return new ClearingSwapUTIsReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ClearingSwapUTIsReport> typeFormatValidator() {
		return new ClearingSwapUTIsReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ClearingSwapUTIsReport, Set<String>> onlyExistsValidator() {
		return new ClearingSwapUTIsReportOnlyExistsValidator();
	}
}
