package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.labels.CFTCPart45LabelProvider;
import drr.regulation.cftc.tr.reports.AssetClassRule;
import drr.regulation.cftc.tr.reports.LargeNotionalOffFacilitySwapElectionIndicatorRule;
import drr.regulation.cftc.tr.reports.MandatoryClearingIndicatorRule;
import drr.regulation.cftc.tr.reports.MaturityDateOfTheUnderlierRule;
import drr.regulation.cftc.tr.reports.MessageTypeTradeStateRule;
import drr.regulation.cftc.tr.reports.OptionStyleRule;
import drr.regulation.cftc.tr.reports.OptionTypeRule;
import drr.regulation.cftc.tr.reports.PhysicalCommodityIndicatorRule;
import drr.regulation.cftc.tr.reports.SdMspIndicatorParty1Rule;
import drr.regulation.cftc.tr.reports.SdMspIndicatorParty2Rule;
import drr.regulation.cftc.tr.reports.SefOrDcmAnonymousExecutionIndicatorRule;
import drr.regulation.cftc.tr.reports.SefOrDcmIndicatorRule;
import drr.regulation.cftc.tr.reports.SettlementTypeRule;
import drr.regulation.common.TransactionReportInstruction;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.cftc.rewrite", body="CFTC", corpusList={"Part45"})
@RuneLabelProvider(labelProvider=CFTCPart45LabelProvider.class)
@ImplementedBy(CFTCPart45ReportFunction.CFTCPart45ReportFunctionDefault.class)
public abstract class CFTCPart45ReportFunction implements ReportFunction<TransactionReportInstruction, CFTCPart45TransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AllocationIndicatorRule allocationIndicatorRule;
	@Inject protected AmendmentIndicatorRule amendmentIndicatorRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BlockTradeElectionIndicatorRule blockTradeElectionIndicatorRule;
	@Inject protected BuyerIdentifierFormatRule buyerIdentifierFormatRule;
	@Inject protected BuyerIdentifierRule buyerIdentifierRule;
	@Inject protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
	@Inject protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingAccountOriginRule clearingAccountOriginRule;
	@Inject protected ClearingExceptionsAndExemptionsCounterparty1Rule clearingExceptionsAndExemptionsCounterparty1Rule;
	@Inject protected ClearingExceptionsAndExemptionsCounterparty2Rule clearingExceptionsAndExemptionsCounterparty2Rule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected ClearingReceiptTimestampRule clearingReceiptTimestampRule;
	@Inject protected ClearingSwapUSIsRule clearingSwapUSIsRule;
	@Inject protected ClearingSwapUTIsRule clearingSwapUTIsRule;
	@Inject protected Counterparty1FederalEntityIndicatorRule counterparty1FederalEntityIndicatorRule;
	@Inject protected Counterparty1FinancialEntityIndicatorRule counterparty1FinancialEntityIndicatorRule;
	@Inject protected Counterparty1FormatRule counterparty1FormatRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2FederalEntityIndicatorRule counterparty2FederalEntityIndicatorRule;
	@Inject protected Counterparty2FinancialEntityIndicatorRule counterparty2FinancialEntityIndicatorRule;
	@Inject protected Counterparty2FormatRule counterparty2FormatRule;
	@Inject protected Counterparty2IdentifierSourceRule counterparty2IdentifierSourceRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CustomBasketIndicatorRule customBasketIndicatorRule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EmbeddedOptionTypeRule embeddedOptionTypeRule;
	@Inject protected EventIdentifierRule eventIdentifierRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateLeg1Rule exchangeRateLeg1Rule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
	@Inject protected FirstExerciseDateRule firstExerciseDateRule;
	@Inject protected FixedRateDayCountConventionLeg1Rule fixedRateDayCountConventionLeg1Rule;
	@Inject protected FixedRateDayCountConventionLeg2Rule fixedRateDayCountConventionLeg2Rule;
	@Inject protected FixedRateLeg1Rule fixedRateLeg1Rule;
	@Inject protected FixedRateLeg2Rule fixedRateLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg1Rule fixedRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodLeg2Rule fixedRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FixingDateLeg1Rule fixingDateLeg1Rule;
	@Inject protected FixingDateLeg2Rule fixingDateLeg2Rule;
	@Inject protected FloatingRateDayCountConventionLeg1Rule floatingRateDayCountConventionLeg1Rule;
	@Inject protected FloatingRateDayCountConventionLeg2Rule floatingRateDayCountConventionLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg1Rule floatingRatePaymentFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodLeg2Rule floatingRatePaymentFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg1Rule floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg1Rule floatingRateResetFrequencyPeriodLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodLeg2Rule floatingRateResetFrequencyPeriodLeg2Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg1Rule floatingRateResetFrequencyPeriodMultiplierLeg1Rule;
	@Inject protected FloatingRateResetFrequencyPeriodMultiplierLeg2Rule floatingRateResetFrequencyPeriodMultiplierLeg2Rule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected InitialMarginCollateralPortfolioCodeRule initialMarginCollateralPortfolioCodeRule;
	@Inject protected JurisdictionRule jurisdictionRule;
	@Inject protected LargeNotionalOffFacilitySwapElectionIndicatorRule largeNotionalOffFacilitySwapElectionIndicatorRule;
	@Inject protected MandatoryClearingIndicatorRule mandatoryClearingIndicatorRule;
	@Inject protected MaturityDateOfTheUnderlierRule maturityDateOfTheUnderlierRule;
	@Inject protected MessageTypeTradeStateRule messageTypeTradeStateRule;
	@Inject protected NewSDRIdentifierRule newSDRIdentifierRule;
	@Inject protected NonStandardizedTermIndicatorRule nonStandardizedTermIndicatorRule;
	@Inject protected NotionalAmountLeg1Rule notionalAmountLeg1Rule;
	@Inject protected NotionalAmountLeg2Rule notionalAmountLeg2Rule;
	@Inject protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
	@Inject protected NotionalCurrencyLeg2Rule notionalCurrencyLeg2Rule;
	@Inject protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected OptionStyleRule optionStyleRule;
	@Inject protected OptionTypeRule optionTypeRule;
	@Inject protected OriginalSwapSDRIdentifierRule originalSwapSDRIdentifierRule;
	@Inject protected OriginalSwapUSIRule originalSwapUSIRule;
	@Inject protected OriginalSwapUTIRule originalSwapUTIRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageIndicatorRule packageIndicatorRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionPriceRule packageTransactionPriceRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PackageTransactionSpreadRule packageTransactionSpreadRule;
	@Inject protected PayerIdentifierLeg1Rule payerIdentifierLeg1Rule;
	@Inject protected PayerIdentifierLeg2Rule payerIdentifierLeg2Rule;
	@Inject protected PayerLeg1IdentifierFormatRule payerLeg1IdentifierFormatRule;
	@Inject protected PayerLeg2IdentifierFormatRule payerLeg2IdentifierFormatRule;
	@Inject protected PhysicalCommodityIndicatorRule physicalCommodityIndicatorRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PostPricedSwapIndicatorRule postPricedSwapIndicatorRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PrimeBrokerageTransactionIndicatorRule primeBrokerageTransactionIndicatorRule;
	@Inject protected PriorUSIRule priorUSIRule;
	@Inject protected PriorUTIRule priorUTIRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityFrequencyLeg1Rule quantityFrequencyLeg1Rule;
	@Inject protected QuantityFrequencyLeg2Rule quantityFrequencyLeg2Rule;
	@Inject protected QuantityFrequencyMultiplierLeg1Rule quantityFrequencyMultiplierLeg1Rule;
	@Inject protected QuantityFrequencyMultiplierLeg2Rule quantityFrequencyMultiplierLeg2Rule;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReceiverIdentifierLeg1Rule receiverIdentifierLeg1Rule;
	@Inject protected ReceiverIdentifierLeg2Rule receiverIdentifierLeg2Rule;
	@Inject protected ReceiverLeg1IdentifierFormatRule receiverLeg1IdentifierFormatRule;
	@Inject protected ReceiverLeg2IdentifierFormatRule receiverLeg2IdentifierFormatRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SdMspIndicatorParty1Rule sdMspIndicatorParty1Rule;
	@Inject protected SdMspIndicatorParty2Rule sdMspIndicatorParty2Rule;
	@Inject protected SefOrDcmAnonymousExecutionIndicatorRule sefOrDcmAnonymousExecutionIndicatorRule;
	@Inject protected SefOrDcmIndicatorRule sefOrDcmIndicatorRule;
	@Inject protected SellerIdentifierFormatRule sellerIdentifierFormatRule;
	@Inject protected SellerIdentifierRule sellerIdentifierRule;
	@Inject protected SettlementCurrencyLeg1Rule settlementCurrencyLeg1Rule;
	@Inject protected SettlementCurrencyLeg2Rule settlementCurrencyLeg2Rule;
	@Inject protected SettlementLocationLeg1Rule settlementLocationLeg1Rule;
	@Inject protected SettlementLocationLeg2Rule settlementLocationLeg2Rule;
	@Inject protected SettlementTypeRule settlementTypeRule;
	@Inject protected SpreadCurrencyLeg1Rule spreadCurrencyLeg1Rule;
	@Inject protected SpreadCurrencyLeg2Rule spreadCurrencyLeg2Rule;
	@Inject protected SpreadLeg1Rule spreadLeg1Rule;
	@Inject protected SpreadLeg2Rule spreadLeg2Rule;
	@Inject protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;
	@Inject protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;
	@Inject protected StrikePriceCurrencyRule strikePriceCurrencyRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected SubmitterIdentifierRule submitterIdentifierRule;
	@Inject protected TotalNotionalQuantityLeg1Rule totalNotionalQuantityLeg1Rule;
	@Inject protected TotalNotionalQuantityLeg2Rule totalNotionalQuantityLeg2Rule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueSwapIdentifierRule uniqueSwapIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected VariationMarginCollateralPortfolioCodeRule variationMarginCollateralPortfolioCodeRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CFTCPart45TransactionReport evaluate(TransactionReportInstruction input) {
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final CFTCPart45TransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CFTCPart45TransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class CFTCPart45ReportFunctionDefault extends CFTCPart45ReportFunction {
		@Override
		protected CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder output = CFTCPart45TransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder assignOutput(CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingAccountOrigin(clearingAccountOriginRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setClearingSwapUSIs(clearingSwapUSIsRule.evaluate(input));
			
			output
				.setClearingSwapUTIs(clearingSwapUTIsRule.evaluate(input));
			
			output
				.setOriginalSwapUSI(originalSwapUSIRule.evaluate(input));
			
			output
				.setOriginalSwapUTI(originalSwapUTIRule.evaluate(input));
			
			output
				.setOriginalSwapSDRIdentifier(originalSwapSDRIdentifierRule.evaluate(input));
			
			output
				.setClearingReceiptTimestamp(clearingReceiptTimestampRule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty1(clearingExceptionsAndExemptionsCounterparty1Rule.evaluate(input));
			
			output
				.setClearingExceptionsAndExemptionsCounterparty2(clearingExceptionsAndExemptionsCounterparty2Rule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierSource(counterparty2IdentifierSourceRule.evaluate(input));
			
			output
				.setCounterparty1FinancialEntityIndicator(counterparty1FinancialEntityIndicatorRule.evaluate(input));
			
			output
				.setCounterparty2FinancialEntityIndicator(counterparty2FinancialEntityIndicatorRule.evaluate(input));
			
			output
				.setBuyerIdentifier(buyerIdentifierRule.evaluate(input));
			
			output
				.setSellerIdentifier(sellerIdentifierRule.evaluate(input));
			
			output
				.setPayerIdentifierLeg1(payerIdentifierLeg1Rule.evaluate(input));
			
			output
				.setPayerIdentifierLeg2(payerIdentifierLeg2Rule.evaluate(input));
			
			output
				.setReceiverIdentifierLeg1(receiverIdentifierLeg1Rule.evaluate(input));
			
			output
				.setReceiverIdentifierLeg2(receiverIdentifierLeg2Rule.evaluate(input));
			
			output
				.setSubmitterIdentifier(submitterIdentifierRule.evaluate(input));
			
			output
				.setCounterparty1FederalEntityIndicator(counterparty1FederalEntityIndicatorRule.evaluate(input));
			
			output
				.setCounterparty2FederalEntityIndicator(counterparty2FederalEntityIndicatorRule.evaluate(input));
			
			output
				.setCustomBasketIndicator(customBasketIndicatorRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setAmendmentIndicator(amendmentIndicatorRule.evaluate(input));
			
			output
				.setEventIdentifier(eventIdentifierRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setNotionalAmountLeg1(notionalAmountLeg1Rule.evaluate(input));
			
			output
				.setNotionalAmountLeg2(notionalAmountLeg2Rule.evaluate(input));
			
			output
				.setNotionalCurrencyLeg1(notionalCurrencyLeg1Rule.evaluate(input));
			
			output
				.setNotionalCurrencyLeg2(notionalCurrencyLeg2Rule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg1(notionalAmountScheduleLeg1Rule.evaluate(input));
			
			output
				.setNotionalAmountScheduleLeg2(notionalAmountScheduleLeg2Rule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setNotionalQuantityLeg1(notionalQuantityLeg1Rule.evaluate(input));
			
			output
				.setNotionalQuantityLeg2(notionalQuantityLeg2Rule.evaluate(input));
			
			output
				.setQuantityFrequencyLeg1(quantityFrequencyLeg1Rule.evaluate(input));
			
			output
				.setQuantityFrequencyLeg2(quantityFrequencyLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal0 = quantityFrequencyMultiplierLeg1Rule.evaluate(input);
			output
				.setQuantityFrequencyMultiplierLeg1((bigDecimal0 == null ? null : bigDecimal0.intValueExact()));
			
			final BigDecimal bigDecimal1 = quantityFrequencyMultiplierLeg2Rule.evaluate(input);
			output
				.setQuantityFrequencyMultiplierLeg2((bigDecimal1 == null ? null : bigDecimal1.intValueExact()));
			
			output
				.setQuantityUnitOfMeasureLeg1(quantityUnitOfMeasureLeg1Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg2(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.setTotalNotionalQuantityLeg1(totalNotionalQuantityLeg1Rule.evaluate(input));
			
			output
				.setTotalNotionalQuantityLeg2(totalNotionalQuantityLeg2Rule.evaluate(input));
			
			output
				.setPackageIndicator(packageIndicatorRule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setFixedRateDayCountConventionLeg1(fixedRateDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.setFixedRateDayCountConventionLeg2(fixedRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateDayCountConventionLeg1(floatingRateDayCountConventionLeg1Rule.evaluate(input));
			
			output
				.setFloatingRateDayCountConventionLeg2(floatingRateDayCountConventionLeg2Rule.evaluate(input));
			
			output
				.setFixingDateLeg1(fixingDateLeg1Rule.evaluate(input));
			
			output
				.setFixingDateLeg2(fixingDateLeg2Rule.evaluate(input));
			
			output
				.setFloatingRateResetFrequencyPeriodLeg1(floatingRateResetFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setFloatingRateResetFrequencyPeriodLeg2(floatingRateResetFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal2 = floatingRateResetFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.setFloatingRateResetFrequencyPeriodMultiplierLeg1((bigDecimal2 == null ? null : bigDecimal2.intValueExact()));
			
			final BigDecimal bigDecimal3 = floatingRateResetFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setFloatingRateResetFrequencyPeriodMultiplierLeg2((bigDecimal3 == null ? null : bigDecimal3.intValueExact()));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setFixedRatePaymentFrequencyPeriodLeg1(fixedRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setFixedRatePaymentFrequencyPeriodLeg2(fixedRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			output
				.setFloatingRatePaymentFrequencyPeriodLeg1(floatingRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
			
			output
				.setFloatingRatePaymentFrequencyPeriodLeg2(floatingRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
			
			final BigDecimal bigDecimal4 = fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.setFixedRatePaymentFrequencyPeriodMultiplierLeg1((bigDecimal4 == null ? null : bigDecimal4.intValueExact()));
			
			final BigDecimal bigDecimal5 = fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setFixedRatePaymentFrequencyPeriodMultiplierLeg2((bigDecimal5 == null ? null : bigDecimal5.intValueExact()));
			
			final BigDecimal bigDecimal6 = floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input);
			output
				.setFloatingRatePaymentFrequencyPeriodMultiplierLeg1((bigDecimal6 == null ? null : bigDecimal6.intValueExact()));
			
			final BigDecimal bigDecimal7 = floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input);
			output
				.setFloatingRatePaymentFrequencyPeriodMultiplierLeg2((bigDecimal7 == null ? null : bigDecimal7.intValueExact()));
			
			output
				.setExchangeRateLeg1(exchangeRateLeg1Rule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setFixedRateLeg1(fixedRateLeg1Rule.evaluate(input));
			
			output
				.setFixedRateLeg2(fixedRateLeg2Rule.evaluate(input));
			
			output
				.setPostPricedSwapIndicator(postPricedSwapIndicatorRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setSpreadLeg1(spreadLeg1Rule.evaluate(input));
			
			output
				.setSpreadLeg2(spreadLeg2Rule.evaluate(input));
			
			output
				.setSpreadCurrencyLeg1(spreadCurrencyLeg1Rule.evaluate(input));
			
			output
				.setSpreadCurrencyLeg2(spreadCurrencyLeg2Rule.evaluate(input));
			
			output
				.setSpreadNotationLeg1(spreadNotationLeg1Rule.evaluate(input));
			
			output
				.setSpreadNotationLeg2(spreadNotationLeg2Rule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(optionPremiumPaymentDateRule.evaluate(input));
			
			output
				.setFirstExerciseDate(firstExerciseDateRule.evaluate(input));
			
			output
				.setCDSIndexAttachmentPoint(cDSIndexAttachmentPointRule.evaluate(input));
			
			output
				.setCDSIndexDetachmentPoint(cDSIndexDetachmentPointRule.evaluate(input));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setEmbeddedOptionType(embeddedOptionTypeRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setFinalContractualSettlementDate(finalContractualSettlementDateRule.evaluate(input));
			
			output
				.setSettlementCurrencyLeg1(settlementCurrencyLeg1Rule.evaluate(input));
			
			output
				.setSettlementCurrencyLeg2(settlementCurrencyLeg2Rule.evaluate(input));
			
			output
				.setSettlementLocationLeg1(settlementLocationLeg1Rule.evaluate(input));
			
			output
				.setSettlementLocationLeg2(settlementLocationLeg2Rule.evaluate(input));
			
			output
				.setAllocationIndicator(allocationIndicatorRule.evaluate(input));
			
			output
				.setNonStandardizedTermIndicator(nonStandardizedTermIndicatorRule.evaluate(input));
			
			output
				.setBlockTradeElectionIndicator(blockTradeElectionIndicatorRule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setPrimeBrokerageTransactionIndicator(primeBrokerageTransactionIndicatorRule.evaluate(input));
			
			output
				.setPriorUSI(priorUSIRule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIRule.evaluate(input));
			
			output
				.setUniqueSwapIdentifier(uniqueSwapIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setJurisdiction(jurisdictionRule.evaluate(input));
			
			output
				.setNewSDRIdentifier(newSDRIdentifierRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(initialMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.setVariationMarginCollateralPortfolioCode(variationMarginCollateralPortfolioCodeRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setOptionType(optionTypeRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setOptionStyle(optionStyleRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setMandatoryClearingIndicator(mandatoryClearingIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setMaturityDateOfTheUnderlier(maturityDateOfTheUnderlierRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setLargeNotionalOffFacilitySwapElectionIndicator(largeNotionalOffFacilitySwapElectionIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSefOrDcmIndicator(sefOrDcmIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSefOrDcmAnonymousExecutionIndicator(sefOrDcmAnonymousExecutionIndicatorRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setMessageType(messageTypeTradeStateRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSettlementType(settlementTypeRule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSdMspIndicatorParty1(sdMspIndicatorParty1Rule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setSdMspIndicatorParty2(sdMspIndicatorParty2Rule.evaluate(input));
			
			output
				.getOrCreateCftcGuidebook()
				.setPhysicalCommodityIndicator(physicalCommodityIndicatorRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setCounterparty1Format(counterparty1FormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setCounterparty2Format(counterparty2FormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setBuyerIdentifierFormat(buyerIdentifierFormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setSellerIdentifierFormat(sellerIdentifierFormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPayerIdentifierLeg1Format(payerLeg1IdentifierFormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPayerIdentifierLeg2Format(payerLeg2IdentifierFormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setReceiverIdentifierLeg1Format(receiverLeg1IdentifierFormatRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setReceiverIdentifierLeg2Format(receiverLeg2IdentifierFormatRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
