package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalAmountScheduleAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountScheduleLeg2AmountRule.NotionalAmountScheduleLeg2AmountRuleDefault.class)
public abstract class NotionalAmountScheduleLeg2AmountRule implements ReportFunction<QuantityReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalAmountScheduleAmountRule cDENotionalAmountScheduleAmountRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(QuantityReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(QuantityReportablePeriod input);

	public static class NotionalAmountScheduleLeg2AmountRuleDefault extends NotionalAmountScheduleLeg2AmountRule {
		@Override
		protected BigDecimal doEvaluate(QuantityReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, QuantityReportablePeriod input) {
			output = cDENotionalAmountScheduleAmountRule.evaluate(input);
			
			return output;
		}
	}
}
