package drr.regulation.cftc.rewrite.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.reports.CDESettlementLocationLeg1Rule;
import javax.inject.Inject;


@ImplementedBy(SettlementLocationLeg1Rule.SettlementLocationLeg1RuleDefault.class)
public abstract class SettlementLocationLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESettlementLocationLeg1Rule cDESettlementLocationLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class SettlementLocationLeg1RuleDefault extends SettlementLocationLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(cDESettlementLocationLeg1Rule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
