package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.1
 */
@RosettaDataRule("CFTCPart43TransactionReportQuantityFrequencyCondition")
@ImplementedBy(CFTCPart43TransactionReportQuantityFrequencyCondition.Default.class)
public interface CFTCPart43TransactionReportQuantityFrequencyCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportQuantityFrequencyCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Commodity\" then ((if notionalQuantityLeg1 exists then quantityFrequencyLeg1 exists) and (if notionalQuantityLeg1 is absent then quantityFrequencyLeg1 is absent) and (if notionalQuantityLeg2 exists then quantityFrequencyLeg2 exists) and (if notionalQuantityLeg2 is absent then quantityFrequencyLeg2 is absent)) else quantityFrequencyLeg1 is absent and quantityFrequencyLeg2 is absent";
	
	class Default implements CFTCPart43TransactionReportQuantityFrequencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getNotionalQuantityLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalQuantityLeg1())).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg1()));
					} else {
						ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult1;
					if (notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getNotionalQuantityLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalQuantityLeg1())).getOrDefault(false)) {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg1()));
					} else {
						ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult2;
					if (exists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getNotionalQuantityLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalQuantityLeg2())).getOrDefault(false)) {
						ifThenElseResult2 = exists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg2()));
					} else {
						ifThenElseResult2 = ComparisonResult.successEmptyOperand("");
					}
					final ComparisonResult ifThenElseResult3;
					if (notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getNotionalQuantityLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNotionalQuantityLeg2())).getOrDefault(false)) {
						ifThenElseResult3 = notExists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg2()));
					} else {
						ifThenElseResult3 = ComparisonResult.successEmptyOperand("");
					}
					return ifThenElseResult0.and(ifThenElseResult1).and(ifThenElseResult2).and(ifThenElseResult3);
				}
				return notExists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg1())).and(notExists(MapperS.of(cFTCPart43TransactionReport).<String>map("getQuantityFrequencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getQuantityFrequencyLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportQuantityFrequencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
