package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.OtherPaymentReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.1
 */
@RosettaDataRule("CFTCPart45TransactionReportFixedRateCondition")
@ImplementedBy(CFTCPart45TransactionReportFixedRateCondition.Default.class)
public interface CFTCPart45TransactionReportFixedRateCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportFixedRateCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Credit\" then (if spreadLeg1 is absent and otherPayment -> paymentType any <> \"UFRO\" and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then fixedRateLeg1 exists else fixedRateLeg1 is absent) and (if spreadLeg2 is absent and otherPayment -> paymentType any <> \"UFRO\" and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then fixedRateLeg2 exists else fixedRateLeg2 is absent) else if cftcGuidebook -> assetClass = \"InterestRate\" then (if spreadLeg1 is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then fixedRateLeg1 exists else fixedRateLeg1 is absent) and (if spreadLeg2 is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then fixedRateLeg2 exists else fixedRateLeg2 is absent) else if cftcGuidebook -> assetClass = \"Commodity\" and ((price is absent or (spreadLeg1 is absent and spreadLeg2 is absent)) and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent) then fixedRateLeg1 exists or fixedRateLeg2 exists else fixedRateLeg1 is absent and fixedRateLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportFixedRateCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Credit"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1())).and(notEqual(MapperS.of(cFTCPart45TransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any)).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult0 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1()));
					} else {
						ifThenElseResult0 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1()));
					}
					final ComparisonResult ifThenElseResult1;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2())).and(notEqual(MapperS.of(cFTCPart45TransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any)).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult1 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2()));
					} else {
						ifThenElseResult1 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2()));
					}
					return ifThenElseResult0.and(ifThenElseResult1);
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("InterestRate"), CardinalityOperator.All).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult2;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1())).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult2 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1()));
					} else {
						ifThenElseResult2 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1()));
					}
					final ComparisonResult ifThenElseResult3;
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2())).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
						ifThenElseResult3 = exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2()));
					} else {
						ifThenElseResult3 = notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2()));
					}
					return ifThenElseResult2.and(ifThenElseResult3);
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).and(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice())).or(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2())))).and(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).and(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle())))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1())).or(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2())));
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportFixedRateCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
