package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.OtherPaymentReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.1
 */
@RosettaDataRule("CFTCPart45TransactionReportOtherPaymentTypeCondition")
@ImplementedBy(CFTCPart45TransactionReportOtherPaymentTypeCondition.Default.class)
public interface CFTCPart45TransactionReportOtherPaymentTypeCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportOtherPaymentTypeCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Credit\" then (if fixedRateLeg1 is absent and fixedRateLeg2 is absent and spreadLeg1 is absent and spreadLeg2 is absent then otherPayment -> paymentType any = \"UFRO\")";
	
	class Default implements CFTCPart45TransactionReportOtherPaymentTypeCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Credit"), CardinalityOperator.All).getOrDefault(false)) {
					if (notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1())).and(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2()))).and(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()))).and(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()))).getOrDefault(false)) {
						return areEqual(MapperS.of(cFTCPart45TransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getOtherPayment()).<String>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of("UFRO"), CardinalityOperator.Any);
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportOtherPaymentTypeCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
