package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.functions.ValidatePartyIdentifierFormat;
import drr.regulation.common.PartyIdentifierFormatEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 5.52.1
 */
@RosettaDataRule("CFTCPart45TransactionReportReceiverIdentifierLeg2")
@ImplementedBy(CFTCPart45TransactionReportReceiverIdentifierLeg2.Default.class)
public interface CFTCPart45TransactionReportReceiverIdentifierLeg2 extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportReceiverIdentifierLeg2";
	String DEFINITION = "ValidatePartyIdentifierFormat( receiverIdentifierLeg2, nonReportable -> receiverIdentifierLeg2Format )";
	
	class Default implements CFTCPart45TransactionReportReceiverIdentifierLeg2 {
	
		@Inject protected ValidatePartyIdentifierFormat validatePartyIdentifierFormat;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				return ComparisonResult.of(MapperS.of(validatePartyIdentifierFormat.evaluate(MapperS.of(cFTCPart45TransactionReport).<String>map("getReceiverIdentifierLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getReceiverIdentifierLeg2()).get(), MapperS.of(cFTCPart45TransactionReport).<CFTCNonReportablePart45>map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).<PartyIdentifierFormatEnum>map("getReceiverIdentifierLeg2Format", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getReceiverIdentifierLeg2Format()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportReceiverIdentifierLeg2 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
