package drr.regulation.common;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.meta.CommonTransactionReportMeta;
import iso20022.auth030.esma.Frequency13Code__1;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import iso20022.auth030.esma.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * Common Transaction Report represents common attributes
 * @version 5.52.1
 */
@RosettaDataType(value="CommonTransactionReport", builder=CommonTransactionReport.CommonTransactionReportBuilderImpl.class, version="5.52.1")
@RuneDataType(value="CommonTransactionReport", model="drr", builder=CommonTransactionReport.CommonTransactionReportBuilderImpl.class, version="5.52.1")
public interface CommonTransactionReport extends RosettaModelObject {

	CommonTransactionReportMeta metaData = new CommonTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	ZonedDateTime getReportingTimestamp();
	String getReportSubmittingEntityID();
	String getEntityResponsibleForReporting();
	String getCounterparty1();
	String getNatureOfCounterparty1();
	String getCorporateSectorOfTheCounterparty1();
	Boolean getClearingThresholdOfCounterparty1();
	String getCounterparty2();
	ISOCountryCodeEnum getCountryOfTheCounterParty2();
	String getNatureOfCounterparty2();
	String getCorporateSectorOfTheCounterparty2();
	Boolean getCounterparty2IdentifierType();
	String getClearingMember();
	Boolean getClearingThresholdOfCounterparty2();
	Boolean getReportingObligationOfTheCounterparty2();
	String getBrokerID();
	String getDirection();
	String getDirectionOfLeg1();
	String getDirectionOfLeg2();
	Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();
	String getUti();
	String getReportTrackingNumber();
	String getPriorUTI();
	String getPtrrId();
	String getPackageIdentifier();
	String getSubsequentPositionUTI();
	String getIsin();
	String getUpi();
	String getProductClassification();
	String getContractType();
	String getAssetClass();
	Boolean getIsCrypto();
	String getUnderlyingIdentificationType();
	String getUnderlyingIdentification();
	List<String> getNameOfTheUnderlyingIndex();
	List<String> getUnderlyingIndexIndicator();
	String getCustomBasketCode();
	String getSettlementCurrency1();
	String getSettlementCurrency2();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	BigDecimal getDelta();
	ZonedDateTime getValuationTimestamp();
	ZonedDateTime getConfirmationTimestamp();
	String getConfirmed();
	String getClearingObligation();
	String getCleared();
	ZonedDateTime getClearingTimestamp();
	String getCentralCounterparty();
	String getMasterAgreementType();
	String getOtherMasterAgreementType();
	Integer getMasterAgreementVersion();
	Boolean getIntragroup();
	Boolean getPtrr();
	String getTypeOfPTRRTechnique();
	String getPtrrServiceProvider();
	String getVenueOfExecution();
	ZonedDateTime getExecutionTimestamp();
	Date getEffectiveDate();
	Date getExpirationDate();
	Date getEarlyTerminationDate();
	Date getFinalContractualSettlementDate();
	String getDeliveryType();
	BigDecimal getNotionalLeg1();
	ISOCurrencyCodeEnum getNotionalCurrency1();
	BigDecimal getTotalNotionalQuantityLeg1();
	BigDecimal getTotalNotionalQuantityLeg2();
	BigDecimal getNotionalLeg2();
	ISOCurrencyCodeEnum getNotionalCurrency2();
	BigDecimal getFixedRateOfLeg1();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg1();
	String getFixedRatePaymentFrequencyPeriodLeg1();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
	String getIdentifierOfFloatingRateOfLeg1();
	String getIndicatorOfTheFloatingRateOfLeg1();
	String getNameOfTheFloatingRateOfLeg1();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1();
	Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();
	String getFloatingRateReferencePeriodOfLeg1TimePeriod();
	Integer getFloatingRateReferencePeriodOfLeg1Multiplier();
	String getFloatingRateResetFrequencyPeriodOfLeg1();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1();
	BigDecimal getFixedRateOfLeg2();
	InterestComputationMethod4Code getFixedRateDayCountConventionLeg2();
	String getFixedRatePaymentFrequencyPeriodLeg2();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
	String getIdentifierOfFloatingRateOfLeg2();
	String getIndicatorOfTheFloatingRateOfLeg2();
	String getNameOfTheFloatingRateOfLeg2();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2();
	String getFloatingRatePaymentFrequencyPeriodOfLeg2();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();
	String getFloatingRateReferencePeriodOfLeg2TimePeriod();
	Integer getFloatingRateReferencePeriodOfLeg2Multiplier();
	String getFloatingRateResetFrequencyPeriodOfLeg2();
	Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2();
	BigDecimal getExchangeRate();
	BigDecimal getForwardExchangeRate();
	String getExchangeRateBasis();
	String getBaseProduct();
	String getSubProduct();
	String getFurtherSubProduct();
	String getOptionType();
	String getOptionStyle();
	BigDecimal getOptionPremiumAmount();
	ISOCurrencyCodeEnum getOptionPremiumCurrency();
	Date getOptionPremiumPaymentDate();
	Date getMaturityDateOfTheUnderlying();
	String getSeniority();
	String getReferenceEntity();
	Integer getSeries();
	Integer getVersion();
	BigDecimal getIndexFactor();
	Boolean getTranche();
	BigDecimal getCdSIndexAttachmentPoint();
	BigDecimal getCdSIndexDetachmentPoint();
	Boolean getCollateralPortfolioIndicator();
	String getCollateralPortfolioCode();
	String getEventType();
	Date getEventDate();
	String getLevel();
	String getActionType();

	/*********************** Build Methods  ***********************/
	CommonTransactionReport build();
	
	CommonTransactionReport.CommonTransactionReportBuilder toBuilder();
	
	static CommonTransactionReport.CommonTransactionReportBuilder builder() {
		return new CommonTransactionReport.CommonTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CommonTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CommonTransactionReport> getType() {
		return CommonTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
		processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
		processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
		processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
		processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, getDirectionOfLeg1(), this);
		processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, getDirectionOfLeg2(), this);
		processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
		processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
		processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
		processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
		processor.processBasic(path.newSubPath("upi"), String.class, getUpi(), this);
		processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
		processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("underlyingIndexIndicator"), String.class, getUnderlyingIndexIndicator(), this);
		processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
		processor.processBasic(path.newSubPath("settlementCurrency1"), String.class, getSettlementCurrency1(), this);
		processor.processBasic(path.newSubPath("settlementCurrency2"), String.class, getSettlementCurrency2(), this);
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
		processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
		processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
		processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
		processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
		processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
		processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
		processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
		processor.processBasic(path.newSubPath("notionalCurrency1"), ISOCurrencyCodeEnum.class, getNotionalCurrency1(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
		processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
		processor.processBasic(path.newSubPath("notionalCurrency2"), ISOCurrencyCodeEnum.class, getNotionalCurrency2(), this);
		processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, getFixedRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, getIdentifierOfFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, getIndicatorOfTheFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg1TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg1Multiplier(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, getFloatingRateResetFrequencyPeriodOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, getFixedRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, getIdentifierOfFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, getIndicatorOfTheFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
		processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
		processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
		processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
		processor.processBasic(path.newSubPath("level"), String.class, getLevel(), this);
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CommonTransactionReportBuilder extends CommonTransactionReport, RosettaModelObjectBuilder {
		CommonTransactionReport.CommonTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		CommonTransactionReport.CommonTransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		CommonTransactionReport.CommonTransactionReportBuilder setEntityResponsibleForReporting(String entityResponsibleForReporting);
		CommonTransactionReport.CommonTransactionReportBuilder setCounterparty1(String counterparty1);
		CommonTransactionReport.CommonTransactionReportBuilder setNatureOfCounterparty1(String natureOfCounterparty1);
		CommonTransactionReport.CommonTransactionReportBuilder setCorporateSectorOfTheCounterparty1(String corporateSectorOfTheCounterparty1);
		CommonTransactionReport.CommonTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean clearingThresholdOfCounterparty1);
		CommonTransactionReport.CommonTransactionReportBuilder setCounterparty2(String counterparty2);
		CommonTransactionReport.CommonTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum countryOfTheCounterParty2);
		CommonTransactionReport.CommonTransactionReportBuilder setNatureOfCounterparty2(String natureOfCounterparty2);
		CommonTransactionReport.CommonTransactionReportBuilder setCorporateSectorOfTheCounterparty2(String corporateSectorOfTheCounterparty2);
		CommonTransactionReport.CommonTransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		CommonTransactionReport.CommonTransactionReportBuilder setClearingMember(String clearingMember);
		CommonTransactionReport.CommonTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean clearingThresholdOfCounterparty2);
		CommonTransactionReport.CommonTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean reportingObligationOfTheCounterparty2);
		CommonTransactionReport.CommonTransactionReportBuilder setBrokerID(String brokerID);
		CommonTransactionReport.CommonTransactionReportBuilder setDirection(String direction);
		CommonTransactionReport.CommonTransactionReportBuilder setDirectionOfLeg1(String directionOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setDirectionOfLeg2(String directionOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing);
		CommonTransactionReport.CommonTransactionReportBuilder setUti(String uti);
		CommonTransactionReport.CommonTransactionReportBuilder setReportTrackingNumber(String reportTrackingNumber);
		CommonTransactionReport.CommonTransactionReportBuilder setPriorUTI(String priorUTI);
		CommonTransactionReport.CommonTransactionReportBuilder setPtrrId(String ptrrId);
		CommonTransactionReport.CommonTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		CommonTransactionReport.CommonTransactionReportBuilder setSubsequentPositionUTI(String subsequentPositionUTI);
		CommonTransactionReport.CommonTransactionReportBuilder setIsin(String isin);
		CommonTransactionReport.CommonTransactionReportBuilder setUpi(String upi);
		CommonTransactionReport.CommonTransactionReportBuilder setProductClassification(String productClassification);
		CommonTransactionReport.CommonTransactionReportBuilder setContractType(String contractType);
		CommonTransactionReport.CommonTransactionReportBuilder setAssetClass(String assetClass);
		CommonTransactionReport.CommonTransactionReportBuilder setIsCrypto(Boolean isCrypto);
		CommonTransactionReport.CommonTransactionReportBuilder setUnderlyingIdentificationType(String underlyingIdentificationType);
		CommonTransactionReport.CommonTransactionReportBuilder setUnderlyingIdentification(String underlyingIdentification);
		CommonTransactionReport.CommonTransactionReportBuilder addNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		CommonTransactionReport.CommonTransactionReportBuilder addNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex, int idx);
		CommonTransactionReport.CommonTransactionReportBuilder addNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndex);
		CommonTransactionReport.CommonTransactionReportBuilder setNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndex);
		CommonTransactionReport.CommonTransactionReportBuilder addUnderlyingIndexIndicator(String underlyingIndexIndicator);
		CommonTransactionReport.CommonTransactionReportBuilder addUnderlyingIndexIndicator(String underlyingIndexIndicator, int idx);
		CommonTransactionReport.CommonTransactionReportBuilder addUnderlyingIndexIndicator(List<String> underlyingIndexIndicator);
		CommonTransactionReport.CommonTransactionReportBuilder setUnderlyingIndexIndicator(List<String> underlyingIndexIndicator);
		CommonTransactionReport.CommonTransactionReportBuilder setCustomBasketCode(String customBasketCode);
		CommonTransactionReport.CommonTransactionReportBuilder setSettlementCurrency1(String settlementCurrency1);
		CommonTransactionReport.CommonTransactionReportBuilder setSettlementCurrency2(String settlementCurrency2);
		CommonTransactionReport.CommonTransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		CommonTransactionReport.CommonTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		CommonTransactionReport.CommonTransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		CommonTransactionReport.CommonTransactionReportBuilder setDelta(BigDecimal delta);
		CommonTransactionReport.CommonTransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		CommonTransactionReport.CommonTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		CommonTransactionReport.CommonTransactionReportBuilder setConfirmed(String confirmed);
		CommonTransactionReport.CommonTransactionReportBuilder setClearingObligation(String clearingObligation);
		CommonTransactionReport.CommonTransactionReportBuilder setCleared(String cleared);
		CommonTransactionReport.CommonTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		CommonTransactionReport.CommonTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		CommonTransactionReport.CommonTransactionReportBuilder setMasterAgreementType(String masterAgreementType);
		CommonTransactionReport.CommonTransactionReportBuilder setOtherMasterAgreementType(String otherMasterAgreementType);
		CommonTransactionReport.CommonTransactionReportBuilder setMasterAgreementVersion(Integer masterAgreementVersion);
		CommonTransactionReport.CommonTransactionReportBuilder setIntragroup(Boolean intragroup);
		CommonTransactionReport.CommonTransactionReportBuilder setPtrr(Boolean ptrr);
		CommonTransactionReport.CommonTransactionReportBuilder setTypeOfPTRRTechnique(String typeOfPTRRTechnique);
		CommonTransactionReport.CommonTransactionReportBuilder setPtrrServiceProvider(String ptrrServiceProvider);
		CommonTransactionReport.CommonTransactionReportBuilder setVenueOfExecution(String venueOfExecution);
		CommonTransactionReport.CommonTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		CommonTransactionReport.CommonTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		CommonTransactionReport.CommonTransactionReportBuilder setExpirationDate(Date expirationDate);
		CommonTransactionReport.CommonTransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		CommonTransactionReport.CommonTransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		CommonTransactionReport.CommonTransactionReportBuilder setDeliveryType(String deliveryType);
		CommonTransactionReport.CommonTransactionReportBuilder setNotionalLeg1(BigDecimal notionalLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setNotionalCurrency1(ISOCurrencyCodeEnum notionalCurrency1);
		CommonTransactionReport.CommonTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal totalNotionalQuantityLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal totalNotionalQuantityLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setNotionalLeg2(BigDecimal notionalLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setNotionalCurrency2(ISOCurrencyCodeEnum notionalCurrency2);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRateOfLeg1(BigDecimal fixedRateOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code fixedRateDayCountConventionLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String fixedRatePaymentFrequencyPeriodLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String identifierOfFloatingRateOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String indicatorOfTheFloatingRateOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String nameOfTheFloatingRateOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String floatingRateReferencePeriodOfLeg1TimePeriod);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer floatingRateReferencePeriodOfLeg1Multiplier);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String floatingRateResetFrequencyPeriodOfLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer floatingRateResetFrequencyPeriodMultiplierLeg1);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRateOfLeg2(BigDecimal fixedRateOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code fixedRateDayCountConventionLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String fixedRatePaymentFrequencyPeriodLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String identifierOfFloatingRateOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String indicatorOfTheFloatingRateOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String nameOfTheFloatingRateOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(String floatingRatePaymentFrequencyPeriodOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String floatingRateReferencePeriodOfLeg2TimePeriod);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer floatingRateReferencePeriodOfLeg2Multiplier);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String floatingRateResetFrequencyPeriodOfLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer floatingRateResetFrequencyPeriodMultiplierLeg2);
		CommonTransactionReport.CommonTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		CommonTransactionReport.CommonTransactionReportBuilder setForwardExchangeRate(BigDecimal forwardExchangeRate);
		CommonTransactionReport.CommonTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		CommonTransactionReport.CommonTransactionReportBuilder setBaseProduct(String baseProduct);
		CommonTransactionReport.CommonTransactionReportBuilder setSubProduct(String subProduct);
		CommonTransactionReport.CommonTransactionReportBuilder setFurtherSubProduct(String furtherSubProduct);
		CommonTransactionReport.CommonTransactionReportBuilder setOptionType(String optionType);
		CommonTransactionReport.CommonTransactionReportBuilder setOptionStyle(String optionStyle);
		CommonTransactionReport.CommonTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		CommonTransactionReport.CommonTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		CommonTransactionReport.CommonTransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		CommonTransactionReport.CommonTransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		CommonTransactionReport.CommonTransactionReportBuilder setSeniority(String seniority);
		CommonTransactionReport.CommonTransactionReportBuilder setReferenceEntity(String referenceEntity);
		CommonTransactionReport.CommonTransactionReportBuilder setSeries(Integer series);
		CommonTransactionReport.CommonTransactionReportBuilder setVersion(Integer version);
		CommonTransactionReport.CommonTransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		CommonTransactionReport.CommonTransactionReportBuilder setTranche(Boolean tranche);
		CommonTransactionReport.CommonTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		CommonTransactionReport.CommonTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		CommonTransactionReport.CommonTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		CommonTransactionReport.CommonTransactionReportBuilder setCollateralPortfolioCode(String collateralPortfolioCode);
		CommonTransactionReport.CommonTransactionReportBuilder setEventType(String eventType);
		CommonTransactionReport.CommonTransactionReportBuilder setEventDate(Date eventDate);
		CommonTransactionReport.CommonTransactionReportBuilder setLevel(String level);
		CommonTransactionReport.CommonTransactionReportBuilder setActionType(String actionType);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, getEntityResponsibleForReporting(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty1"), String.class, getNatureOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, getCorporateSectorOfTheCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, getClearingThresholdOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterParty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterParty2(), this);
			processor.processBasic(path.newSubPath("natureOfCounterparty2"), String.class, getNatureOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, getCorporateSectorOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, getClearingThresholdOfCounterparty2(), this);
			processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, getReportingObligationOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("brokerID"), String.class, getBrokerID(), this);
			processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
			processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, getDirectionOfLeg1(), this);
			processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, getDirectionOfLeg2(), this);
			processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this);
			processor.processBasic(path.newSubPath("uti"), String.class, getUti(), this);
			processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, getReportTrackingNumber(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("ptrrId"), String.class, getPtrrId(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, getSubsequentPositionUTI(), this);
			processor.processBasic(path.newSubPath("isin"), String.class, getIsin(), this);
			processor.processBasic(path.newSubPath("upi"), String.class, getUpi(), this);
			processor.processBasic(path.newSubPath("productClassification"), String.class, getProductClassification(), this);
			processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("isCrypto"), Boolean.class, getIsCrypto(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, getUnderlyingIdentification(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("underlyingIndexIndicator"), String.class, getUnderlyingIndexIndicator(), this);
			processor.processBasic(path.newSubPath("customBasketCode"), String.class, getCustomBasketCode(), this);
			processor.processBasic(path.newSubPath("settlementCurrency1"), String.class, getSettlementCurrency1(), this);
			processor.processBasic(path.newSubPath("settlementCurrency2"), String.class, getSettlementCurrency2(), this);
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("delta"), BigDecimal.class, getDelta(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("clearingObligation"), String.class, getClearingObligation(), this);
			processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("masterAgreementType"), String.class, getMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, getOtherMasterAgreementType(), this);
			processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, getMasterAgreementVersion(), this);
			processor.processBasic(path.newSubPath("intragroup"), Boolean.class, getIntragroup(), this);
			processor.processBasic(path.newSubPath("ptrr"), Boolean.class, getPtrr(), this);
			processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), String.class, getTypeOfPTRRTechnique(), this);
			processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, getPtrrServiceProvider(), this);
			processor.processBasic(path.newSubPath("venueOfExecution"), String.class, getVenueOfExecution(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("notionalLeg1"), BigDecimal.class, getNotionalLeg1(), this);
			processor.processBasic(path.newSubPath("notionalCurrency1"), ISOCurrencyCodeEnum.class, getNotionalCurrency1(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg1"), BigDecimal.class, getTotalNotionalQuantityLeg1(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
			processor.processBasic(path.newSubPath("notionalLeg2"), BigDecimal.class, getNotionalLeg2(), this);
			processor.processBasic(path.newSubPath("notionalCurrency2"), ISOCurrencyCodeEnum.class, getNotionalCurrency2(), this);
			processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, getFixedRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg1"), String.class, getFixedRatePaymentFrequencyPeriodLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, getIdentifierOfFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg1"), String.class, getIndicatorOfTheFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg1TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg1Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg1Multiplier(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, getFloatingRateResetFrequencyPeriodOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, getFixedRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodLeg2"), String.class, getFixedRatePaymentFrequencyPeriodLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, getIdentifierOfFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("indicatorOfTheFloatingRateOfLeg2"), String.class, getIndicatorOfTheFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), String.class, getFloatingRatePaymentFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2TimePeriod"), String.class, getFloatingRateReferencePeriodOfLeg2TimePeriod(), this);
			processor.processBasic(path.newSubPath("floatingRateReferencePeriodOfLeg2Multiplier"), Integer.class, getFloatingRateReferencePeriodOfLeg2Multiplier(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this);
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, getForwardExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("baseProduct"), String.class, getBaseProduct(), this);
			processor.processBasic(path.newSubPath("subProduct"), String.class, getSubProduct(), this);
			processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, getFurtherSubProduct(), this);
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("seniority"), String.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("referenceEntity"), String.class, getReferenceEntity(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("version"), Integer.class, getVersion(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("tranche"), Boolean.class, getTranche(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, getCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventDate"), Date.class, getEventDate(), this);
			processor.processBasic(path.newSubPath("level"), String.class, getLevel(), this);
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		}
		

		CommonTransactionReport.CommonTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of CommonTransactionReport  ***********************/
	class CommonTransactionReportImpl implements CommonTransactionReport {
		private final ZonedDateTime reportingTimestamp;
		private final String reportSubmittingEntityID;
		private final String entityResponsibleForReporting;
		private final String counterparty1;
		private final String natureOfCounterparty1;
		private final String corporateSectorOfTheCounterparty1;
		private final Boolean clearingThresholdOfCounterparty1;
		private final String counterparty2;
		private final ISOCountryCodeEnum countryOfTheCounterParty2;
		private final String natureOfCounterparty2;
		private final String corporateSectorOfTheCounterparty2;
		private final Boolean counterparty2IdentifierType;
		private final String clearingMember;
		private final Boolean clearingThresholdOfCounterparty2;
		private final Boolean reportingObligationOfTheCounterparty2;
		private final String brokerID;
		private final String direction;
		private final String directionOfLeg1;
		private final String directionOfLeg2;
		private final Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
		private final String uti;
		private final String reportTrackingNumber;
		private final String priorUTI;
		private final String ptrrId;
		private final String packageIdentifier;
		private final String subsequentPositionUTI;
		private final String isin;
		private final String upi;
		private final String productClassification;
		private final String contractType;
		private final String assetClass;
		private final Boolean isCrypto;
		private final String underlyingIdentificationType;
		private final String underlyingIdentification;
		private final List<String> nameOfTheUnderlyingIndex;
		private final List<String> underlyingIndexIndicator;
		private final String customBasketCode;
		private final String settlementCurrency1;
		private final String settlementCurrency2;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final BigDecimal delta;
		private final ZonedDateTime valuationTimestamp;
		private final ZonedDateTime confirmationTimestamp;
		private final String confirmed;
		private final String clearingObligation;
		private final String cleared;
		private final ZonedDateTime clearingTimestamp;
		private final String centralCounterparty;
		private final String masterAgreementType;
		private final String otherMasterAgreementType;
		private final Integer masterAgreementVersion;
		private final Boolean intragroup;
		private final Boolean ptrr;
		private final String typeOfPTRRTechnique;
		private final String ptrrServiceProvider;
		private final String venueOfExecution;
		private final ZonedDateTime executionTimestamp;
		private final Date effectiveDate;
		private final Date expirationDate;
		private final Date earlyTerminationDate;
		private final Date finalContractualSettlementDate;
		private final String deliveryType;
		private final BigDecimal notionalLeg1;
		private final ISOCurrencyCodeEnum notionalCurrency1;
		private final BigDecimal totalNotionalQuantityLeg1;
		private final BigDecimal totalNotionalQuantityLeg2;
		private final BigDecimal notionalLeg2;
		private final ISOCurrencyCodeEnum notionalCurrency2;
		private final BigDecimal fixedRateOfLeg1;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		private final String fixedRatePaymentFrequencyPeriodLeg1;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		private final String identifierOfFloatingRateOfLeg1;
		private final String indicatorOfTheFloatingRateOfLeg1;
		private final String nameOfTheFloatingRateOfLeg1;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		private final Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		private final String floatingRateReferencePeriodOfLeg1TimePeriod;
		private final Integer floatingRateReferencePeriodOfLeg1Multiplier;
		private final String floatingRateResetFrequencyPeriodOfLeg1;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		private final BigDecimal fixedRateOfLeg2;
		private final InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		private final String fixedRatePaymentFrequencyPeriodLeg2;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		private final String identifierOfFloatingRateOfLeg2;
		private final String indicatorOfTheFloatingRateOfLeg2;
		private final String nameOfTheFloatingRateOfLeg2;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		private final String floatingRatePaymentFrequencyPeriodOfLeg2;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		private final String floatingRateReferencePeriodOfLeg2TimePeriod;
		private final Integer floatingRateReferencePeriodOfLeg2Multiplier;
		private final String floatingRateResetFrequencyPeriodOfLeg2;
		private final Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		private final BigDecimal exchangeRate;
		private final BigDecimal forwardExchangeRate;
		private final String exchangeRateBasis;
		private final String baseProduct;
		private final String subProduct;
		private final String furtherSubProduct;
		private final String optionType;
		private final String optionStyle;
		private final BigDecimal optionPremiumAmount;
		private final ISOCurrencyCodeEnum optionPremiumCurrency;
		private final Date optionPremiumPaymentDate;
		private final Date maturityDateOfTheUnderlying;
		private final String seniority;
		private final String referenceEntity;
		private final Integer series;
		private final Integer version;
		private final BigDecimal indexFactor;
		private final Boolean tranche;
		private final BigDecimal cdSIndexAttachmentPoint;
		private final BigDecimal cdSIndexDetachmentPoint;
		private final Boolean collateralPortfolioIndicator;
		private final String collateralPortfolioCode;
		private final String eventType;
		private final Date eventDate;
		private final String level;
		private final String actionType;
		
		protected CommonTransactionReportImpl(CommonTransactionReport.CommonTransactionReportBuilder builder) {
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
			this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
			this.counterparty1 = builder.getCounterparty1();
			this.natureOfCounterparty1 = builder.getNatureOfCounterparty1();
			this.corporateSectorOfTheCounterparty1 = builder.getCorporateSectorOfTheCounterparty1();
			this.clearingThresholdOfCounterparty1 = builder.getClearingThresholdOfCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.countryOfTheCounterParty2 = builder.getCountryOfTheCounterParty2();
			this.natureOfCounterparty2 = builder.getNatureOfCounterparty2();
			this.corporateSectorOfTheCounterparty2 = builder.getCorporateSectorOfTheCounterparty2();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.clearingMember = builder.getClearingMember();
			this.clearingThresholdOfCounterparty2 = builder.getClearingThresholdOfCounterparty2();
			this.reportingObligationOfTheCounterparty2 = builder.getReportingObligationOfTheCounterparty2();
			this.brokerID = builder.getBrokerID();
			this.direction = builder.getDirection();
			this.directionOfLeg1 = builder.getDirectionOfLeg1();
			this.directionOfLeg2 = builder.getDirectionOfLeg2();
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = builder.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();
			this.uti = builder.getUti();
			this.reportTrackingNumber = builder.getReportTrackingNumber();
			this.priorUTI = builder.getPriorUTI();
			this.ptrrId = builder.getPtrrId();
			this.packageIdentifier = builder.getPackageIdentifier();
			this.subsequentPositionUTI = builder.getSubsequentPositionUTI();
			this.isin = builder.getIsin();
			this.upi = builder.getUpi();
			this.productClassification = builder.getProductClassification();
			this.contractType = builder.getContractType();
			this.assetClass = builder.getAssetClass();
			this.isCrypto = builder.getIsCrypto();
			this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
			this.underlyingIdentification = builder.getUnderlyingIdentification();
			this.nameOfTheUnderlyingIndex = ofNullable(builder.getNameOfTheUnderlyingIndex()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.underlyingIndexIndicator = ofNullable(builder.getUnderlyingIndexIndicator()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.customBasketCode = builder.getCustomBasketCode();
			this.settlementCurrency1 = builder.getSettlementCurrency1();
			this.settlementCurrency2 = builder.getSettlementCurrency2();
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.delta = builder.getDelta();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.confirmationTimestamp = builder.getConfirmationTimestamp();
			this.confirmed = builder.getConfirmed();
			this.clearingObligation = builder.getClearingObligation();
			this.cleared = builder.getCleared();
			this.clearingTimestamp = builder.getClearingTimestamp();
			this.centralCounterparty = builder.getCentralCounterparty();
			this.masterAgreementType = builder.getMasterAgreementType();
			this.otherMasterAgreementType = builder.getOtherMasterAgreementType();
			this.masterAgreementVersion = builder.getMasterAgreementVersion();
			this.intragroup = builder.getIntragroup();
			this.ptrr = builder.getPtrr();
			this.typeOfPTRRTechnique = builder.getTypeOfPTRRTechnique();
			this.ptrrServiceProvider = builder.getPtrrServiceProvider();
			this.venueOfExecution = builder.getVenueOfExecution();
			this.executionTimestamp = builder.getExecutionTimestamp();
			this.effectiveDate = builder.getEffectiveDate();
			this.expirationDate = builder.getExpirationDate();
			this.earlyTerminationDate = builder.getEarlyTerminationDate();
			this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
			this.deliveryType = builder.getDeliveryType();
			this.notionalLeg1 = builder.getNotionalLeg1();
			this.notionalCurrency1 = builder.getNotionalCurrency1();
			this.totalNotionalQuantityLeg1 = builder.getTotalNotionalQuantityLeg1();
			this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
			this.notionalLeg2 = builder.getNotionalLeg2();
			this.notionalCurrency2 = builder.getNotionalCurrency2();
			this.fixedRateOfLeg1 = builder.getFixedRateOfLeg1();
			this.fixedRateDayCountConventionLeg1 = builder.getFixedRateDayCountConventionLeg1();
			this.fixedRatePaymentFrequencyPeriodLeg1 = builder.getFixedRatePaymentFrequencyPeriodLeg1();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg1();
			this.identifierOfFloatingRateOfLeg1 = builder.getIdentifierOfFloatingRateOfLeg1();
			this.indicatorOfTheFloatingRateOfLeg1 = builder.getIndicatorOfTheFloatingRateOfLeg1();
			this.nameOfTheFloatingRateOfLeg1 = builder.getNameOfTheFloatingRateOfLeg1();
			this.floatingRateDayCountConventionOfLeg1 = builder.getFloatingRateDayCountConventionOfLeg1();
			this.floatingRatePaymentFrequencyPeriodOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg1();
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();
			this.floatingRateReferencePeriodOfLeg1TimePeriod = builder.getFloatingRateReferencePeriodOfLeg1TimePeriod();
			this.floatingRateReferencePeriodOfLeg1Multiplier = builder.getFloatingRateReferencePeriodOfLeg1Multiplier();
			this.floatingRateResetFrequencyPeriodOfLeg1 = builder.getFloatingRateResetFrequencyPeriodOfLeg1();
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg1();
			this.fixedRateOfLeg2 = builder.getFixedRateOfLeg2();
			this.fixedRateDayCountConventionLeg2 = builder.getFixedRateDayCountConventionLeg2();
			this.fixedRatePaymentFrequencyPeriodLeg2 = builder.getFixedRatePaymentFrequencyPeriodLeg2();
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = builder.getFixedRatePaymentFrequencyPeriodMultiplierLeg2();
			this.identifierOfFloatingRateOfLeg2 = builder.getIdentifierOfFloatingRateOfLeg2();
			this.indicatorOfTheFloatingRateOfLeg2 = builder.getIndicatorOfTheFloatingRateOfLeg2();
			this.nameOfTheFloatingRateOfLeg2 = builder.getNameOfTheFloatingRateOfLeg2();
			this.floatingRateDayCountConventionOfLeg2 = builder.getFloatingRateDayCountConventionOfLeg2();
			this.floatingRatePaymentFrequencyPeriodOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg2();
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();
			this.floatingRateReferencePeriodOfLeg2TimePeriod = builder.getFloatingRateReferencePeriodOfLeg2TimePeriod();
			this.floatingRateReferencePeriodOfLeg2Multiplier = builder.getFloatingRateReferencePeriodOfLeg2Multiplier();
			this.floatingRateResetFrequencyPeriodOfLeg2 = builder.getFloatingRateResetFrequencyPeriodOfLeg2();
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = builder.getFloatingRateResetFrequencyPeriodMultiplierLeg2();
			this.exchangeRate = builder.getExchangeRate();
			this.forwardExchangeRate = builder.getForwardExchangeRate();
			this.exchangeRateBasis = builder.getExchangeRateBasis();
			this.baseProduct = builder.getBaseProduct();
			this.subProduct = builder.getSubProduct();
			this.furtherSubProduct = builder.getFurtherSubProduct();
			this.optionType = builder.getOptionType();
			this.optionStyle = builder.getOptionStyle();
			this.optionPremiumAmount = builder.getOptionPremiumAmount();
			this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
			this.optionPremiumPaymentDate = builder.getOptionPremiumPaymentDate();
			this.maturityDateOfTheUnderlying = builder.getMaturityDateOfTheUnderlying();
			this.seniority = builder.getSeniority();
			this.referenceEntity = builder.getReferenceEntity();
			this.series = builder.getSeries();
			this.version = builder.getVersion();
			this.indexFactor = builder.getIndexFactor();
			this.tranche = builder.getTranche();
			this.cdSIndexAttachmentPoint = builder.getCdSIndexAttachmentPoint();
			this.cdSIndexDetachmentPoint = builder.getCdSIndexDetachmentPoint();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.collateralPortfolioCode = builder.getCollateralPortfolioCode();
			this.eventType = builder.getEventType();
			this.eventDate = builder.getEventDate();
			this.level = builder.getLevel();
			this.actionType = builder.getActionType();
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		public String getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public String getCorporateSectorOfTheCounterparty1() {
			return corporateSectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public Boolean getClearingThresholdOfCounterparty1() {
			return clearingThresholdOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public String getNatureOfCounterparty2() {
			return natureOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public String getCorporateSectorOfTheCounterparty2() {
			return corporateSectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public Boolean getClearingThresholdOfCounterparty2() {
			return clearingThresholdOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		public Boolean getReportingObligationOfTheCounterparty2() {
			return reportingObligationOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public String getBrokerID() {
			return brokerID;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		public String getDirectionOfLeg1() {
			return directionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		public String getDirectionOfLeg2() {
			return directionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
			return directlyLinkedToCommercialActivityOrTreasuryFinancing;
		}
		
		@Override
		@RosettaAttribute(value="uti", isRequired=true)
		@RuneAttribute(value="uti", isRequired=true)
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public String getPtrrId() {
			return ptrrId;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public String getIsin() {
			return isin;
		}
		
		@Override
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		public String getUpi() {
			return upi;
		}
		
		@Override
		@RosettaAttribute(value="productClassification", isRequired=true)
		@RuneAttribute(value="productClassification", isRequired=true)
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public List<String> getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		public List<String> getUnderlyingIndexIndicator() {
			return underlyingIndexIndicator;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public String getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		public String getSettlementCurrency2() {
			return settlementCurrency2;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public String getClearingObligation() {
			return clearingObligation;
		}
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public String getOtherMasterAgreementType() {
			return otherMasterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public Boolean getPtrr() {
			return ptrr;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public String getTypeOfPTRRTechnique() {
			return typeOfPTRRTechnique;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public String getPtrrServiceProvider() {
			return ptrrServiceProvider;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public String getVenueOfExecution() {
			return venueOfExecution;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public Date getEarlyTerminationDate() {
			return earlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute(value="notionalCurrency1", isRequired=true)
		@RuneAttribute(value="notionalCurrency1", isRequired=true)
		public ISOCurrencyCodeEnum getNotionalCurrency1() {
			return notionalCurrency1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		public ISOCurrencyCodeEnum getNotionalCurrency2() {
			return notionalCurrency2;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		public BigDecimal getFixedRateOfLeg1() {
			return fixedRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		public String getIdentifierOfFloatingRateOfLeg1() {
			return identifierOfFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		public String getIndicatorOfTheFloatingRateOfLeg1() {
			return indicatorOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
			return floatingRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
			return floatingRateReferencePeriodOfLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
			return floatingRateReferencePeriodOfLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		public String getFloatingRateResetFrequencyPeriodOfLeg1() {
			return floatingRateResetFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		public BigDecimal getFixedRateOfLeg2() {
			return fixedRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		public String getIdentifierOfFloatingRateOfLeg2() {
			return identifierOfFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		public String getIndicatorOfTheFloatingRateOfLeg2() {
			return indicatorOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		public String getFloatingRatePaymentFrequencyPeriodOfLeg2() {
			return floatingRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public Integer getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public Boolean getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public String getCollateralPortfolioCode() {
			return collateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		public String getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		public CommonTransactionReport build() {
			return this;
		}
		
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder toBuilder() {
			CommonTransactionReport.CommonTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CommonTransactionReport.CommonTransactionReportBuilder builder) {
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
			ofNullable(getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getNatureOfCounterparty1()).ifPresent(builder::setNatureOfCounterparty1);
			ofNullable(getCorporateSectorOfTheCounterparty1()).ifPresent(builder::setCorporateSectorOfTheCounterparty1);
			ofNullable(getClearingThresholdOfCounterparty1()).ifPresent(builder::setClearingThresholdOfCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCountryOfTheCounterParty2()).ifPresent(builder::setCountryOfTheCounterParty2);
			ofNullable(getNatureOfCounterparty2()).ifPresent(builder::setNatureOfCounterparty2);
			ofNullable(getCorporateSectorOfTheCounterparty2()).ifPresent(builder::setCorporateSectorOfTheCounterparty2);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getClearingMember()).ifPresent(builder::setClearingMember);
			ofNullable(getClearingThresholdOfCounterparty2()).ifPresent(builder::setClearingThresholdOfCounterparty2);
			ofNullable(getReportingObligationOfTheCounterparty2()).ifPresent(builder::setReportingObligationOfTheCounterparty2);
			ofNullable(getBrokerID()).ifPresent(builder::setBrokerID);
			ofNullable(getDirection()).ifPresent(builder::setDirection);
			ofNullable(getDirectionOfLeg1()).ifPresent(builder::setDirectionOfLeg1);
			ofNullable(getDirectionOfLeg2()).ifPresent(builder::setDirectionOfLeg2);
			ofNullable(getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()).ifPresent(builder::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing);
			ofNullable(getUti()).ifPresent(builder::setUti);
			ofNullable(getReportTrackingNumber()).ifPresent(builder::setReportTrackingNumber);
			ofNullable(getPriorUTI()).ifPresent(builder::setPriorUTI);
			ofNullable(getPtrrId()).ifPresent(builder::setPtrrId);
			ofNullable(getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
			ofNullable(getSubsequentPositionUTI()).ifPresent(builder::setSubsequentPositionUTI);
			ofNullable(getIsin()).ifPresent(builder::setIsin);
			ofNullable(getUpi()).ifPresent(builder::setUpi);
			ofNullable(getProductClassification()).ifPresent(builder::setProductClassification);
			ofNullable(getContractType()).ifPresent(builder::setContractType);
			ofNullable(getAssetClass()).ifPresent(builder::setAssetClass);
			ofNullable(getIsCrypto()).ifPresent(builder::setIsCrypto);
			ofNullable(getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
			ofNullable(getUnderlyingIdentification()).ifPresent(builder::setUnderlyingIdentification);
			ofNullable(getNameOfTheUnderlyingIndex()).ifPresent(builder::setNameOfTheUnderlyingIndex);
			ofNullable(getUnderlyingIndexIndicator()).ifPresent(builder::setUnderlyingIndexIndicator);
			ofNullable(getCustomBasketCode()).ifPresent(builder::setCustomBasketCode);
			ofNullable(getSettlementCurrency1()).ifPresent(builder::setSettlementCurrency1);
			ofNullable(getSettlementCurrency2()).ifPresent(builder::setSettlementCurrency2);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getDelta()).ifPresent(builder::setDelta);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
			ofNullable(getConfirmed()).ifPresent(builder::setConfirmed);
			ofNullable(getClearingObligation()).ifPresent(builder::setClearingObligation);
			ofNullable(getCleared()).ifPresent(builder::setCleared);
			ofNullable(getClearingTimestamp()).ifPresent(builder::setClearingTimestamp);
			ofNullable(getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
			ofNullable(getMasterAgreementType()).ifPresent(builder::setMasterAgreementType);
			ofNullable(getOtherMasterAgreementType()).ifPresent(builder::setOtherMasterAgreementType);
			ofNullable(getMasterAgreementVersion()).ifPresent(builder::setMasterAgreementVersion);
			ofNullable(getIntragroup()).ifPresent(builder::setIntragroup);
			ofNullable(getPtrr()).ifPresent(builder::setPtrr);
			ofNullable(getTypeOfPTRRTechnique()).ifPresent(builder::setTypeOfPTRRTechnique);
			ofNullable(getPtrrServiceProvider()).ifPresent(builder::setPtrrServiceProvider);
			ofNullable(getVenueOfExecution()).ifPresent(builder::setVenueOfExecution);
			ofNullable(getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getExpirationDate()).ifPresent(builder::setExpirationDate);
			ofNullable(getEarlyTerminationDate()).ifPresent(builder::setEarlyTerminationDate);
			ofNullable(getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
			ofNullable(getDeliveryType()).ifPresent(builder::setDeliveryType);
			ofNullable(getNotionalLeg1()).ifPresent(builder::setNotionalLeg1);
			ofNullable(getNotionalCurrency1()).ifPresent(builder::setNotionalCurrency1);
			ofNullable(getTotalNotionalQuantityLeg1()).ifPresent(builder::setTotalNotionalQuantityLeg1);
			ofNullable(getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
			ofNullable(getNotionalLeg2()).ifPresent(builder::setNotionalLeg2);
			ofNullable(getNotionalCurrency2()).ifPresent(builder::setNotionalCurrency2);
			ofNullable(getFixedRateOfLeg1()).ifPresent(builder::setFixedRateOfLeg1);
			ofNullable(getFixedRateDayCountConventionLeg1()).ifPresent(builder::setFixedRateDayCountConventionLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			ofNullable(getIdentifierOfFloatingRateOfLeg1()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg1);
			ofNullable(getIndicatorOfTheFloatingRateOfLeg1()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg1);
			ofNullable(getNameOfTheFloatingRateOfLeg1()).ifPresent(builder::setNameOfTheFloatingRateOfLeg1);
			ofNullable(getFloatingRateDayCountConventionOfLeg1()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
			ofNullable(getFloatingRateReferencePeriodOfLeg1TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1TimePeriod);
			ofNullable(getFloatingRateReferencePeriodOfLeg1Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg1Multiplier);
			ofNullable(getFloatingRateResetFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			ofNullable(getFixedRateOfLeg2()).ifPresent(builder::setFixedRateOfLeg2);
			ofNullable(getFixedRateDayCountConventionLeg2()).ifPresent(builder::setFixedRateDayCountConventionLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			ofNullable(getIdentifierOfFloatingRateOfLeg2()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg2);
			ofNullable(getIndicatorOfTheFloatingRateOfLeg2()).ifPresent(builder::setIndicatorOfTheFloatingRateOfLeg2);
			ofNullable(getNameOfTheFloatingRateOfLeg2()).ifPresent(builder::setNameOfTheFloatingRateOfLeg2);
			ofNullable(getFloatingRateDayCountConventionOfLeg2()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
			ofNullable(getFloatingRateReferencePeriodOfLeg2TimePeriod()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			ofNullable(getFloatingRateReferencePeriodOfLeg2Multiplier()).ifPresent(builder::setFloatingRateReferencePeriodOfLeg2Multiplier);
			ofNullable(getFloatingRateResetFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			ofNullable(getExchangeRate()).ifPresent(builder::setExchangeRate);
			ofNullable(getForwardExchangeRate()).ifPresent(builder::setForwardExchangeRate);
			ofNullable(getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
			ofNullable(getBaseProduct()).ifPresent(builder::setBaseProduct);
			ofNullable(getSubProduct()).ifPresent(builder::setSubProduct);
			ofNullable(getFurtherSubProduct()).ifPresent(builder::setFurtherSubProduct);
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getOptionStyle()).ifPresent(builder::setOptionStyle);
			ofNullable(getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
			ofNullable(getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
			ofNullable(getOptionPremiumPaymentDate()).ifPresent(builder::setOptionPremiumPaymentDate);
			ofNullable(getMaturityDateOfTheUnderlying()).ifPresent(builder::setMaturityDateOfTheUnderlying);
			ofNullable(getSeniority()).ifPresent(builder::setSeniority);
			ofNullable(getReferenceEntity()).ifPresent(builder::setReferenceEntity);
			ofNullable(getSeries()).ifPresent(builder::setSeries);
			ofNullable(getVersion()).ifPresent(builder::setVersion);
			ofNullable(getIndexFactor()).ifPresent(builder::setIndexFactor);
			ofNullable(getTranche()).ifPresent(builder::setTranche);
			ofNullable(getCdSIndexAttachmentPoint()).ifPresent(builder::setCdSIndexAttachmentPoint);
			ofNullable(getCdSIndexDetachmentPoint()).ifPresent(builder::setCdSIndexDetachmentPoint);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getCollateralPortfolioCode()).ifPresent(builder::setCollateralPortfolioCode);
			ofNullable(getEventType()).ifPresent(builder::setEventType);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
			ofNullable(getLevel()).ifPresent(builder::setLevel);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!Objects.equals(corporateSectorOfTheCounterparty1, _that.getCorporateSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(natureOfCounterparty2, _that.getNatureOfCounterparty2())) return false;
			if (!Objects.equals(corporateSectorOfTheCounterparty2, _that.getCorporateSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) return false;
			if (!Objects.equals(reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) return false;
			if (!Objects.equals(brokerID, _that.getBrokerID())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(directionOfLeg1, _that.getDirectionOfLeg1())) return false;
			if (!Objects.equals(directionOfLeg2, _that.getDirectionOfLeg2())) return false;
			if (!Objects.equals(directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(reportTrackingNumber, _that.getReportTrackingNumber())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(ptrrId, _that.getPtrrId())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(isin, _that.getIsin())) return false;
			if (!Objects.equals(upi, _that.getUpi())) return false;
			if (!Objects.equals(productClassification, _that.getProductClassification())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!ListEquals.listEquals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!ListEquals.listEquals(underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(settlementCurrency1, _that.getSettlementCurrency1())) return false;
			if (!Objects.equals(settlementCurrency2, _that.getSettlementCurrency2())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(clearingObligation, _that.getClearingObligation())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(otherMasterAgreementType, _that.getOtherMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(ptrr, _that.getPtrr())) return false;
			if (!Objects.equals(typeOfPTRRTechnique, _that.getTypeOfPTRRTechnique())) return false;
			if (!Objects.equals(ptrrServiceProvider, _that.getPtrrServiceProvider())) return false;
			if (!Objects.equals(venueOfExecution, _that.getVenueOfExecution())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(earlyTerminationDate, _that.getEarlyTerminationDate())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalCurrency1, _that.getNotionalCurrency1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(notionalCurrency2, _that.getNotionalCurrency2())) return false;
			if (!Objects.equals(fixedRateOfLeg1, _that.getFixedRateOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(fixedRateOfLeg2, _that.getFixedRateOfLeg2())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(forwardExchangeRate, _that.getForwardExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(seniority, _that.getSeniority())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(series, _that.getSeries())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(tranche, _that.getTranche())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralPortfolioCode, _that.getCollateralPortfolioCode())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty1 != null ? corporateSectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty1 != null ? clearingThresholdOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty2 != null ? natureOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty2 != null ? corporateSectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty2 != null ? clearingThresholdOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingObligationOfTheCounterparty2 != null ? reportingObligationOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (brokerID != null ? brokerID.hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg1 != null ? directionOfLeg1.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg2 != null ? directionOfLeg2.hashCode() : 0);
			_result = 31 * _result + (directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (reportTrackingNumber != null ? reportTrackingNumber.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (ptrrId != null ? ptrrId.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (isin != null ? isin.hashCode() : 0);
			_result = 31 * _result + (upi != null ? upi.hashCode() : 0);
			_result = 31 * _result + (productClassification != null ? productClassification.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (underlyingIndexIndicator != null ? underlyingIndexIndicator.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency1 != null ? settlementCurrency1.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency2 != null ? settlementCurrency2.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (clearingObligation != null ? clearingObligation.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (otherMasterAgreementType != null ? otherMasterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (ptrr != null ? ptrr.hashCode() : 0);
			_result = 31 * _result + (typeOfPTRRTechnique != null ? typeOfPTRRTechnique.hashCode() : 0);
			_result = 31 * _result + (ptrrServiceProvider != null ? ptrrServiceProvider.hashCode() : 0);
			_result = 31 * _result + (venueOfExecution != null ? venueOfExecution.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (earlyTerminationDate != null ? earlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency1 != null ? notionalCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency2 != null ? notionalCurrency2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg1 != null ? fixedRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg1 != null ? identifierOfFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg1 != null ? indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg1 != null ? floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1TimePeriod != null ? floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1Multiplier != null ? floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg1 != null ? floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg2 != null ? fixedRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg2 != null ? identifierOfFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg2 != null ? indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg2 != null ? floatingRatePaymentFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (forwardExchangeRate != null ? forwardExchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (seniority != null ? seniority.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (series != null ? series.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (tranche != null ? tranche.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCode != null ? collateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionReport {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"corporateSectorOfTheCounterparty1=" + this.corporateSectorOfTheCounterparty1 + ", " +
				"clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"natureOfCounterparty2=" + this.natureOfCounterparty2 + ", " +
				"corporateSectorOfTheCounterparty2=" + this.corporateSectorOfTheCounterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", " +
				"reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", " +
				"brokerID=" + this.brokerID + ", " +
				"direction=" + this.direction + ", " +
				"directionOfLeg1=" + this.directionOfLeg1 + ", " +
				"directionOfLeg2=" + this.directionOfLeg2 + ", " +
				"directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", " +
				"uti=" + this.uti + ", " +
				"reportTrackingNumber=" + this.reportTrackingNumber + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"ptrrId=" + this.ptrrId + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"isin=" + this.isin + ", " +
				"upi=" + this.upi + ", " +
				"productClassification=" + this.productClassification + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"settlementCurrency1=" + this.settlementCurrency1 + ", " +
				"settlementCurrency2=" + this.settlementCurrency2 + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"confirmed=" + this.confirmed + ", " +
				"clearingObligation=" + this.clearingObligation + ", " +
				"cleared=" + this.cleared + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"otherMasterAgreementType=" + this.otherMasterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"intragroup=" + this.intragroup + ", " +
				"ptrr=" + this.ptrr + ", " +
				"typeOfPTRRTechnique=" + this.typeOfPTRRTechnique + ", " +
				"ptrrServiceProvider=" + this.ptrrServiceProvider + ", " +
				"venueOfExecution=" + this.venueOfExecution + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"earlyTerminationDate=" + this.earlyTerminationDate + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalCurrency1=" + this.notionalCurrency1 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"notionalCurrency2=" + this.notionalCurrency2 + ", " +
				"fixedRateOfLeg1=" + this.fixedRateOfLeg1 + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", " +
				"indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg1=" + this.floatingRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"fixedRateOfLeg2=" + this.fixedRateOfLeg2 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", " +
				"indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg2=" + this.floatingRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"forwardExchangeRate=" + this.forwardExchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"seniority=" + this.seniority + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"series=" + this.series + ", " +
				"version=" + this.version + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"tranche=" + this.tranche + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralPortfolioCode=" + this.collateralPortfolioCode + ", " +
				"eventType=" + this.eventType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"level=" + this.level + ", " +
				"actionType=" + this.actionType +
			'}';
		}
	}

	/*********************** Builder Implementation of CommonTransactionReport  ***********************/
	class CommonTransactionReportBuilderImpl implements CommonTransactionReport.CommonTransactionReportBuilder {
	
		protected ZonedDateTime reportingTimestamp;
		protected String reportSubmittingEntityID;
		protected String entityResponsibleForReporting;
		protected String counterparty1;
		protected String natureOfCounterparty1;
		protected String corporateSectorOfTheCounterparty1;
		protected Boolean clearingThresholdOfCounterparty1;
		protected String counterparty2;
		protected ISOCountryCodeEnum countryOfTheCounterParty2;
		protected String natureOfCounterparty2;
		protected String corporateSectorOfTheCounterparty2;
		protected Boolean counterparty2IdentifierType;
		protected String clearingMember;
		protected Boolean clearingThresholdOfCounterparty2;
		protected Boolean reportingObligationOfTheCounterparty2;
		protected String brokerID;
		protected String direction;
		protected String directionOfLeg1;
		protected String directionOfLeg2;
		protected Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
		protected String uti;
		protected String reportTrackingNumber;
		protected String priorUTI;
		protected String ptrrId;
		protected String packageIdentifier;
		protected String subsequentPositionUTI;
		protected String isin;
		protected String upi;
		protected String productClassification;
		protected String contractType;
		protected String assetClass;
		protected Boolean isCrypto;
		protected String underlyingIdentificationType;
		protected String underlyingIdentification;
		protected List<String> nameOfTheUnderlyingIndex = new ArrayList<>();
		protected List<String> underlyingIndexIndicator = new ArrayList<>();
		protected String customBasketCode;
		protected String settlementCurrency1;
		protected String settlementCurrency2;
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected BigDecimal delta;
		protected ZonedDateTime valuationTimestamp;
		protected ZonedDateTime confirmationTimestamp;
		protected String confirmed;
		protected String clearingObligation;
		protected String cleared;
		protected ZonedDateTime clearingTimestamp;
		protected String centralCounterparty;
		protected String masterAgreementType;
		protected String otherMasterAgreementType;
		protected Integer masterAgreementVersion;
		protected Boolean intragroup;
		protected Boolean ptrr;
		protected String typeOfPTRRTechnique;
		protected String ptrrServiceProvider;
		protected String venueOfExecution;
		protected ZonedDateTime executionTimestamp;
		protected Date effectiveDate;
		protected Date expirationDate;
		protected Date earlyTerminationDate;
		protected Date finalContractualSettlementDate;
		protected String deliveryType;
		protected BigDecimal notionalLeg1;
		protected ISOCurrencyCodeEnum notionalCurrency1;
		protected BigDecimal totalNotionalQuantityLeg1;
		protected BigDecimal totalNotionalQuantityLeg2;
		protected BigDecimal notionalLeg2;
		protected ISOCurrencyCodeEnum notionalCurrency2;
		protected BigDecimal fixedRateOfLeg1;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg1;
		protected String fixedRatePaymentFrequencyPeriodLeg1;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		protected String identifierOfFloatingRateOfLeg1;
		protected String indicatorOfTheFloatingRateOfLeg1;
		protected String nameOfTheFloatingRateOfLeg1;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		protected Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		protected String floatingRateReferencePeriodOfLeg1TimePeriod;
		protected Integer floatingRateReferencePeriodOfLeg1Multiplier;
		protected String floatingRateResetFrequencyPeriodOfLeg1;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg1;
		protected BigDecimal fixedRateOfLeg2;
		protected InterestComputationMethod4Code fixedRateDayCountConventionLeg2;
		protected String fixedRatePaymentFrequencyPeriodLeg2;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		protected String identifierOfFloatingRateOfLeg2;
		protected String indicatorOfTheFloatingRateOfLeg2;
		protected String nameOfTheFloatingRateOfLeg2;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		protected String floatingRatePaymentFrequencyPeriodOfLeg2;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		protected String floatingRateReferencePeriodOfLeg2TimePeriod;
		protected Integer floatingRateReferencePeriodOfLeg2Multiplier;
		protected String floatingRateResetFrequencyPeriodOfLeg2;
		protected Integer floatingRateResetFrequencyPeriodMultiplierLeg2;
		protected BigDecimal exchangeRate;
		protected BigDecimal forwardExchangeRate;
		protected String exchangeRateBasis;
		protected String baseProduct;
		protected String subProduct;
		protected String furtherSubProduct;
		protected String optionType;
		protected String optionStyle;
		protected BigDecimal optionPremiumAmount;
		protected ISOCurrencyCodeEnum optionPremiumCurrency;
		protected Date optionPremiumPaymentDate;
		protected Date maturityDateOfTheUnderlying;
		protected String seniority;
		protected String referenceEntity;
		protected Integer series;
		protected Integer version;
		protected BigDecimal indexFactor;
		protected Boolean tranche;
		protected BigDecimal cdSIndexAttachmentPoint;
		protected BigDecimal cdSIndexDetachmentPoint;
		protected Boolean collateralPortfolioIndicator;
		protected String collateralPortfolioCode;
		protected String eventType;
		protected Date eventDate;
		protected String level;
		protected String actionType;
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		public String getReportSubmittingEntityID() {
			return reportSubmittingEntityID;
		}
		
		@Override
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		public String getEntityResponsibleForReporting() {
			return entityResponsibleForReporting;
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		public String getNatureOfCounterparty1() {
			return natureOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		public String getCorporateSectorOfTheCounterparty1() {
			return corporateSectorOfTheCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		public Boolean getClearingThresholdOfCounterparty1() {
			return clearingThresholdOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		public ISOCountryCodeEnum getCountryOfTheCounterParty2() {
			return countryOfTheCounterParty2;
		}
		
		@Override
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		public String getNatureOfCounterparty2() {
			return natureOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		public String getCorporateSectorOfTheCounterparty2() {
			return corporateSectorOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		public Boolean getClearingThresholdOfCounterparty2() {
			return clearingThresholdOfCounterparty2;
		}
		
		@Override
		@RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		public Boolean getReportingObligationOfTheCounterparty2() {
			return reportingObligationOfTheCounterparty2;
		}
		
		@Override
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		public String getBrokerID() {
			return brokerID;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		public String getDirectionOfLeg1() {
			return directionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		public String getDirectionOfLeg2() {
			return directionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
			return directlyLinkedToCommercialActivityOrTreasuryFinancing;
		}
		
		@Override
		@RosettaAttribute(value="uti", isRequired=true)
		@RuneAttribute(value="uti", isRequired=true)
		public String getUti() {
			return uti;
		}
		
		@Override
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		public String getReportTrackingNumber() {
			return reportTrackingNumber;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		public String getPtrrId() {
			return ptrrId;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		public String getSubsequentPositionUTI() {
			return subsequentPositionUTI;
		}
		
		@Override
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		public String getIsin() {
			return isin;
		}
		
		@Override
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		public String getUpi() {
			return upi;
		}
		
		@Override
		@RosettaAttribute(value="productClassification", isRequired=true)
		@RuneAttribute(value="productClassification", isRequired=true)
		public String getProductClassification() {
			return productClassification;
		}
		
		@Override
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		public Boolean getIsCrypto() {
			return isCrypto;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		public String getUnderlyingIdentification() {
			return underlyingIdentification;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public List<String> getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		public List<String> getUnderlyingIndexIndicator() {
			return underlyingIndexIndicator;
		}
		
		@Override
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		public String getCustomBasketCode() {
			return customBasketCode;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public String getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		public String getSettlementCurrency2() {
			return settlementCurrency2;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		public BigDecimal getDelta() {
			return delta;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		public String getClearingObligation() {
			return clearingObligation;
		}
		
		@Override
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		public String getMasterAgreementType() {
			return masterAgreementType;
		}
		
		@Override
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		public String getOtherMasterAgreementType() {
			return otherMasterAgreementType;
		}
		
		@Override
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		public Integer getMasterAgreementVersion() {
			return masterAgreementVersion;
		}
		
		@Override
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		public Boolean getIntragroup() {
			return intragroup;
		}
		
		@Override
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		public Boolean getPtrr() {
			return ptrr;
		}
		
		@Override
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		public String getTypeOfPTRRTechnique() {
			return typeOfPTRRTechnique;
		}
		
		@Override
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		public String getPtrrServiceProvider() {
			return ptrrServiceProvider;
		}
		
		@Override
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		public String getVenueOfExecution() {
			return venueOfExecution;
		}
		
		@Override
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public Date getEarlyTerminationDate() {
			return earlyTerminationDate;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		public BigDecimal getNotionalLeg1() {
			return notionalLeg1;
		}
		
		@Override
		@RosettaAttribute(value="notionalCurrency1", isRequired=true)
		@RuneAttribute(value="notionalCurrency1", isRequired=true)
		public ISOCurrencyCodeEnum getNotionalCurrency1() {
			return notionalCurrency1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		public BigDecimal getTotalNotionalQuantityLeg1() {
			return totalNotionalQuantityLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		public BigDecimal getNotionalLeg2() {
			return notionalLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		public ISOCurrencyCodeEnum getNotionalCurrency2() {
			return notionalCurrency2;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		public BigDecimal getFixedRateOfLeg1() {
			return fixedRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg1() {
			return fixedRateDayCountConventionLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		public String getFixedRatePaymentFrequencyPeriodLeg1() {
			return fixedRatePaymentFrequencyPeriodLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		public String getIdentifierOfFloatingRateOfLeg1() {
			return identifierOfFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		public String getIndicatorOfTheFloatingRateOfLeg1() {
			return indicatorOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
			return floatingRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg1TimePeriod() {
			return floatingRateReferencePeriodOfLeg1TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg1Multiplier() {
			return floatingRateReferencePeriodOfLeg1Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		public String getFloatingRateResetFrequencyPeriodOfLeg1() {
			return floatingRateResetFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		public BigDecimal getFixedRateOfLeg2() {
			return fixedRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionLeg2() {
			return fixedRateDayCountConventionLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		public String getFixedRatePaymentFrequencyPeriodLeg2() {
			return fixedRatePaymentFrequencyPeriodLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		public String getIdentifierOfFloatingRateOfLeg2() {
			return identifierOfFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		public String getIndicatorOfTheFloatingRateOfLeg2() {
			return indicatorOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		public String getFloatingRatePaymentFrequencyPeriodOfLeg2() {
			return floatingRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		public String getFloatingRateReferencePeriodOfLeg2TimePeriod() {
			return floatingRateReferencePeriodOfLeg2TimePeriod;
		}
		
		@Override
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		public Integer getFloatingRateReferencePeriodOfLeg2Multiplier() {
			return floatingRateReferencePeriodOfLeg2Multiplier;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierLeg2;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		public BigDecimal getForwardExchangeRate() {
			return forwardExchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		public String getBaseProduct() {
			return baseProduct;
		}
		
		@Override
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		public String getSubProduct() {
			return subProduct;
		}
		
		@Override
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		public String getFurtherSubProduct() {
			return furtherSubProduct;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public Date getOptionPremiumPaymentDate() {
			return optionPremiumPaymentDate;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public Date getMaturityDateOfTheUnderlying() {
			return maturityDateOfTheUnderlying;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public String getSeniority() {
			return seniority;
		}
		
		@Override
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		public String getReferenceEntity() {
			return referenceEntity;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public Integer getSeries() {
			return series;
		}
		
		@Override
		@RosettaAttribute("version")
		@RuneAttribute("version")
		public Integer getVersion() {
			return version;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public BigDecimal getIndexFactor() {
			return indexFactor;
		}
		
		@Override
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		public Boolean getTranche() {
			return tranche;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public BigDecimal getCdSIndexAttachmentPoint() {
			return cdSIndexAttachmentPoint;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public BigDecimal getCdSIndexDetachmentPoint() {
			return cdSIndexDetachmentPoint;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		public String getCollateralPortfolioCode() {
			return collateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public Date getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		public String getLevel() {
			return level;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
		@RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@RosettaAttribute("entityResponsibleForReporting")
		@RuneAttribute("entityResponsibleForReporting")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
			this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
			return this;
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="natureOfCounterparty1", isRequired=true)
		@RuneAttribute(value="natureOfCounterparty1", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNatureOfCounterparty1(String _natureOfCounterparty1) {
			this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
			return this;
		}
		
		@RosettaAttribute("corporateSectorOfTheCounterparty1")
		@RuneAttribute("corporateSectorOfTheCounterparty1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
			this.corporateSectorOfTheCounterparty1 = _corporateSectorOfTheCounterparty1 == null ? null : _corporateSectorOfTheCounterparty1;
			return this;
		}
		
		@RosettaAttribute("clearingThresholdOfCounterparty1")
		@RuneAttribute("clearingThresholdOfCounterparty1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean _clearingThresholdOfCounterparty1) {
			this.clearingThresholdOfCounterparty1 = _clearingThresholdOfCounterparty1 == null ? null : _clearingThresholdOfCounterparty1;
			return this;
		}
		
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute("countryOfTheCounterParty2")
		@RuneAttribute("countryOfTheCounterParty2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCountryOfTheCounterParty2(ISOCountryCodeEnum _countryOfTheCounterParty2) {
			this.countryOfTheCounterParty2 = _countryOfTheCounterParty2 == null ? null : _countryOfTheCounterParty2;
			return this;
		}
		
		@RosettaAttribute("natureOfCounterparty2")
		@RuneAttribute("natureOfCounterparty2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNatureOfCounterparty2(String _natureOfCounterparty2) {
			this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
			return this;
		}
		
		@RosettaAttribute("corporateSectorOfTheCounterparty2")
		@RuneAttribute("corporateSectorOfTheCounterparty2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
			this.corporateSectorOfTheCounterparty2 = _corporateSectorOfTheCounterparty2 == null ? null : _corporateSectorOfTheCounterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@RosettaAttribute("clearingThresholdOfCounterparty2")
		@RuneAttribute("clearingThresholdOfCounterparty2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean _clearingThresholdOfCounterparty2) {
			this.clearingThresholdOfCounterparty2 = _clearingThresholdOfCounterparty2 == null ? null : _clearingThresholdOfCounterparty2;
			return this;
		}
		
		@RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean _reportingObligationOfTheCounterparty2) {
			this.reportingObligationOfTheCounterparty2 = _reportingObligationOfTheCounterparty2 == null ? null : _reportingObligationOfTheCounterparty2;
			return this;
		}
		
		@RosettaAttribute("brokerID")
		@RuneAttribute("brokerID")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setBrokerID(String _brokerID) {
			this.brokerID = _brokerID == null ? null : _brokerID;
			return this;
		}
		
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setDirection(String _direction) {
			this.direction = _direction == null ? null : _direction;
			return this;
		}
		
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setDirectionOfLeg1(String _directionOfLeg1) {
			this.directionOfLeg1 = _directionOfLeg1 == null ? null : _directionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setDirectionOfLeg2(String _directionOfLeg2) {
			this.directionOfLeg2 = _directionOfLeg2 == null ? null : _directionOfLeg2;
			return this;
		}
		
		@RosettaAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@RuneAttribute("directlyLinkedToCommercialActivityOrTreasuryFinancing")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean _directlyLinkedToCommercialActivityOrTreasuryFinancing) {
			this.directlyLinkedToCommercialActivityOrTreasuryFinancing = _directlyLinkedToCommercialActivityOrTreasuryFinancing == null ? null : _directlyLinkedToCommercialActivityOrTreasuryFinancing;
			return this;
		}
		
		@RosettaAttribute(value="uti", isRequired=true)
		@RuneAttribute(value="uti", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setUti(String _uti) {
			this.uti = _uti == null ? null : _uti;
			return this;
		}
		
		@RosettaAttribute("reportTrackingNumber")
		@RuneAttribute("reportTrackingNumber")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setReportTrackingNumber(String _reportTrackingNumber) {
			this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
			return this;
		}
		
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@RosettaAttribute("ptrrId")
		@RuneAttribute("ptrrId")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setPtrrId(String _ptrrId) {
			this.ptrrId = _ptrrId == null ? null : _ptrrId;
			return this;
		}
		
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@RosettaAttribute("subsequentPositionUTI")
		@RuneAttribute("subsequentPositionUTI")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
			this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
			return this;
		}
		
		@RosettaAttribute("isin")
		@RuneAttribute("isin")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIsin(String _isin) {
			this.isin = _isin == null ? null : _isin;
			return this;
		}
		
		@RosettaAttribute("upi")
		@RuneAttribute("upi")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setUpi(String _upi) {
			this.upi = _upi == null ? null : _upi;
			return this;
		}
		
		@RosettaAttribute(value="productClassification", isRequired=true)
		@RuneAttribute(value="productClassification", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setProductClassification(String _productClassification) {
			this.productClassification = _productClassification == null ? null : _productClassification;
			return this;
		}
		
		@RosettaAttribute(value="contractType", isRequired=true)
		@RuneAttribute(value="contractType", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setContractType(String _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setAssetClass(String _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@RosettaAttribute(value="isCrypto", isRequired=true)
		@RuneAttribute(value="isCrypto", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIsCrypto(Boolean _isCrypto) {
			this.isCrypto = _isCrypto == null ? null : _isCrypto;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentification")
		@RuneAttribute("underlyingIdentification")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
			this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
			return this;
		}
		
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder addNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			if (_nameOfTheUnderlyingIndex != null) {
				this.nameOfTheUnderlyingIndex.add(_nameOfTheUnderlyingIndex);
			}
			return this;
		}
		
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder addNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex, int idx) {
			getIndex(this.nameOfTheUnderlyingIndex, idx, () -> _nameOfTheUnderlyingIndex);
			return this;
		}
		
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder addNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndexs) {
			if (nameOfTheUnderlyingIndexs != null) {
				for (final String toAdd : nameOfTheUnderlyingIndexs) {
					this.nameOfTheUnderlyingIndex.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("nameOfTheUnderlyingIndex")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNameOfTheUnderlyingIndex(List<String> nameOfTheUnderlyingIndexs) {
			if (nameOfTheUnderlyingIndexs == null) {
				this.nameOfTheUnderlyingIndex = new ArrayList<>();
			} else {
				this.nameOfTheUnderlyingIndex = nameOfTheUnderlyingIndexs.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("underlyingIndexIndicator")
		@RuneAttribute("underlyingIndexIndicator")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder addUnderlyingIndexIndicator(String _underlyingIndexIndicator) {
			if (_underlyingIndexIndicator != null) {
				this.underlyingIndexIndicator.add(_underlyingIndexIndicator);
			}
			return this;
		}
		
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder addUnderlyingIndexIndicator(String _underlyingIndexIndicator, int idx) {
			getIndex(this.underlyingIndexIndicator, idx, () -> _underlyingIndexIndicator);
			return this;
		}
		
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder addUnderlyingIndexIndicator(List<String> underlyingIndexIndicators) {
			if (underlyingIndexIndicators != null) {
				for (final String toAdd : underlyingIndexIndicators) {
					this.underlyingIndexIndicator.add(toAdd);
				}
			}
			return this;
		}
		
		@RuneAttribute("underlyingIndexIndicator")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setUnderlyingIndexIndicator(List<String> underlyingIndexIndicators) {
			if (underlyingIndexIndicators == null) {
				this.underlyingIndexIndicator = new ArrayList<>();
			} else {
				this.underlyingIndexIndicator = underlyingIndexIndicators.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("customBasketCode")
		@RuneAttribute("customBasketCode")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
			this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
			return this;
		}
		
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setSettlementCurrency1(String _settlementCurrency1) {
			this.settlementCurrency1 = _settlementCurrency1 == null ? null : _settlementCurrency1;
			return this;
		}
		
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setSettlementCurrency2(String _settlementCurrency2) {
			this.settlementCurrency2 = _settlementCurrency2 == null ? null : _settlementCurrency2;
			return this;
		}
		
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("delta")
		@RuneAttribute("delta")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setDelta(BigDecimal _delta) {
			this.delta = _delta == null ? null : _delta;
			return this;
		}
		
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setConfirmed(String _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@RosettaAttribute("clearingObligation")
		@RuneAttribute("clearingObligation")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setClearingObligation(String _clearingObligation) {
			this.clearingObligation = _clearingObligation == null ? null : _clearingObligation;
			return this;
		}
		
		@RosettaAttribute(value="cleared", isRequired=true)
		@RuneAttribute(value="cleared", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCleared(String _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@RosettaAttribute(value="masterAgreementType", isRequired=true)
		@RuneAttribute(value="masterAgreementType", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setMasterAgreementType(String _masterAgreementType) {
			this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
			return this;
		}
		
		@RosettaAttribute("otherMasterAgreementType")
		@RuneAttribute("otherMasterAgreementType")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setOtherMasterAgreementType(String _otherMasterAgreementType) {
			this.otherMasterAgreementType = _otherMasterAgreementType == null ? null : _otherMasterAgreementType;
			return this;
		}
		
		@RosettaAttribute("masterAgreementVersion")
		@RuneAttribute("masterAgreementVersion")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
			this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
			return this;
		}
		
		@RosettaAttribute("intragroup")
		@RuneAttribute("intragroup")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIntragroup(Boolean _intragroup) {
			this.intragroup = _intragroup == null ? null : _intragroup;
			return this;
		}
		
		@RosettaAttribute("ptrr")
		@RuneAttribute("ptrr")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setPtrr(Boolean _ptrr) {
			this.ptrr = _ptrr == null ? null : _ptrr;
			return this;
		}
		
		@RosettaAttribute("typeOfPTRRTechnique")
		@RuneAttribute("typeOfPTRRTechnique")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setTypeOfPTRRTechnique(String _typeOfPTRRTechnique) {
			this.typeOfPTRRTechnique = _typeOfPTRRTechnique == null ? null : _typeOfPTRRTechnique;
			return this;
		}
		
		@RosettaAttribute("ptrrServiceProvider")
		@RuneAttribute("ptrrServiceProvider")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setPtrrServiceProvider(String _ptrrServiceProvider) {
			this.ptrrServiceProvider = _ptrrServiceProvider == null ? null : _ptrrServiceProvider;
			return this;
		}
		
		@RosettaAttribute("venueOfExecution")
		@RuneAttribute("venueOfExecution")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setVenueOfExecution(String _venueOfExecution) {
			this.venueOfExecution = _venueOfExecution == null ? null : _venueOfExecution;
			return this;
		}
		
		@RosettaAttribute(value="executionTimestamp", isRequired=true)
		@RuneAttribute(value="executionTimestamp", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="effectiveDate", isRequired=true)
		@RuneAttribute(value="effectiveDate", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@RosettaAttribute(value="deliveryType", isRequired=true)
		@RuneAttribute(value="deliveryType", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setDeliveryType(String _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@RosettaAttribute("notionalLeg1")
		@RuneAttribute("notionalLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNotionalLeg1(BigDecimal _notionalLeg1) {
			this.notionalLeg1 = _notionalLeg1 == null ? null : _notionalLeg1;
			return this;
		}
		
		@RosettaAttribute(value="notionalCurrency1", isRequired=true)
		@RuneAttribute(value="notionalCurrency1", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNotionalCurrency1(ISOCurrencyCodeEnum _notionalCurrency1) {
			this.notionalCurrency1 = _notionalCurrency1 == null ? null : _notionalCurrency1;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg1")
		@RuneAttribute("totalNotionalQuantityLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setTotalNotionalQuantityLeg1(BigDecimal _totalNotionalQuantityLeg1) {
			this.totalNotionalQuantityLeg1 = _totalNotionalQuantityLeg1 == null ? null : _totalNotionalQuantityLeg1;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
			this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalLeg2")
		@RuneAttribute("notionalLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNotionalLeg2(BigDecimal _notionalLeg2) {
			this.notionalLeg2 = _notionalLeg2 == null ? null : _notionalLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalCurrency2")
		@RuneAttribute("notionalCurrency2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNotionalCurrency2(ISOCurrencyCodeEnum _notionalCurrency2) {
			this.notionalCurrency2 = _notionalCurrency2 == null ? null : _notionalCurrency2;
			return this;
		}
		
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRateOfLeg1(BigDecimal _fixedRateOfLeg1) {
			this.fixedRateOfLeg1 = _fixedRateOfLeg1 == null ? null : _fixedRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg1")
		@RuneAttribute("fixedRateDayCountConventionLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRateDayCountConventionLeg1(InterestComputationMethod4Code _fixedRateDayCountConventionLeg1) {
			this.fixedRateDayCountConventionLeg1 = _fixedRateDayCountConventionLeg1 == null ? null : _fixedRateDayCountConventionLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg1(String _fixedRatePaymentFrequencyPeriodLeg1) {
			this.fixedRatePaymentFrequencyPeriodLeg1 = _fixedRatePaymentFrequencyPeriodLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg1(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg1) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 = _fixedRatePaymentFrequencyPeriodMultiplierLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String _identifierOfFloatingRateOfLeg1) {
			this.identifierOfFloatingRateOfLeg1 = _identifierOfFloatingRateOfLeg1 == null ? null : _identifierOfFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg1")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg1(String _indicatorOfTheFloatingRateOfLeg1) {
			this.indicatorOfTheFloatingRateOfLeg1 = _indicatorOfTheFloatingRateOfLeg1 == null ? null : _indicatorOfTheFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String _nameOfTheFloatingRateOfLeg1) {
			this.nameOfTheFloatingRateOfLeg1 = _nameOfTheFloatingRateOfLeg1 == null ? null : _nameOfTheFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg1) {
			this.floatingRateDayCountConventionOfLeg1 = _floatingRateDayCountConventionOfLeg1 == null ? null : _floatingRateDayCountConventionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 _floatingRatePaymentFrequencyPeriodOfLeg1) {
			this.floatingRatePaymentFrequencyPeriodOfLeg1 = _floatingRatePaymentFrequencyPeriodOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1) {
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1TimePeriod")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1TimePeriod(String _floatingRateReferencePeriodOfLeg1TimePeriod) {
			this.floatingRateReferencePeriodOfLeg1TimePeriod = _floatingRateReferencePeriodOfLeg1TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg1TimePeriod;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg1Multiplier")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg1Multiplier(Integer _floatingRateReferencePeriodOfLeg1Multiplier) {
			this.floatingRateReferencePeriodOfLeg1Multiplier = _floatingRateReferencePeriodOfLeg1Multiplier == null ? null : _floatingRateReferencePeriodOfLeg1Multiplier;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String _floatingRateResetFrequencyPeriodOfLeg1) {
			this.floatingRateResetFrequencyPeriodOfLeg1 = _floatingRateResetFrequencyPeriodOfLeg1 == null ? null : _floatingRateResetFrequencyPeriodOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg1")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg1(Integer _floatingRateResetFrequencyPeriodMultiplierLeg1) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg1 = _floatingRateResetFrequencyPeriodMultiplierLeg1 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRateOfLeg2(BigDecimal _fixedRateOfLeg2) {
			this.fixedRateOfLeg2 = _fixedRateOfLeg2 == null ? null : _fixedRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionLeg2")
		@RuneAttribute("fixedRateDayCountConventionLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRateDayCountConventionLeg2(InterestComputationMethod4Code _fixedRateDayCountConventionLeg2) {
			this.fixedRateDayCountConventionLeg2 = _fixedRateDayCountConventionLeg2 == null ? null : _fixedRateDayCountConventionLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodLeg2(String _fixedRatePaymentFrequencyPeriodLeg2) {
			this.fixedRatePaymentFrequencyPeriodLeg2 = _fixedRatePaymentFrequencyPeriodLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierLeg2(Integer _fixedRatePaymentFrequencyPeriodMultiplierLeg2) {
			this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 = _fixedRatePaymentFrequencyPeriodMultiplierLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String _identifierOfFloatingRateOfLeg2) {
			this.identifierOfFloatingRateOfLeg2 = _identifierOfFloatingRateOfLeg2 == null ? null : _identifierOfFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("indicatorOfTheFloatingRateOfLeg2")
		@RuneAttribute("indicatorOfTheFloatingRateOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIndicatorOfTheFloatingRateOfLeg2(String _indicatorOfTheFloatingRateOfLeg2) {
			this.indicatorOfTheFloatingRateOfLeg2 = _indicatorOfTheFloatingRateOfLeg2 == null ? null : _indicatorOfTheFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String _nameOfTheFloatingRateOfLeg2) {
			this.nameOfTheFloatingRateOfLeg2 = _nameOfTheFloatingRateOfLeg2 == null ? null : _nameOfTheFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg2) {
			this.floatingRateDayCountConventionOfLeg2 = _floatingRateDayCountConventionOfLeg2 == null ? null : _floatingRateDayCountConventionOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(String _floatingRatePaymentFrequencyPeriodOfLeg2) {
			this.floatingRatePaymentFrequencyPeriodOfLeg2 = _floatingRatePaymentFrequencyPeriodOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2) {
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2TimePeriod")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2TimePeriod(String _floatingRateReferencePeriodOfLeg2TimePeriod) {
			this.floatingRateReferencePeriodOfLeg2TimePeriod = _floatingRateReferencePeriodOfLeg2TimePeriod == null ? null : _floatingRateReferencePeriodOfLeg2TimePeriod;
			return this;
		}
		
		@RosettaAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@RuneAttribute("floatingRateReferencePeriodOfLeg2Multiplier")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateReferencePeriodOfLeg2Multiplier(Integer _floatingRateReferencePeriodOfLeg2Multiplier) {
			this.floatingRateReferencePeriodOfLeg2Multiplier = _floatingRateReferencePeriodOfLeg2Multiplier == null ? null : _floatingRateReferencePeriodOfLeg2Multiplier;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String _floatingRateResetFrequencyPeriodOfLeg2) {
			this.floatingRateResetFrequencyPeriodOfLeg2 = _floatingRateResetFrequencyPeriodOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierLeg2")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierLeg2(Integer _floatingRateResetFrequencyPeriodMultiplierLeg2) {
			this.floatingRateResetFrequencyPeriodMultiplierLeg2 = _floatingRateResetFrequencyPeriodMultiplierLeg2 == null ? null : _floatingRateResetFrequencyPeriodMultiplierLeg2;
			return this;
		}
		
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@RosettaAttribute("forwardExchangeRate")
		@RuneAttribute("forwardExchangeRate")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
			this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
			return this;
		}
		
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@RosettaAttribute("baseProduct")
		@RuneAttribute("baseProduct")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setBaseProduct(String _baseProduct) {
			this.baseProduct = _baseProduct == null ? null : _baseProduct;
			return this;
		}
		
		@RosettaAttribute("subProduct")
		@RuneAttribute("subProduct")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setSubProduct(String _subProduct) {
			this.subProduct = _subProduct == null ? null : _subProduct;
			return this;
		}
		
		@RosettaAttribute("furtherSubProduct")
		@RuneAttribute("furtherSubProduct")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
			this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
			return this;
		}
		
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setOptionStyle(String _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setSeniority(String _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@RosettaAttribute("referenceEntity")
		@RuneAttribute("referenceEntity")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
			this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
			return this;
		}
		
		@RosettaAttribute("series")
		@RuneAttribute("series")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@RosettaAttribute("version")
		@RuneAttribute("version")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setVersion(Integer _version) {
			this.version = _version == null ? null : _version;
			return this;
		}
		
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@RosettaAttribute("tranche")
		@RuneAttribute("tranche")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setTranche(Boolean _tranche) {
			this.tranche = _tranche == null ? null : _tranche;
			return this;
		}
		
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioCode")
		@RuneAttribute("collateralPortfolioCode")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
			this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setEventType(String _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setEventDate(Date _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@RosettaAttribute(value="level", isRequired=true)
		@RuneAttribute(value="level", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setLevel(String _level) {
			this.level = _level == null ? null : _level;
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		public CommonTransactionReport build() {
			return new CommonTransactionReport.CommonTransactionReportImpl(this);
		}
		
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getReportingTimestamp()!=null) return true;
			if (getReportSubmittingEntityID()!=null) return true;
			if (getEntityResponsibleForReporting()!=null) return true;
			if (getCounterparty1()!=null) return true;
			if (getNatureOfCounterparty1()!=null) return true;
			if (getCorporateSectorOfTheCounterparty1()!=null) return true;
			if (getClearingThresholdOfCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCountryOfTheCounterParty2()!=null) return true;
			if (getNatureOfCounterparty2()!=null) return true;
			if (getCorporateSectorOfTheCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getClearingMember()!=null) return true;
			if (getClearingThresholdOfCounterparty2()!=null) return true;
			if (getReportingObligationOfTheCounterparty2()!=null) return true;
			if (getBrokerID()!=null) return true;
			if (getDirection()!=null) return true;
			if (getDirectionOfLeg1()!=null) return true;
			if (getDirectionOfLeg2()!=null) return true;
			if (getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()!=null) return true;
			if (getUti()!=null) return true;
			if (getReportTrackingNumber()!=null) return true;
			if (getPriorUTI()!=null) return true;
			if (getPtrrId()!=null) return true;
			if (getPackageIdentifier()!=null) return true;
			if (getSubsequentPositionUTI()!=null) return true;
			if (getIsin()!=null) return true;
			if (getUpi()!=null) return true;
			if (getProductClassification()!=null) return true;
			if (getContractType()!=null) return true;
			if (getAssetClass()!=null) return true;
			if (getIsCrypto()!=null) return true;
			if (getUnderlyingIdentificationType()!=null) return true;
			if (getUnderlyingIdentification()!=null) return true;
			if (getNameOfTheUnderlyingIndex()!=null && !getNameOfTheUnderlyingIndex().isEmpty()) return true;
			if (getUnderlyingIndexIndicator()!=null && !getUnderlyingIndexIndicator().isEmpty()) return true;
			if (getCustomBasketCode()!=null) return true;
			if (getSettlementCurrency1()!=null) return true;
			if (getSettlementCurrency2()!=null) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getDelta()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getConfirmationTimestamp()!=null) return true;
			if (getConfirmed()!=null) return true;
			if (getClearingObligation()!=null) return true;
			if (getCleared()!=null) return true;
			if (getClearingTimestamp()!=null) return true;
			if (getCentralCounterparty()!=null) return true;
			if (getMasterAgreementType()!=null) return true;
			if (getOtherMasterAgreementType()!=null) return true;
			if (getMasterAgreementVersion()!=null) return true;
			if (getIntragroup()!=null) return true;
			if (getPtrr()!=null) return true;
			if (getTypeOfPTRRTechnique()!=null) return true;
			if (getPtrrServiceProvider()!=null) return true;
			if (getVenueOfExecution()!=null) return true;
			if (getExecutionTimestamp()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getExpirationDate()!=null) return true;
			if (getEarlyTerminationDate()!=null) return true;
			if (getFinalContractualSettlementDate()!=null) return true;
			if (getDeliveryType()!=null) return true;
			if (getNotionalLeg1()!=null) return true;
			if (getNotionalCurrency1()!=null) return true;
			if (getTotalNotionalQuantityLeg1()!=null) return true;
			if (getTotalNotionalQuantityLeg2()!=null) return true;
			if (getNotionalLeg2()!=null) return true;
			if (getNotionalCurrency2()!=null) return true;
			if (getFixedRateOfLeg1()!=null) return true;
			if (getFixedRateDayCountConventionLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getIdentifierOfFloatingRateOfLeg1()!=null) return true;
			if (getIndicatorOfTheFloatingRateOfLeg1()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg1()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodOfLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg1TimePeriod()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg1Multiplier()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodOfLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg1()!=null) return true;
			if (getFixedRateOfLeg2()!=null) return true;
			if (getFixedRateDayCountConventionLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getIdentifierOfFloatingRateOfLeg2()!=null) return true;
			if (getIndicatorOfTheFloatingRateOfLeg2()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg2()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodOfLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2TimePeriod()!=null) return true;
			if (getFloatingRateReferencePeriodOfLeg2Multiplier()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodOfLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierLeg2()!=null) return true;
			if (getExchangeRate()!=null) return true;
			if (getForwardExchangeRate()!=null) return true;
			if (getExchangeRateBasis()!=null) return true;
			if (getBaseProduct()!=null) return true;
			if (getSubProduct()!=null) return true;
			if (getFurtherSubProduct()!=null) return true;
			if (getOptionType()!=null) return true;
			if (getOptionStyle()!=null) return true;
			if (getOptionPremiumAmount()!=null) return true;
			if (getOptionPremiumCurrency()!=null) return true;
			if (getOptionPremiumPaymentDate()!=null) return true;
			if (getMaturityDateOfTheUnderlying()!=null) return true;
			if (getSeniority()!=null) return true;
			if (getReferenceEntity()!=null) return true;
			if (getSeries()!=null) return true;
			if (getVersion()!=null) return true;
			if (getIndexFactor()!=null) return true;
			if (getTranche()!=null) return true;
			if (getCdSIndexAttachmentPoint()!=null) return true;
			if (getCdSIndexDetachmentPoint()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getCollateralPortfolioCode()!=null) return true;
			if (getEventType()!=null) return true;
			if (getEventDate()!=null) return true;
			if (getLevel()!=null) return true;
			if (getActionType()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CommonTransactionReport.CommonTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CommonTransactionReport.CommonTransactionReportBuilder o = (CommonTransactionReport.CommonTransactionReportBuilder) other;
			
			
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getReportSubmittingEntityID(), o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID);
			merger.mergeBasic(getEntityResponsibleForReporting(), o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting);
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getNatureOfCounterparty1(), o.getNatureOfCounterparty1(), this::setNatureOfCounterparty1);
			merger.mergeBasic(getCorporateSectorOfTheCounterparty1(), o.getCorporateSectorOfTheCounterparty1(), this::setCorporateSectorOfTheCounterparty1);
			merger.mergeBasic(getClearingThresholdOfCounterparty1(), o.getClearingThresholdOfCounterparty1(), this::setClearingThresholdOfCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCountryOfTheCounterParty2(), o.getCountryOfTheCounterParty2(), this::setCountryOfTheCounterParty2);
			merger.mergeBasic(getNatureOfCounterparty2(), o.getNatureOfCounterparty2(), this::setNatureOfCounterparty2);
			merger.mergeBasic(getCorporateSectorOfTheCounterparty2(), o.getCorporateSectorOfTheCounterparty2(), this::setCorporateSectorOfTheCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getClearingMember(), o.getClearingMember(), this::setClearingMember);
			merger.mergeBasic(getClearingThresholdOfCounterparty2(), o.getClearingThresholdOfCounterparty2(), this::setClearingThresholdOfCounterparty2);
			merger.mergeBasic(getReportingObligationOfTheCounterparty2(), o.getReportingObligationOfTheCounterparty2(), this::setReportingObligationOfTheCounterparty2);
			merger.mergeBasic(getBrokerID(), o.getBrokerID(), this::setBrokerID);
			merger.mergeBasic(getDirection(), o.getDirection(), this::setDirection);
			merger.mergeBasic(getDirectionOfLeg1(), o.getDirectionOfLeg1(), this::setDirectionOfLeg1);
			merger.mergeBasic(getDirectionOfLeg2(), o.getDirectionOfLeg2(), this::setDirectionOfLeg2);
			merger.mergeBasic(getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), o.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing);
			merger.mergeBasic(getUti(), o.getUti(), this::setUti);
			merger.mergeBasic(getReportTrackingNumber(), o.getReportTrackingNumber(), this::setReportTrackingNumber);
			merger.mergeBasic(getPriorUTI(), o.getPriorUTI(), this::setPriorUTI);
			merger.mergeBasic(getPtrrId(), o.getPtrrId(), this::setPtrrId);
			merger.mergeBasic(getPackageIdentifier(), o.getPackageIdentifier(), this::setPackageIdentifier);
			merger.mergeBasic(getSubsequentPositionUTI(), o.getSubsequentPositionUTI(), this::setSubsequentPositionUTI);
			merger.mergeBasic(getIsin(), o.getIsin(), this::setIsin);
			merger.mergeBasic(getUpi(), o.getUpi(), this::setUpi);
			merger.mergeBasic(getProductClassification(), o.getProductClassification(), this::setProductClassification);
			merger.mergeBasic(getContractType(), o.getContractType(), this::setContractType);
			merger.mergeBasic(getAssetClass(), o.getAssetClass(), this::setAssetClass);
			merger.mergeBasic(getIsCrypto(), o.getIsCrypto(), this::setIsCrypto);
			merger.mergeBasic(getUnderlyingIdentificationType(), o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType);
			merger.mergeBasic(getUnderlyingIdentification(), o.getUnderlyingIdentification(), this::setUnderlyingIdentification);
			merger.mergeBasic(getNameOfTheUnderlyingIndex(), o.getNameOfTheUnderlyingIndex(), (Consumer<String>) this::addNameOfTheUnderlyingIndex);
			merger.mergeBasic(getUnderlyingIndexIndicator(), o.getUnderlyingIndexIndicator(), (Consumer<String>) this::addUnderlyingIndexIndicator);
			merger.mergeBasic(getCustomBasketCode(), o.getCustomBasketCode(), this::setCustomBasketCode);
			merger.mergeBasic(getSettlementCurrency1(), o.getSettlementCurrency1(), this::setSettlementCurrency1);
			merger.mergeBasic(getSettlementCurrency2(), o.getSettlementCurrency2(), this::setSettlementCurrency2);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getDelta(), o.getDelta(), this::setDelta);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getConfirmationTimestamp(), o.getConfirmationTimestamp(), this::setConfirmationTimestamp);
			merger.mergeBasic(getConfirmed(), o.getConfirmed(), this::setConfirmed);
			merger.mergeBasic(getClearingObligation(), o.getClearingObligation(), this::setClearingObligation);
			merger.mergeBasic(getCleared(), o.getCleared(), this::setCleared);
			merger.mergeBasic(getClearingTimestamp(), o.getClearingTimestamp(), this::setClearingTimestamp);
			merger.mergeBasic(getCentralCounterparty(), o.getCentralCounterparty(), this::setCentralCounterparty);
			merger.mergeBasic(getMasterAgreementType(), o.getMasterAgreementType(), this::setMasterAgreementType);
			merger.mergeBasic(getOtherMasterAgreementType(), o.getOtherMasterAgreementType(), this::setOtherMasterAgreementType);
			merger.mergeBasic(getMasterAgreementVersion(), o.getMasterAgreementVersion(), this::setMasterAgreementVersion);
			merger.mergeBasic(getIntragroup(), o.getIntragroup(), this::setIntragroup);
			merger.mergeBasic(getPtrr(), o.getPtrr(), this::setPtrr);
			merger.mergeBasic(getTypeOfPTRRTechnique(), o.getTypeOfPTRRTechnique(), this::setTypeOfPTRRTechnique);
			merger.mergeBasic(getPtrrServiceProvider(), o.getPtrrServiceProvider(), this::setPtrrServiceProvider);
			merger.mergeBasic(getVenueOfExecution(), o.getVenueOfExecution(), this::setVenueOfExecution);
			merger.mergeBasic(getExecutionTimestamp(), o.getExecutionTimestamp(), this::setExecutionTimestamp);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getExpirationDate(), o.getExpirationDate(), this::setExpirationDate);
			merger.mergeBasic(getEarlyTerminationDate(), o.getEarlyTerminationDate(), this::setEarlyTerminationDate);
			merger.mergeBasic(getFinalContractualSettlementDate(), o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate);
			merger.mergeBasic(getDeliveryType(), o.getDeliveryType(), this::setDeliveryType);
			merger.mergeBasic(getNotionalLeg1(), o.getNotionalLeg1(), this::setNotionalLeg1);
			merger.mergeBasic(getNotionalCurrency1(), o.getNotionalCurrency1(), this::setNotionalCurrency1);
			merger.mergeBasic(getTotalNotionalQuantityLeg1(), o.getTotalNotionalQuantityLeg1(), this::setTotalNotionalQuantityLeg1);
			merger.mergeBasic(getTotalNotionalQuantityLeg2(), o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2);
			merger.mergeBasic(getNotionalLeg2(), o.getNotionalLeg2(), this::setNotionalLeg2);
			merger.mergeBasic(getNotionalCurrency2(), o.getNotionalCurrency2(), this::setNotionalCurrency2);
			merger.mergeBasic(getFixedRateOfLeg1(), o.getFixedRateOfLeg1(), this::setFixedRateOfLeg1);
			merger.mergeBasic(getFixedRateDayCountConventionLeg1(), o.getFixedRateDayCountConventionLeg1(), this::setFixedRateDayCountConventionLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg1(), o.getFixedRatePaymentFrequencyPeriodLeg1(), this::setFixedRatePaymentFrequencyPeriodLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getIdentifierOfFloatingRateOfLeg1(), o.getIdentifierOfFloatingRateOfLeg1(), this::setIdentifierOfFloatingRateOfLeg1);
			merger.mergeBasic(getIndicatorOfTheFloatingRateOfLeg1(), o.getIndicatorOfTheFloatingRateOfLeg1(), this::setIndicatorOfTheFloatingRateOfLeg1);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg1(), o.getNameOfTheFloatingRateOfLeg1(), this::setNameOfTheFloatingRateOfLeg1);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg1(), o.getFloatingRateDayCountConventionOfLeg1(), this::setFloatingRateDayCountConventionOfLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodOfLeg1(), o.getFloatingRatePaymentFrequencyPeriodOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodOfLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg1TimePeriod(), o.getFloatingRateReferencePeriodOfLeg1TimePeriod(), this::setFloatingRateReferencePeriodOfLeg1TimePeriod);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg1Multiplier(), o.getFloatingRateReferencePeriodOfLeg1Multiplier(), this::setFloatingRateReferencePeriodOfLeg1Multiplier);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodOfLeg1(), o.getFloatingRateResetFrequencyPeriodOfLeg1(), this::setFloatingRateResetFrequencyPeriodOfLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg1(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg1(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg1);
			merger.mergeBasic(getFixedRateOfLeg2(), o.getFixedRateOfLeg2(), this::setFixedRateOfLeg2);
			merger.mergeBasic(getFixedRateDayCountConventionLeg2(), o.getFixedRateDayCountConventionLeg2(), this::setFixedRateDayCountConventionLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodLeg2(), o.getFixedRatePaymentFrequencyPeriodLeg2(), this::setFixedRatePaymentFrequencyPeriodLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2(), this::setFixedRatePaymentFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getIdentifierOfFloatingRateOfLeg2(), o.getIdentifierOfFloatingRateOfLeg2(), this::setIdentifierOfFloatingRateOfLeg2);
			merger.mergeBasic(getIndicatorOfTheFloatingRateOfLeg2(), o.getIndicatorOfTheFloatingRateOfLeg2(), this::setIndicatorOfTheFloatingRateOfLeg2);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg2(), o.getNameOfTheFloatingRateOfLeg2(), this::setNameOfTheFloatingRateOfLeg2);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg2(), o.getFloatingRateDayCountConventionOfLeg2(), this::setFloatingRateDayCountConventionOfLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodOfLeg2(), o.getFloatingRatePaymentFrequencyPeriodOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2TimePeriod(), o.getFloatingRateReferencePeriodOfLeg2TimePeriod(), this::setFloatingRateReferencePeriodOfLeg2TimePeriod);
			merger.mergeBasic(getFloatingRateReferencePeriodOfLeg2Multiplier(), o.getFloatingRateReferencePeriodOfLeg2Multiplier(), this::setFloatingRateReferencePeriodOfLeg2Multiplier);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodOfLeg2(), o.getFloatingRateResetFrequencyPeriodOfLeg2(), this::setFloatingRateResetFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierLeg2(), o.getFloatingRateResetFrequencyPeriodMultiplierLeg2(), this::setFloatingRateResetFrequencyPeriodMultiplierLeg2);
			merger.mergeBasic(getExchangeRate(), o.getExchangeRate(), this::setExchangeRate);
			merger.mergeBasic(getForwardExchangeRate(), o.getForwardExchangeRate(), this::setForwardExchangeRate);
			merger.mergeBasic(getExchangeRateBasis(), o.getExchangeRateBasis(), this::setExchangeRateBasis);
			merger.mergeBasic(getBaseProduct(), o.getBaseProduct(), this::setBaseProduct);
			merger.mergeBasic(getSubProduct(), o.getSubProduct(), this::setSubProduct);
			merger.mergeBasic(getFurtherSubProduct(), o.getFurtherSubProduct(), this::setFurtherSubProduct);
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getOptionStyle(), o.getOptionStyle(), this::setOptionStyle);
			merger.mergeBasic(getOptionPremiumAmount(), o.getOptionPremiumAmount(), this::setOptionPremiumAmount);
			merger.mergeBasic(getOptionPremiumCurrency(), o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency);
			merger.mergeBasic(getOptionPremiumPaymentDate(), o.getOptionPremiumPaymentDate(), this::setOptionPremiumPaymentDate);
			merger.mergeBasic(getMaturityDateOfTheUnderlying(), o.getMaturityDateOfTheUnderlying(), this::setMaturityDateOfTheUnderlying);
			merger.mergeBasic(getSeniority(), o.getSeniority(), this::setSeniority);
			merger.mergeBasic(getReferenceEntity(), o.getReferenceEntity(), this::setReferenceEntity);
			merger.mergeBasic(getSeries(), o.getSeries(), this::setSeries);
			merger.mergeBasic(getVersion(), o.getVersion(), this::setVersion);
			merger.mergeBasic(getIndexFactor(), o.getIndexFactor(), this::setIndexFactor);
			merger.mergeBasic(getTranche(), o.getTranche(), this::setTranche);
			merger.mergeBasic(getCdSIndexAttachmentPoint(), o.getCdSIndexAttachmentPoint(), this::setCdSIndexAttachmentPoint);
			merger.mergeBasic(getCdSIndexDetachmentPoint(), o.getCdSIndexDetachmentPoint(), this::setCdSIndexDetachmentPoint);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getCollateralPortfolioCode(), o.getCollateralPortfolioCode(), this::setCollateralPortfolioCode);
			merger.mergeBasic(getEventType(), o.getEventType(), this::setEventType);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			merger.mergeBasic(getLevel(), o.getLevel(), this::setLevel);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CommonTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!Objects.equals(reportSubmittingEntityID, _that.getReportSubmittingEntityID())) return false;
			if (!Objects.equals(entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) return false;
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(natureOfCounterparty1, _that.getNatureOfCounterparty1())) return false;
			if (!Objects.equals(corporateSectorOfTheCounterparty1, _that.getCorporateSectorOfTheCounterparty1())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(countryOfTheCounterParty2, _that.getCountryOfTheCounterParty2())) return false;
			if (!Objects.equals(natureOfCounterparty2, _that.getNatureOfCounterparty2())) return false;
			if (!Objects.equals(corporateSectorOfTheCounterparty2, _that.getCorporateSectorOfTheCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) return false;
			if (!Objects.equals(reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) return false;
			if (!Objects.equals(brokerID, _that.getBrokerID())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(directionOfLeg1, _that.getDirectionOfLeg1())) return false;
			if (!Objects.equals(directionOfLeg2, _that.getDirectionOfLeg2())) return false;
			if (!Objects.equals(directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) return false;
			if (!Objects.equals(uti, _that.getUti())) return false;
			if (!Objects.equals(reportTrackingNumber, _that.getReportTrackingNumber())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(ptrrId, _that.getPtrrId())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(subsequentPositionUTI, _that.getSubsequentPositionUTI())) return false;
			if (!Objects.equals(isin, _that.getIsin())) return false;
			if (!Objects.equals(upi, _that.getUpi())) return false;
			if (!Objects.equals(productClassification, _that.getProductClassification())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(isCrypto, _that.getIsCrypto())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdentification, _that.getUnderlyingIdentification())) return false;
			if (!ListEquals.listEquals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!ListEquals.listEquals(underlyingIndexIndicator, _that.getUnderlyingIndexIndicator())) return false;
			if (!Objects.equals(customBasketCode, _that.getCustomBasketCode())) return false;
			if (!Objects.equals(settlementCurrency1, _that.getSettlementCurrency1())) return false;
			if (!Objects.equals(settlementCurrency2, _that.getSettlementCurrency2())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(delta, _that.getDelta())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(clearingObligation, _that.getClearingObligation())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(masterAgreementType, _that.getMasterAgreementType())) return false;
			if (!Objects.equals(otherMasterAgreementType, _that.getOtherMasterAgreementType())) return false;
			if (!Objects.equals(masterAgreementVersion, _that.getMasterAgreementVersion())) return false;
			if (!Objects.equals(intragroup, _that.getIntragroup())) return false;
			if (!Objects.equals(ptrr, _that.getPtrr())) return false;
			if (!Objects.equals(typeOfPTRRTechnique, _that.getTypeOfPTRRTechnique())) return false;
			if (!Objects.equals(ptrrServiceProvider, _that.getPtrrServiceProvider())) return false;
			if (!Objects.equals(venueOfExecution, _that.getVenueOfExecution())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(earlyTerminationDate, _that.getEarlyTerminationDate())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(notionalLeg1, _that.getNotionalLeg1())) return false;
			if (!Objects.equals(notionalCurrency1, _that.getNotionalCurrency1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg1, _that.getTotalNotionalQuantityLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(notionalLeg2, _that.getNotionalLeg2())) return false;
			if (!Objects.equals(notionalCurrency2, _that.getNotionalCurrency2())) return false;
			if (!Objects.equals(fixedRateOfLeg1, _that.getFixedRateOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg1, _that.getFixedRateDayCountConventionLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg1, _that.getFixedRatePaymentFrequencyPeriodLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg1, _that.getIndicatorOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1TimePeriod, _that.getFloatingRateReferencePeriodOfLeg1TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg1Multiplier, _that.getFloatingRateReferencePeriodOfLeg1Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg1())) return false;
			if (!Objects.equals(fixedRateOfLeg2, _that.getFixedRateOfLeg2())) return false;
			if (!Objects.equals(fixedRateDayCountConventionLeg2, _that.getFixedRateDayCountConventionLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodLeg2, _that.getFixedRatePaymentFrequencyPeriodLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) return false;
			if (!Objects.equals(indicatorOfTheFloatingRateOfLeg2, _that.getIndicatorOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2TimePeriod, _that.getFloatingRateReferencePeriodOfLeg2TimePeriod())) return false;
			if (!Objects.equals(floatingRateReferencePeriodOfLeg2Multiplier, _that.getFloatingRateReferencePeriodOfLeg2Multiplier())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierLeg2())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(forwardExchangeRate, _that.getForwardExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(baseProduct, _that.getBaseProduct())) return false;
			if (!Objects.equals(subProduct, _that.getSubProduct())) return false;
			if (!Objects.equals(furtherSubProduct, _that.getFurtherSubProduct())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(optionPremiumPaymentDate, _that.getOptionPremiumPaymentDate())) return false;
			if (!Objects.equals(maturityDateOfTheUnderlying, _that.getMaturityDateOfTheUnderlying())) return false;
			if (!Objects.equals(seniority, _that.getSeniority())) return false;
			if (!Objects.equals(referenceEntity, _that.getReferenceEntity())) return false;
			if (!Objects.equals(series, _that.getSeries())) return false;
			if (!Objects.equals(version, _that.getVersion())) return false;
			if (!Objects.equals(indexFactor, _that.getIndexFactor())) return false;
			if (!Objects.equals(tranche, _that.getTranche())) return false;
			if (!Objects.equals(cdSIndexAttachmentPoint, _that.getCdSIndexAttachmentPoint())) return false;
			if (!Objects.equals(cdSIndexDetachmentPoint, _that.getCdSIndexDetachmentPoint())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(collateralPortfolioCode, _that.getCollateralPortfolioCode())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(level, _that.getLevel())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportSubmittingEntityID != null ? reportSubmittingEntityID.hashCode() : 0);
			_result = 31 * _result + (entityResponsibleForReporting != null ? entityResponsibleForReporting.hashCode() : 0);
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty1 != null ? natureOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty1 != null ? corporateSectorOfTheCounterparty1.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty1 != null ? clearingThresholdOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (countryOfTheCounterParty2 != null ? countryOfTheCounterParty2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (natureOfCounterparty2 != null ? natureOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (corporateSectorOfTheCounterparty2 != null ? corporateSectorOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingThresholdOfCounterparty2 != null ? clearingThresholdOfCounterparty2.hashCode() : 0);
			_result = 31 * _result + (reportingObligationOfTheCounterparty2 != null ? reportingObligationOfTheCounterparty2.hashCode() : 0);
			_result = 31 * _result + (brokerID != null ? brokerID.hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg1 != null ? directionOfLeg1.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg2 != null ? directionOfLeg2.hashCode() : 0);
			_result = 31 * _result + (directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
			_result = 31 * _result + (uti != null ? uti.hashCode() : 0);
			_result = 31 * _result + (reportTrackingNumber != null ? reportTrackingNumber.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (ptrrId != null ? ptrrId.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (subsequentPositionUTI != null ? subsequentPositionUTI.hashCode() : 0);
			_result = 31 * _result + (isin != null ? isin.hashCode() : 0);
			_result = 31 * _result + (upi != null ? upi.hashCode() : 0);
			_result = 31 * _result + (productClassification != null ? productClassification.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (isCrypto != null ? isCrypto.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentification != null ? underlyingIdentification.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (underlyingIndexIndicator != null ? underlyingIndexIndicator.hashCode() : 0);
			_result = 31 * _result + (customBasketCode != null ? customBasketCode.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency1 != null ? settlementCurrency1.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency2 != null ? settlementCurrency2.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (delta != null ? delta.hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (clearingObligation != null ? clearingObligation.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (masterAgreementType != null ? masterAgreementType.hashCode() : 0);
			_result = 31 * _result + (otherMasterAgreementType != null ? otherMasterAgreementType.hashCode() : 0);
			_result = 31 * _result + (masterAgreementVersion != null ? masterAgreementVersion.hashCode() : 0);
			_result = 31 * _result + (intragroup != null ? intragroup.hashCode() : 0);
			_result = 31 * _result + (ptrr != null ? ptrr.hashCode() : 0);
			_result = 31 * _result + (typeOfPTRRTechnique != null ? typeOfPTRRTechnique.hashCode() : 0);
			_result = 31 * _result + (ptrrServiceProvider != null ? ptrrServiceProvider.hashCode() : 0);
			_result = 31 * _result + (venueOfExecution != null ? venueOfExecution.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (earlyTerminationDate != null ? earlyTerminationDate.hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (notionalLeg1 != null ? notionalLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency1 != null ? notionalCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg1 != null ? totalNotionalQuantityLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalLeg2 != null ? notionalLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrency2 != null ? notionalCurrency2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg1 != null ? fixedRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg1 != null ? fixedRateDayCountConventionLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg1 != null ? fixedRatePaymentFrequencyPeriodLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg1 != null ? identifierOfFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg1 != null ? indicatorOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg1 != null ? floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1TimePeriod != null ? floatingRateReferencePeriodOfLeg1TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg1Multiplier != null ? floatingRateReferencePeriodOfLeg1Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg1 != null ? floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg2 != null ? fixedRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionLeg2 != null ? fixedRateDayCountConventionLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodLeg2 != null ? fixedRatePaymentFrequencyPeriodLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg2 != null ? identifierOfFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (indicatorOfTheFloatingRateOfLeg2 != null ? indicatorOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg2 != null ? floatingRatePaymentFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2TimePeriod != null ? floatingRateReferencePeriodOfLeg2TimePeriod.hashCode() : 0);
			_result = 31 * _result + (floatingRateReferencePeriodOfLeg2Multiplier != null ? floatingRateReferencePeriodOfLeg2Multiplier.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierLeg2.hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (forwardExchangeRate != null ? forwardExchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (baseProduct != null ? baseProduct.hashCode() : 0);
			_result = 31 * _result + (subProduct != null ? subProduct.hashCode() : 0);
			_result = 31 * _result + (furtherSubProduct != null ? furtherSubProduct.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (optionPremiumPaymentDate != null ? optionPremiumPaymentDate.hashCode() : 0);
			_result = 31 * _result + (maturityDateOfTheUnderlying != null ? maturityDateOfTheUnderlying.hashCode() : 0);
			_result = 31 * _result + (seniority != null ? seniority.hashCode() : 0);
			_result = 31 * _result + (referenceEntity != null ? referenceEntity.hashCode() : 0);
			_result = 31 * _result + (series != null ? series.hashCode() : 0);
			_result = 31 * _result + (version != null ? version.hashCode() : 0);
			_result = 31 * _result + (indexFactor != null ? indexFactor.hashCode() : 0);
			_result = 31 * _result + (tranche != null ? tranche.hashCode() : 0);
			_result = 31 * _result + (cdSIndexAttachmentPoint != null ? cdSIndexAttachmentPoint.hashCode() : 0);
			_result = 31 * _result + (cdSIndexDetachmentPoint != null ? cdSIndexDetachmentPoint.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioCode != null ? collateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (level != null ? level.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CommonTransactionReportBuilder {" +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", " +
				"entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", " +
				"counterparty1=" + this.counterparty1 + ", " +
				"natureOfCounterparty1=" + this.natureOfCounterparty1 + ", " +
				"corporateSectorOfTheCounterparty1=" + this.corporateSectorOfTheCounterparty1 + ", " +
				"clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"countryOfTheCounterParty2=" + this.countryOfTheCounterParty2 + ", " +
				"natureOfCounterparty2=" + this.natureOfCounterparty2 + ", " +
				"corporateSectorOfTheCounterparty2=" + this.corporateSectorOfTheCounterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", " +
				"reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", " +
				"brokerID=" + this.brokerID + ", " +
				"direction=" + this.direction + ", " +
				"directionOfLeg1=" + this.directionOfLeg1 + ", " +
				"directionOfLeg2=" + this.directionOfLeg2 + ", " +
				"directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", " +
				"uti=" + this.uti + ", " +
				"reportTrackingNumber=" + this.reportTrackingNumber + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"ptrrId=" + this.ptrrId + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"subsequentPositionUTI=" + this.subsequentPositionUTI + ", " +
				"isin=" + this.isin + ", " +
				"upi=" + this.upi + ", " +
				"productClassification=" + this.productClassification + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"isCrypto=" + this.isCrypto + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdentification=" + this.underlyingIdentification + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"underlyingIndexIndicator=" + this.underlyingIndexIndicator + ", " +
				"customBasketCode=" + this.customBasketCode + ", " +
				"settlementCurrency1=" + this.settlementCurrency1 + ", " +
				"settlementCurrency2=" + this.settlementCurrency2 + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"delta=" + this.delta + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"confirmed=" + this.confirmed + ", " +
				"clearingObligation=" + this.clearingObligation + ", " +
				"cleared=" + this.cleared + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"masterAgreementType=" + this.masterAgreementType + ", " +
				"otherMasterAgreementType=" + this.otherMasterAgreementType + ", " +
				"masterAgreementVersion=" + this.masterAgreementVersion + ", " +
				"intragroup=" + this.intragroup + ", " +
				"ptrr=" + this.ptrr + ", " +
				"typeOfPTRRTechnique=" + this.typeOfPTRRTechnique + ", " +
				"ptrrServiceProvider=" + this.ptrrServiceProvider + ", " +
				"venueOfExecution=" + this.venueOfExecution + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"earlyTerminationDate=" + this.earlyTerminationDate + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"notionalLeg1=" + this.notionalLeg1 + ", " +
				"notionalCurrency1=" + this.notionalCurrency1 + ", " +
				"totalNotionalQuantityLeg1=" + this.totalNotionalQuantityLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"notionalLeg2=" + this.notionalLeg2 + ", " +
				"notionalCurrency2=" + this.notionalCurrency2 + ", " +
				"fixedRateOfLeg1=" + this.fixedRateOfLeg1 + ", " +
				"fixedRateDayCountConventionLeg1=" + this.fixedRateDayCountConventionLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg1=" + this.fixedRatePaymentFrequencyPeriodLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg1 + ", " +
				"identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", " +
				"indicatorOfTheFloatingRateOfLeg1=" + this.indicatorOfTheFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg1=" + this.floatingRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRateReferencePeriodOfLeg1TimePeriod=" + this.floatingRateReferencePeriodOfLeg1TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg1Multiplier=" + this.floatingRateReferencePeriodOfLeg1Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierLeg1 + ", " +
				"fixedRateOfLeg2=" + this.fixedRateOfLeg2 + ", " +
				"fixedRateDayCountConventionLeg2=" + this.fixedRateDayCountConventionLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodLeg2=" + this.fixedRatePaymentFrequencyPeriodLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierLeg2 + ", " +
				"identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", " +
				"indicatorOfTheFloatingRateOfLeg2=" + this.indicatorOfTheFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg2=" + this.floatingRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"floatingRateReferencePeriodOfLeg2TimePeriod=" + this.floatingRateReferencePeriodOfLeg2TimePeriod + ", " +
				"floatingRateReferencePeriodOfLeg2Multiplier=" + this.floatingRateReferencePeriodOfLeg2Multiplier + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierLeg2 + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"forwardExchangeRate=" + this.forwardExchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"baseProduct=" + this.baseProduct + ", " +
				"subProduct=" + this.subProduct + ", " +
				"furtherSubProduct=" + this.furtherSubProduct + ", " +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"optionPremiumPaymentDate=" + this.optionPremiumPaymentDate + ", " +
				"maturityDateOfTheUnderlying=" + this.maturityDateOfTheUnderlying + ", " +
				"seniority=" + this.seniority + ", " +
				"referenceEntity=" + this.referenceEntity + ", " +
				"series=" + this.series + ", " +
				"version=" + this.version + ", " +
				"indexFactor=" + this.indexFactor + ", " +
				"tranche=" + this.tranche + ", " +
				"cdSIndexAttachmentPoint=" + this.cdSIndexAttachmentPoint + ", " +
				"cdSIndexDetachmentPoint=" + this.cdSIndexDetachmentPoint + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"collateralPortfolioCode=" + this.collateralPortfolioCode + ", " +
				"eventType=" + this.eventType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"level=" + this.level + ", " +
				"actionType=" + this.actionType +
			'}';
		}
	}
}
