package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.ESMATransactionInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.52.1
 */
@RosettaDataType(value="ESMATransactionInformation", builder=ESMATransactionInformation.ESMATransactionInformationBuilderImpl.class, version="5.52.1")
@RuneDataType(value="ESMATransactionInformation", model="drr", builder=ESMATransactionInformation.ESMATransactionInformationBuilderImpl.class, version="5.52.1")
public interface ESMATransactionInformation extends CommonTransactionInformation {

	ESMATransactionInformationMeta metaData = new ESMATransactionInformationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Specifies the approximate duration of the contract in the context of commoditiy trading. Exact boundaries of each value have not been precisely defined by so far. This attribute is expected to be removed when values exact definitions of values emerge and a functional assessment of duration - based upon start and end dates and times - can be implemented.
	 */
	CommodityTimeUnitEnum getDuration();

	/*********************** Build Methods  ***********************/
	ESMATransactionInformation build();
	
	ESMATransactionInformation.ESMATransactionInformationBuilder toBuilder();
	
	static ESMATransactionInformation.ESMATransactionInformationBuilder builder() {
		return new ESMATransactionInformation.ESMATransactionInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ESMATransactionInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ESMATransactionInformation> getType() {
		return ESMATransactionInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("admittedToTradingVenue"), AdmittedToTradingVenue.class, getAdmittedToTradingVenue(), this);
		processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
		processor.processBasic(path.newSubPath("duration"), CommodityTimeUnitEnum.class, getDuration(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ESMATransactionInformationBuilder extends ESMATransactionInformation, CommonTransactionInformation.CommonTransactionInformationBuilder {
		@Override
		ESMATransactionInformation.ESMATransactionInformationBuilder setAdmittedToTradingVenue(AdmittedToTradingVenue admittedToTradingVenue);
		@Override
		ESMATransactionInformation.ESMATransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean underlierTradedOnTradingVenue);
		ESMATransactionInformation.ESMATransactionInformationBuilder setDuration(CommodityTimeUnitEnum duration);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("admittedToTradingVenue"), AdmittedToTradingVenue.class, getAdmittedToTradingVenue(), this);
			processor.processBasic(path.newSubPath("underlierTradedOnTradingVenue"), Boolean.class, getUnderlierTradedOnTradingVenue(), this);
			processor.processBasic(path.newSubPath("duration"), CommodityTimeUnitEnum.class, getDuration(), this);
		}
		

		ESMATransactionInformation.ESMATransactionInformationBuilder prune();
	}

	/*********************** Immutable Implementation of ESMATransactionInformation  ***********************/
	class ESMATransactionInformationImpl extends CommonTransactionInformation.CommonTransactionInformationImpl implements ESMATransactionInformation {
		private final CommodityTimeUnitEnum duration;
		
		protected ESMATransactionInformationImpl(ESMATransactionInformation.ESMATransactionInformationBuilder builder) {
			super(builder);
			this.duration = builder.getDuration();
		}
		
		@Override
		@RosettaAttribute("duration")
		@RuneAttribute("duration")
		public CommodityTimeUnitEnum getDuration() {
			return duration;
		}
		
		@Override
		public ESMATransactionInformation build() {
			return this;
		}
		
		@Override
		public ESMATransactionInformation.ESMATransactionInformationBuilder toBuilder() {
			ESMATransactionInformation.ESMATransactionInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ESMATransactionInformation.ESMATransactionInformationBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getDuration()).ifPresent(builder::setDuration);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ESMATransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(duration, _that.getDuration())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (duration != null ? duration.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMATransactionInformation {" +
				"duration=" + this.duration +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of ESMATransactionInformation  ***********************/
	class ESMATransactionInformationBuilderImpl extends CommonTransactionInformation.CommonTransactionInformationBuilderImpl implements ESMATransactionInformation.ESMATransactionInformationBuilder {
	
		protected CommodityTimeUnitEnum duration;
		
		@Override
		@RosettaAttribute("duration")
		@RuneAttribute("duration")
		public CommodityTimeUnitEnum getDuration() {
			return duration;
		}
		
		@RosettaAttribute("admittedToTradingVenue")
		@RuneAttribute("admittedToTradingVenue")
		@Override
		public ESMATransactionInformation.ESMATransactionInformationBuilder setAdmittedToTradingVenue(AdmittedToTradingVenue _admittedToTradingVenue) {
			this.admittedToTradingVenue = _admittedToTradingVenue == null ? null : _admittedToTradingVenue;
			return this;
		}
		
		@RosettaAttribute("underlierTradedOnTradingVenue")
		@RuneAttribute("underlierTradedOnTradingVenue")
		@Override
		public ESMATransactionInformation.ESMATransactionInformationBuilder setUnderlierTradedOnTradingVenue(Boolean _underlierTradedOnTradingVenue) {
			this.underlierTradedOnTradingVenue = _underlierTradedOnTradingVenue == null ? null : _underlierTradedOnTradingVenue;
			return this;
		}
		
		@RosettaAttribute("duration")
		@RuneAttribute("duration")
		@Override
		public ESMATransactionInformation.ESMATransactionInformationBuilder setDuration(CommodityTimeUnitEnum _duration) {
			this.duration = _duration == null ? null : _duration;
			return this;
		}
		
		@Override
		public ESMATransactionInformation build() {
			return new ESMATransactionInformation.ESMATransactionInformationImpl(this);
		}
		
		@Override
		public ESMATransactionInformation.ESMATransactionInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMATransactionInformation.ESMATransactionInformationBuilder prune() {
			super.prune();
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getDuration()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ESMATransactionInformation.ESMATransactionInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			ESMATransactionInformation.ESMATransactionInformationBuilder o = (ESMATransactionInformation.ESMATransactionInformationBuilder) other;
			
			
			merger.mergeBasic(getDuration(), o.getDuration(), this::setDuration);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			ESMATransactionInformation _that = getType().cast(o);
		
			if (!Objects.equals(duration, _that.getDuration())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (duration != null ? duration.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ESMATransactionInformationBuilder {" +
				"duration=" + this.duration +
			'}' + " " + super.toString();
		}
	}
}
