package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.ReportableCollateralMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.52.1
 */
@RosettaDataType(value="ReportableCollateral", builder=ReportableCollateral.ReportableCollateralBuilderImpl.class, version="5.52.1")
@RuneDataType(value="ReportableCollateral", model="drr", builder=ReportableCollateral.ReportableCollateralBuilderImpl.class, version="5.52.1")
public interface ReportableCollateral extends RosettaModelObject {

	ReportableCollateralMeta metaData = new ReportableCollateralMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * The reportable collateral information
	 */
	CollateralDetails getCollateralDetails();
	/**
	 * Additional information required for a reportable transaction, including the reporting regime.
	 */
	ReportableInformation getReportableInformation();

	/*********************** Build Methods  ***********************/
	ReportableCollateral build();
	
	ReportableCollateral.ReportableCollateralBuilder toBuilder();
	
	static ReportableCollateral.ReportableCollateralBuilder builder() {
		return new ReportableCollateral.ReportableCollateralBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ReportableCollateral> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ReportableCollateral> getType() {
		return ReportableCollateral.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.class, getCollateralDetails());
		processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, getReportableInformation());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ReportableCollateralBuilder extends ReportableCollateral, RosettaModelObjectBuilder {
		CollateralDetails.CollateralDetailsBuilder getOrCreateCollateralDetails();
		@Override
		CollateralDetails.CollateralDetailsBuilder getCollateralDetails();
		ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation();
		@Override
		ReportableInformation.ReportableInformationBuilder getReportableInformation();
		ReportableCollateral.ReportableCollateralBuilder setCollateralDetails(CollateralDetails collateralDetails);
		ReportableCollateral.ReportableCollateralBuilder setReportableInformation(ReportableInformation reportableInformation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.CollateralDetailsBuilder.class, getCollateralDetails());
			processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, getReportableInformation());
		}
		

		ReportableCollateral.ReportableCollateralBuilder prune();
	}

	/*********************** Immutable Implementation of ReportableCollateral  ***********************/
	class ReportableCollateralImpl implements ReportableCollateral {
		private final CollateralDetails collateralDetails;
		private final ReportableInformation reportableInformation;
		
		protected ReportableCollateralImpl(ReportableCollateral.ReportableCollateralBuilder builder) {
			this.collateralDetails = ofNullable(builder.getCollateralDetails()).map(f->f.build()).orElse(null);
			this.reportableInformation = ofNullable(builder.getReportableInformation()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("collateralDetails")
		@RuneAttribute("collateralDetails")
		public CollateralDetails getCollateralDetails() {
			return collateralDetails;
		}
		
		@Override
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		public ReportableInformation getReportableInformation() {
			return reportableInformation;
		}
		
		@Override
		public ReportableCollateral build() {
			return this;
		}
		
		@Override
		public ReportableCollateral.ReportableCollateralBuilder toBuilder() {
			ReportableCollateral.ReportableCollateralBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ReportableCollateral.ReportableCollateralBuilder builder) {
			ofNullable(getCollateralDetails()).ifPresent(builder::setCollateralDetails);
			ofNullable(getReportableInformation()).ifPresent(builder::setReportableInformation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReportableCollateral _that = getType().cast(o);
		
			if (!Objects.equals(collateralDetails, _that.getCollateralDetails())) return false;
			if (!Objects.equals(reportableInformation, _that.getReportableInformation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (collateralDetails != null ? collateralDetails.hashCode() : 0);
			_result = 31 * _result + (reportableInformation != null ? reportableInformation.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReportableCollateral {" +
				"collateralDetails=" + this.collateralDetails + ", " +
				"reportableInformation=" + this.reportableInformation +
			'}';
		}
	}

	/*********************** Builder Implementation of ReportableCollateral  ***********************/
	class ReportableCollateralBuilderImpl implements ReportableCollateral.ReportableCollateralBuilder {
	
		protected CollateralDetails.CollateralDetailsBuilder collateralDetails;
		protected ReportableInformation.ReportableInformationBuilder reportableInformation;
		
		@Override
		@RosettaAttribute("collateralDetails")
		@RuneAttribute("collateralDetails")
		public CollateralDetails.CollateralDetailsBuilder getCollateralDetails() {
			return collateralDetails;
		}
		
		@Override
		public CollateralDetails.CollateralDetailsBuilder getOrCreateCollateralDetails() {
			CollateralDetails.CollateralDetailsBuilder result;
			if (collateralDetails!=null) {
				result = collateralDetails;
			}
			else {
				result = collateralDetails = CollateralDetails.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		public ReportableInformation.ReportableInformationBuilder getReportableInformation() {
			return reportableInformation;
		}
		
		@Override
		public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation() {
			ReportableInformation.ReportableInformationBuilder result;
			if (reportableInformation!=null) {
				result = reportableInformation;
			}
			else {
				result = reportableInformation = ReportableInformation.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute("collateralDetails")
		@RuneAttribute("collateralDetails")
		@Override
		public ReportableCollateral.ReportableCollateralBuilder setCollateralDetails(CollateralDetails _collateralDetails) {
			this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="reportableInformation", isRequired=true)
		@RuneAttribute(value="reportableInformation", isRequired=true)
		@Override
		public ReportableCollateral.ReportableCollateralBuilder setReportableInformation(ReportableInformation _reportableInformation) {
			this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
			return this;
		}
		
		@Override
		public ReportableCollateral build() {
			return new ReportableCollateral.ReportableCollateralImpl(this);
		}
		
		@Override
		public ReportableCollateral.ReportableCollateralBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReportableCollateral.ReportableCollateralBuilder prune() {
			if (collateralDetails!=null && !collateralDetails.prune().hasData()) collateralDetails = null;
			if (reportableInformation!=null && !reportableInformation.prune().hasData()) reportableInformation = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCollateralDetails()!=null && getCollateralDetails().hasData()) return true;
			if (getReportableInformation()!=null && getReportableInformation().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReportableCollateral.ReportableCollateralBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ReportableCollateral.ReportableCollateralBuilder o = (ReportableCollateral.ReportableCollateralBuilder) other;
			
			merger.mergeRosetta(getCollateralDetails(), o.getCollateralDetails(), this::setCollateralDetails);
			merger.mergeRosetta(getReportableInformation(), o.getReportableInformation(), this::setReportableInformation);
			
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReportableCollateral _that = getType().cast(o);
		
			if (!Objects.equals(collateralDetails, _that.getCollateralDetails())) return false;
			if (!Objects.equals(reportableInformation, _that.getReportableInformation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (collateralDetails != null ? collateralDetails.hashCode() : 0);
			_result = 31 * _result + (reportableInformation != null ? reportableInformation.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReportableCollateralBuilder {" +
				"collateralDetails=" + this.collateralDetails + ", " +
				"reportableInformation=" + this.reportableInformation +
			'}';
		}
	}
}
