package drr.regulation.common.functions;

import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Transfer;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(ExtractOtherPaymentPayer.ExtractOtherPaymentPayerDefault.class)
public abstract class ExtractOtherPaymentPayer implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected PartyLeiAndPersonByRoles partyLeiAndPersonByRoles;

	/**
	* @param transferState 
	* @param transactionReportInstruction 
	* @return partyPersonLei 
	*/
	public String evaluate(TransferState transferState, TransactionReportInstruction transactionReportInstruction) {
		String partyPersonLei = doEvaluate(transferState, transactionReportInstruction);
		
		return partyPersonLei;
	}

	protected abstract String doEvaluate(TransferState transferState, TransactionReportInstruction transactionReportInstruction);

	public static class ExtractOtherPaymentPayerDefault extends ExtractOtherPaymentPayer {
		@Override
		protected String doEvaluate(TransferState transferState, TransactionReportInstruction transactionReportInstruction) {
			String partyPersonLei = null;
			return assignOutput(partyPersonLei, transferState, transactionReportInstruction);
		}
		
		protected String assignOutput(String partyPersonLei, TransferState transferState, TransactionReportInstruction transactionReportInstruction) {
			final ReferenceWithMetaParty referenceWithMetaParty0 = MapperS.of(transferState).<Transfer>map("getTransfer", _transferState -> _transferState.getTransfer()).<PartyReferencePayerReceiver>map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).<ReferenceWithMetaParty>map("getPayerPartyReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getPayerPartyReference()).get();
			final ReferenceWithMetaParty referenceWithMetaParty1 = MapperS.of(transactionReportInstruction).<ReportingSide>map("getReportingSide", _transactionReportInstruction -> _transactionReportInstruction.getReportingSide()).<ReferenceWithMetaParty>map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
			partyPersonLei = partyLeiAndPersonByRoles.evaluate((referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()), (referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()));
			
			return partyPersonLei;
		}
	}
}
