package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import javax.inject.Inject;


@ImplementedBy(GetNameOfTheFloatingRateOfLeg2.GetNameOfTheFloatingRateOfLeg2Default.class)
public abstract class GetNameOfTheFloatingRateOfLeg2 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg2 interestRateLeg2;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected RateOption rateOption;

	/**
	* @param reportableEvent 
	* @return name 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String name = doEvaluate(reportableEvent);
		
		return name;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	public static class GetNameOfTheFloatingRateOfLeg2Default extends GetNameOfTheFloatingRateOfLeg2 {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String name = null;
			return assignOutput(name, reportableEvent);
		}
		
		protected String assignOutput(String name, ReportableEvent reportableEvent) {
			final MapperS<Product> thenArg0 = MapperS.of(productForEvent.evaluate(reportableEvent));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(interestRateLeg2.evaluate(item.get())));
			final FieldWithMetaString fieldWithMetaString = thenArg2
				.mapSingleToItem(item -> MapperS.of(rateOption.evaluate(item.get())).<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())).get();
			if (fieldWithMetaString == null) {
				name = null;
			} else {
				name = fieldWithMetaString.getValue();
			}
			
			return name;
		}
	}
}
