package drr.regulation.common.functions;

import cdm.base.datetime.DateRange;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.QuantityReportablePeriod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetReportableQuantityPeriodLeg2.GetReportableQuantityPeriodLeg2Default.class)
public abstract class GetReportableQuantityPeriodLeg2 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetLeg2ResolvablePriceQuantity getLeg2ResolvablePriceQuantity;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;

	/**
	* @param trade 
	* @return reportablePeriod 
	*/
	public List<? extends QuantityReportablePeriod> evaluate(Trade trade) {
		List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriodBuilder = doEvaluate(trade);
		
		final List<? extends QuantityReportablePeriod> reportablePeriod;
		if (reportablePeriodBuilder == null) {
			reportablePeriod = null;
		} else {
			reportablePeriod = reportablePeriodBuilder.stream().map(QuantityReportablePeriod::build).collect(Collectors.toList());
			objectValidator.validate(QuantityReportablePeriod.class, reportablePeriod);
		}
		
		return reportablePeriod;
	}

	protected abstract List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(Trade trade);

	protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(Trade trade);

	protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade trade);

	public static class GetReportableQuantityPeriodLeg2Default extends GetReportableQuantityPeriodLeg2 {
		@Override
		protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> doEvaluate(Trade trade) {
			List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriod = new ArrayList<>();
			return assignOutput(reportablePeriod, trade);
		}
		
		protected List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> assignOutput(List<QuantityReportablePeriod.QuantityReportablePeriodBuilder> reportablePeriod, Trade trade) {
			if (exists(customizedSchedule(trade)).getOrDefault(false)) {
				reportablePeriod.addAll(toBuilder(quantitySchedule(trade).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue())
					.mapItem(quantityPeriod -> {
						final MapperC<SchedulePeriod> thenArg0 = customizedSchedule(trade).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod())
							.filterItemNullSafe(customPeriod -> areEqual(quantityPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()), customPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()), CardinalityOperator.All).get());
						final MapperS<SchedulePeriod> thenArg1 = MapperS.of(thenArg0.get());
						return thenArg1
							.mapSingleToItem(matchingCustomPeriod -> MapperS.of(QuantityReportablePeriod.builder()
								.setPeriodValue(quantityPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).get())
								.setPeriodEffectiveDate(matchingCustomPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()).get())
								.setPeriodEndDate(matchingCustomPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate()).get())
								.build()));
					}).getMulti()));
			} else {
				reportablePeriod.addAll(toBuilder(quantitySchedule(trade).<NonNegativeQuantitySchedule>map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue())
					.mapItem(quantityPeriod -> MapperS.of(QuantityReportablePeriod.builder()
						.setPeriodValue(quantityPeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).get())
						.setPeriodEffectiveDate(quantityPeriod.<Date>map("getDate", datedValue -> datedValue.getDate()).get())
						.setPeriodEndDate(null)
						.build())).getMulti()));
			}
			
			return Optional.ofNullable(reportablePeriod)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends CalculationSchedule> customizedSchedule(Trade trade) {
			if (ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))))).or(ComparisonResult.of(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade)))))).getOrDefault(false)) {
				return MapperS.of(commodityLeg2.evaluate(productForTrade.evaluate(trade))).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
			}
			final Boolean boolean0 = isSingleCommodityPayoutProduct.evaluate(productForTrade.evaluate(trade));
			if ((boolean0 == null ? false : boolean0)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule());
			}
			final Boolean boolean1 = qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade)));
			if ((boolean1 == null ? false : boolean1)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<CalculationSchedule>map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
			}
			return MapperS.<CalculationSchedule>ofNull();
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> quantitySchedule(Trade trade) {
			if (ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade))))).or(ComparisonResult.of(MapperS.of(qualify_AssetClass_Commodity.evaluate(economicTermsForProduct.evaluate(productForTrade.evaluate(trade)))))).getOrDefault(false)) {
				return MapperS.of(getLeg2ResolvablePriceQuantity.evaluate(trade)).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			}
			return MapperS.<ReferenceWithMetaNonNegativeQuantitySchedule>ofNull();
		}
	}
}
