package drr.regulation.common.functions;

import cdm.product.qualification.functions.Qualify_BaseProduct_EquitySwap;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IsEquitySwapProduct.IsEquitySwapProductDefault.class)
public abstract class IsEquitySwapProduct implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected Qualify_BaseProduct_EquitySwap qualify_BaseProduct_EquitySwap;

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	public static class IsEquitySwapProductDefault extends IsEquitySwapProduct {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			result = areEqual(MapperS.of(qualify_BaseProduct_EquitySwap.evaluate(economicTermsForProduct.evaluate(product))), MapperS.of(true), CardinalityOperator.All).get();
			
			return result;
		}
	}
}
