package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.metafields.FieldWithMetaRegimeNameEnum;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.1
 */
@RosettaDataRule("TransactionInformationSupervisorInformation")
@ImplementedBy(TransactionInformationSupervisorInformation.Default.class)
public interface TransactionInformationSupervisorInformation extends Validator<TransactionInformation> {
	
	String NAME = "TransactionInformationSupervisorInformation";
	String DEFINITION = "if regimeName = RegimeNameEnum -> DoddFrankAct then supervisoryBody = SupervisoryBodyEnum -> CFTC or supervisoryBody = SupervisoryBodyEnum -> SEC";
	
	class Default implements TransactionInformationSupervisorInformation {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransactionInformation transactionInformation) {
			ComparisonResult result = executeDataRule(transactionInformation);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "TransactionInformation", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "TransactionInformation", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(TransactionInformation transactionInformation) {
			try {
				if (areEqual(MapperS.of(transactionInformation).<FieldWithMetaRegimeNameEnum>map("getRegimeName", _transactionInformation -> _transactionInformation.getRegimeName()).<RegimeNameEnum>map("Type coercion", fieldWithMetaRegimeNameEnum -> fieldWithMetaRegimeNameEnum == null ? null : fieldWithMetaRegimeNameEnum.getValue()), MapperS.of(RegimeNameEnum.DODD_FRANK_ACT), CardinalityOperator.All).getOrDefault(false)) {
					return areEqual(MapperS.of(transactionInformation).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _transactionInformation -> _transactionInformation.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum0 -> fieldWithMetaSupervisoryBodyEnum0 == null ? null : fieldWithMetaSupervisoryBodyEnum0.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).or(areEqual(MapperS.of(transactionInformation).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", _transactionInformation -> _transactionInformation.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum1 -> fieldWithMetaSupervisoryBodyEnum1 == null ? null : fieldWithMetaSupervisoryBodyEnum1.getValue()), MapperS.of(SupervisoryBodyEnum.SEC), CardinalityOperator.All));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements TransactionInformationSupervisorInformation {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, TransactionInformation transactionInformation) {
			return Collections.emptyList();
		}
	}
}
