package drr.regulation.esma.emir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.esma.emir.refit.trade.StrikePriceAndNotation;
import drr.regulation.esma.emir.refit.trade.validation.StrikePriceAndNotationTypeFormatValidator;
import drr.regulation.esma.emir.refit.trade.validation.StrikePriceAndNotationValidator;
import drr.regulation.esma.emir.refit.trade.validation.datarule.StrikePriceAndNotationMonetaryOrPercentage;
import drr.regulation.esma.emir.refit.trade.validation.exists.StrikePriceAndNotationOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.52.1
 */
@RosettaMeta(model=StrikePriceAndNotation.class)
public class StrikePriceAndNotationMeta implements RosettaMetaData<StrikePriceAndNotation> {

	@Override
	public List<Validator<? super StrikePriceAndNotation>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<StrikePriceAndNotation>create(StrikePriceAndNotationMonetaryOrPercentage.class)
		);
	}
	
	@Override
	public List<Function<? super StrikePriceAndNotation, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super StrikePriceAndNotation> validator(ValidatorFactory factory) {
		return factory.<StrikePriceAndNotation>create(StrikePriceAndNotationValidator.class);
	}

	@Override
	public Validator<? super StrikePriceAndNotation> typeFormatValidator(ValidatorFactory factory) {
		return factory.<StrikePriceAndNotation>create(StrikePriceAndNotationTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super StrikePriceAndNotation> validator() {
		return new StrikePriceAndNotationValidator();
	}

	@Deprecated
	@Override
	public Validator<? super StrikePriceAndNotation> typeFormatValidator() {
		return new StrikePriceAndNotationTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super StrikePriceAndNotation, Set<String>> onlyExistsValidator() {
		return new StrikePriceAndNotationOnlyExistsValidator();
	}
}
