package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;


@ImplementedBy(DeliveryEndDateRule.DeliveryEndDateRuleDefault.class)
public abstract class DeliveryEndDateRule implements ReportFunction<ReportableDelivery, Date> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(ReportableDelivery input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(ReportableDelivery input);

	public static class DeliveryEndDateRuleDefault extends DeliveryEndDateRule {
		@Override
		protected Date doEvaluate(ReportableDelivery input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, ReportableDelivery input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<Date>map("getDeliveryEndDate", reportableDelivery -> reportableDelivery.getDeliveryEndDate())).get();
			
			return output;
		}
	}
}
