package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalQuantityScheduleEndDateRule;
import javax.inject.Inject;


@ImplementedBy(EndDateOfTheNotionalQuantityOfLeg2Rule.EndDateOfTheNotionalQuantityOfLeg2RuleDefault.class)
public abstract class EndDateOfTheNotionalQuantityOfLeg2Rule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalQuantityScheduleEndDateRule cDENotionalQuantityScheduleEndDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class EndDateOfTheNotionalQuantityOfLeg2RuleDefault extends EndDateOfTheNotionalQuantityOfLeg2Rule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalQuantityScheduleEndDateRule.evaluate(input);
			
			return output;
		}
	}
}
