package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.standards.iosco.cde.reports.CDENotionalAmountScheduleAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg1Rule.NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg1RuleDefault.class)
public abstract class NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg1Rule implements ReportFunction<QuantityReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalAmountScheduleAmountRule cDENotionalAmountScheduleAmountRule;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected RoundToPrecision roundToPrecision;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(QuantityReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(QuantityReportablePeriod input);

	public static class NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg1RuleDefault extends NotionalAmountInEffectOnAssociatedEffectiveDateOfLeg1Rule {
		@Override
		protected BigDecimal doEvaluate(QuantityReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, QuantityReportablePeriod input) {
			final MapperS<BigDecimal> thenArg0 = MapperS.of(cDENotionalAmountScheduleAmountRule.evaluate(input));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(roundToPrecision.evaluate(item.get(), 5, RoundingDirectionEnum.NEAREST)));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
