package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToMax5Number;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDEPackageTransactionPriceNotationEnumRule;
import drr.standards.iosco.cde.reports.CDEPackageTransactionPriceRule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PackageTransactionPriceBasisRule.PackageTransactionPriceBasisRuleDefault.class)
public abstract class PackageTransactionPriceBasisRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageTransactionPriceNotationEnumRule cDEPackageTransactionPriceNotationEnumRule;
	@Inject protected CDEPackageTransactionPriceRule cDEPackageTransactionPriceRule;
	@Inject protected FormatToMax5Number formatToMax5Number;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class PackageTransactionPriceBasisRuleDefault extends PackageTransactionPriceBasisRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(cDEPackageTransactionPriceNotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.BASIS), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(multiplyPrice.evaluate(cDEPackageTransactionPriceRule.evaluate(item.get()), PriceNotationEnum.BASIS));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToMax5Number.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
