package drr.regulation.esma.emir.refit.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToMax5Number;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg1;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDESpreadLeg1Rule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(SpreadOfLeg1BasisRule.SpreadOfLeg1BasisRuleDefault.class)
public abstract class SpreadOfLeg1BasisRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg1Rule cDESpreadLeg1Rule;
	@Inject protected FormatToMax5Number formatToMax5Number;
	@Inject protected GetNameOfTheFloatingRateOfLeg1 getNameOfTheFloatingRateOfLeg1;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SpreadOfLeg1BasisRuleDefault extends SpreadOfLeg1BasisRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = cDESpreadLeg1Rule.evaluate(item.get());
					if ((priceSchedule == null ? exists(MapperS.<ReferenceWithMetaPriceSchedule>ofNull()).getOrDefault(false) : exists(MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(false))) {
						if (areEqual(MapperS.of(getPriceNotation.evaluate(cDESpreadLeg1Rule.evaluate(item.get()))), MapperS.of(PriceNotationEnum.BASIS), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of(multiplyPrice.evaluate(MapperS.of(cDESpreadLeg1Rule.evaluate(item.get())).<BigDecimal>map("getValue", _priceSchedule -> _priceSchedule.getValue()).get(), getPriceNotation.evaluate(cDESpreadLeg1Rule.evaluate(item.get()))));
						}
						return MapperS.<BigDecimal>ofNull();
					}
					if (exists(MapperS.of(getNameOfTheFloatingRateOfLeg1.evaluate(item.get()))).getOrDefault(false)) {
						return MapperS.of(BigDecimal.valueOf(0));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToMax5Number.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
