package drr.regulation.esma.emir.refit.trade.validation;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRNonReportable;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.regulation.esma.emir.refit.trade.PackageTransactionPrice;
import drr.regulation.esma.emir.refit.trade.PackageTransactionSpread;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg1;
import drr.regulation.esma.emir.refit.trade.SpreadOfLeg2;
import drr.regulation.esma.emir.refit.trade.StrikePriceAndNotation;
import iso20022.auth030.esma.EnergyLoadType1Code;
import iso20022.auth030.esma.Frequency13Code__1;
import iso20022.auth030.esma.InterestComputationMethod4Code;
import iso20022.auth030.esma.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ESMAEMIRTransactionReportValidator implements Validator<ESMAEMIRTransactionReport> {

	private List<ComparisonResult> getComparisonResults(ESMAEMIRTransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("reportSubmittingEntityID", (String) o.getReportSubmittingEntityID() != null ? 1 : 0, 1, 1), 
				checkCardinality("entityResponsibleForReporting", (String) o.getEntityResponsibleForReporting() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("natureOfCounterparty1", (String) o.getNatureOfCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("clearingThresholdOfCounterparty1", (Boolean) o.getClearingThresholdOfCounterparty1() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 0, 1), 
				checkCardinality("countryOfTheCounterParty2", (ISOCountryCodeEnum) o.getCountryOfTheCounterParty2() != null ? 1 : 0, 0, 1), 
				checkCardinality("natureOfCounterparty2", (String) o.getNatureOfCounterparty2() != null ? 1 : 0, 0, 1), 
				checkCardinality("counterparty2IdentifierType", (Boolean) o.getCounterparty2IdentifierType() != null ? 1 : 0, 1, 1), 
				checkCardinality("clearingMember", (String) o.getClearingMember() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingThresholdOfCounterparty2", (Boolean) o.getClearingThresholdOfCounterparty2() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportingObligationOfTheCounterparty2", (Boolean) o.getReportingObligationOfTheCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("brokerID", (String) o.getBrokerID() != null ? 1 : 0, 0, 1), 
				checkCardinality("direction", (String) o.getDirection() != null ? 1 : 0, 0, 1), 
				checkCardinality("directionOfLeg1", (String) o.getDirectionOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("directionOfLeg2", (String) o.getDirectionOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("directlyLinkedToCommercialActivityOrTreasuryFinancing", (Boolean) o.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() != null ? 1 : 0, 0, 1), 
				checkCardinality("uti", (String) o.getUti() != null ? 1 : 0, 0, 1), 
				checkCardinality("utiProprietary", (String) o.getUtiProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportTrackingNumber", (String) o.getReportTrackingNumber() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUti", (String) o.getPriorUti() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUtiProprietary", (String) o.getPriorUtiProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("ptrrId", (String) o.getPtrrId() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageIdentifier", (String) o.getPackageIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("subsequentPositionUti", (String) o.getSubsequentPositionUti() != null ? 1 : 0, 0, 1), 
				checkCardinality("isin", (String) o.getIsin() != null ? 1 : 0, 0, 1), 
				checkCardinality("upi", (String) o.getUpi() != null ? 1 : 0, 0, 1), 
				checkCardinality("productClassification", (String) o.getProductClassification() != null ? 1 : 0, 1, 1), 
				checkCardinality("contractType", (String) o.getContractType() != null ? 1 : 0, 1, 1), 
				checkCardinality("assetClass", (String) o.getAssetClass() != null ? 1 : 0, 1, 1), 
				checkCardinality("isCrypto", (Boolean) o.getIsCrypto() != null ? 1 : 0, 1, 1), 
				checkCardinality("underlyingIdentificationType", (String) o.getUnderlyingIdentificationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdentification", (String) o.getUnderlyingIdentification() != null ? 1 : 0, 0, 1), 
				checkCardinality("customBasketCode", (String) o.getCustomBasketCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrency1", (ISOCurrencyCodeEnum) o.getSettlementCurrency1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrency2", (ISOCurrencyCodeEnum) o.getSettlementCurrency2() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationAmount", (BigDecimal) o.getValuationAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationCurrency", (ISOCurrencyCodeEnum) o.getValuationCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationMethod", (ValuationType1Code) o.getValuationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("delta", (BigDecimal) o.getDelta() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationTimestamp", (ZonedDateTime) o.getValuationTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmationTimestamp", (ZonedDateTime) o.getConfirmationTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmed", (String) o.getConfirmed() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingObligation", (String) o.getClearingObligation() != null ? 1 : 0, 0, 1), 
				checkCardinality("cleared", (String) o.getCleared() != null ? 1 : 0, 1, 1), 
				checkCardinality("clearingTimestamp", (ZonedDateTime) o.getClearingTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("centralCounterparty", (String) o.getCentralCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("masterAgreementType", (String) o.getMasterAgreementType() != null ? 1 : 0, 1, 1), 
				checkCardinality("otherMasterAgreementType", (String) o.getOtherMasterAgreementType() != null ? 1 : 0, 0, 1), 
				checkCardinality("masterAgreementVersion", (Integer) o.getMasterAgreementVersion() != null ? 1 : 0, 0, 1), 
				checkCardinality("intragroup", (Boolean) o.getIntragroup() != null ? 1 : 0, 0, 1), 
				checkCardinality("ptrr", (Boolean) o.getPtrr() != null ? 1 : 0, 0, 1), 
				checkCardinality("typeOfPTRRTechnique", (String) o.getTypeOfPTRRTechnique() != null ? 1 : 0, 0, 1), 
				checkCardinality("ptrrServiceProvider", (String) o.getPtrrServiceProvider() != null ? 1 : 0, 0, 1), 
				checkCardinality("venueOfExecution", (String) o.getVenueOfExecution() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionTimestamp", (ZonedDateTime) o.getExecutionTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("expirationDate", (Date) o.getExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("earlyTerminationDate", (Date) o.getEarlyTerminationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("finalContractualSettlementDate", (Date) o.getFinalContractualSettlementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("deliveryType", (String) o.getDeliveryType() != null ? 1 : 0, 1, 1), 
				checkCardinality("price", (PriceAndNotation) o.getPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionPrice", (PackageTransactionPrice) o.getPackageTransactionPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalLeg1", (BigDecimal) o.getNotionalLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrency1", (ISOCurrencyCodeEnum) o.getNotionalCurrency1() != null ? 1 : 0, 1, 1), 
				checkCardinality("totalNotionalQuantityLeg1", (BigDecimal) o.getTotalNotionalQuantityLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg2", (BigDecimal) o.getTotalNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalLeg2", (BigDecimal) o.getNotionalLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrency2", (ISOCurrencyCodeEnum) o.getNotionalCurrency2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateOfLeg1", (BigDecimal) o.getFixedRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg1", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg1", (String) o.getFixedRatePaymentFrequencyPeriodLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg1", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("identifierOfFloatingRateOfLeg1", (String) o.getIdentifierOfFloatingRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("indicatorOfTheFloatingRateOfLeg1", (String) o.getIndicatorOfTheFloatingRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheFloatingRateOfLeg1", (String) o.getNameOfTheFloatingRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionOfLeg1", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodOfLeg1", (Frequency13Code__1) o.getFloatingRatePaymentFrequencyPeriodOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg1TimePeriod", (String) o.getFloatingRateReferencePeriodOfLeg1TimePeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg1Multiplier", (Integer) o.getFloatingRateReferencePeriodOfLeg1Multiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodOfLeg1", (String) o.getFloatingRateResetFrequencyPeriodOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg1", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg1", (SpreadOfLeg1) o.getSpreadOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateOfLeg2", (BigDecimal) o.getFixedRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionLeg2", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodLeg2", (String) o.getFixedRatePaymentFrequencyPeriodLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierLeg2", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("identifierOfFloatingRateOfLeg2", (String) o.getIdentifierOfFloatingRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("indicatorOfTheFloatingRateOfLeg2", (String) o.getIndicatorOfTheFloatingRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheFloatingRateOfLeg2", (String) o.getNameOfTheFloatingRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionOfLeg2", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodOfLeg2", (String) o.getFloatingRatePaymentFrequencyPeriodOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg2TimePeriod", (String) o.getFloatingRateReferencePeriodOfLeg2TimePeriod() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateReferencePeriodOfLeg2Multiplier", (Integer) o.getFloatingRateReferencePeriodOfLeg2Multiplier() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodOfLeg2", (String) o.getFloatingRateResetFrequencyPeriodOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierLeg2", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg2", (SpreadOfLeg2) o.getSpreadOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageTransactionSpread", (PackageTransactionSpread) o.getPackageTransactionSpread() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRate", (BigDecimal) o.getExchangeRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("forwardExchangeRate", (BigDecimal) o.getForwardExchangeRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasis", (String) o.getExchangeRateBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("baseProduct", (String) o.getBaseProduct() != null ? 1 : 0, 0, 1), 
				checkCardinality("subProduct", (String) o.getSubProduct() != null ? 1 : 0, 0, 1), 
				checkCardinality("furtherSubProduct", (String) o.getFurtherSubProduct() != null ? 1 : 0, 0, 1), 
				checkCardinality("interconnectionPoint", (String) o.getInterconnectionPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("loadType", (EnergyLoadType1Code) o.getLoadType() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionType", (String) o.getOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionStyle", (String) o.getOptionStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePrice", (StrikePriceAndNotation) o.getStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumAmount", (BigDecimal) o.getOptionPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumCurrency", (ISOCurrencyCodeEnum) o.getOptionPremiumCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumPaymentDate", (Date) o.getOptionPremiumPaymentDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("maturityDateOfTheUnderlying", (Date) o.getMaturityDateOfTheUnderlying() != null ? 1 : 0, 0, 1), 
				checkCardinality("seniority", (String) o.getSeniority() != null ? 1 : 0, 0, 1), 
				checkCardinality("referenceEntity", (String) o.getReferenceEntity() != null ? 1 : 0, 0, 1), 
				checkCardinality("series", (Integer) o.getSeries() != null ? 1 : 0, 0, 1), 
				checkCardinality("version", (Integer) o.getVersion() != null ? 1 : 0, 0, 1), 
				checkCardinality("indexFactor", (BigDecimal) o.getIndexFactor() != null ? 1 : 0, 0, 1), 
				checkCardinality("tranche", (Boolean) o.getTranche() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdSIndexAttachmentPoint", (BigDecimal) o.getCdSIndexAttachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("cdSIndexDetachmentPoint", (BigDecimal) o.getCdSIndexDetachmentPoint() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioIndicator", (Boolean) o.getCollateralPortfolioIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioCode", (String) o.getCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (String) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventType", (String) o.getEventType() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventDate", (Date) o.getEventDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("level", (String) o.getLevel() != null ? 1 : 0, 1, 1), 
				checkCardinality("nonReportable", (ESMAEMIRNonReportable) o.getNonReportable() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ESMAEMIRTransactionReport", ValidationResult.ValidationType.CARDINALITY, "ESMAEMIRTransactionReport", path, "", res.getError());
				}
				return success("ESMAEMIRTransactionReport", ValidationResult.ValidationType.CARDINALITY, "ESMAEMIRTransactionReport", path, "");
			})
			.collect(toList());
	}

}
