package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.1
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2003_03")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2003_03.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2003_03 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2003_03";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if actionType = ActionTypeEnum -> NEWT to-string and [\"NOVA\", \"EXER\", \"ALOC\", \"CLRG\", \"CORP\"] all <> eventType then priorUti is absent and priorUtiProprietary is absent";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2003_03 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (areEqual(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), CardinalityOperator.All).and(notEqual(MapperC.<String>of(MapperS.of("NOVA"), MapperS.of("EXER"), MapperS.of("ALOC"), MapperS.of("CLRG"), MapperS.of("CORP")), MapperS.of(eSMAEMIRTransactionReport).<String>map("getEventType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getEventType()), CardinalityOperator.All)).getOrDefault(false)) {
						return notExists(MapperS.of(eSMAEMIRTransactionReport).<String>map("getPriorUti", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPriorUti())).and(notExists(MapperS.of(eSMAEMIRTransactionReport).<String>map("getPriorUtiProprietary", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getPriorUtiProprietary())));
					}
					return ComparisonResult.successEmptyOperand("");
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2003_03 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
