package drr.regulation.fca.ukemir.refit.margin.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.margin.CollateralReport;
import drr.regulation.fca.ukemir.refit.margin.validation.CollateralReportTypeFormatValidator;
import drr.regulation.fca.ukemir.refit.margin.validation.CollateralReportValidator;
import drr.regulation.fca.ukemir.refit.margin.validation.exists.CollateralReportOnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.52.1
 */
@RosettaMeta(model=CollateralReport.class)
public class CollateralReportMeta implements RosettaMetaData<CollateralReport> {

	@Override
	public List<Validator<? super CollateralReport>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
		);
	}
	
	@Override
	public List<Function<? super CollateralReport, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super CollateralReport> validator(ValidatorFactory factory) {
		return factory.<CollateralReport>create(CollateralReportValidator.class);
	}

	@Override
	public Validator<? super CollateralReport> typeFormatValidator(ValidatorFactory factory) {
		return factory.<CollateralReport>create(CollateralReportTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super CollateralReport> validator() {
		return new CollateralReportValidator();
	}

	@Deprecated
	@Override
	public Validator<? super CollateralReport> typeFormatValidator() {
		return new CollateralReportTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super CollateralReport, Set<String>> onlyExistsValidator() {
		return new CollateralReportOnlyExistsValidator();
	}
}
