package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.AdmittedToTradingVenue;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.functions.GetVenueOfExecution;
import drr.standards.iso.MicData;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UKEMIRIsMicXXXX.UKEMIRIsMicXXXXDefault.class)
public abstract class UKEMIRIsMicXXXX implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetVenueOfExecution getVenueOfExecution;

	/**
	* @param reportableEvent 
	* @return isMicXXXX 
	*/
	public Boolean evaluate(ReportableEvent reportableEvent) {
		Boolean isMicXXXX = doEvaluate(reportableEvent);
		
		return isMicXXXX;
	}

	protected abstract Boolean doEvaluate(ReportableEvent reportableEvent);

	public static class UKEMIRIsMicXXXXDefault extends UKEMIRIsMicXXXX {
		@Override
		protected Boolean doEvaluate(ReportableEvent reportableEvent) {
			Boolean isMicXXXX = null;
			return assignOutput(isMicXXXX, reportableEvent);
		}
		
		protected Boolean assignOutput(Boolean isMicXXXX, ReportableEvent reportableEvent) {
			isMicXXXX = notExists(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<EnrichmentData>map("getEnrichment", reportableInformation -> reportableInformation.getEnrichment()).<MicData>mapC("getMicData", enrichmentData -> enrichmentData.getMicData())).and(notExists(MapperS.of(getVenueOfExecution.evaluate(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get())))).and(areEqual(MapperS.of(MapperS.of(reportableEvent).<ReportableInformation>map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).<TransactionInformation>mapC("getTransactionInformation", reportableInformation -> reportableInformation.getTransactionInformation()).<CommonTransactionInformation>map("getFcaTransactionInformation", transactionInformation -> transactionInformation.getFcaTransactionInformation()).get()).<AdmittedToTradingVenue>map("getAdmittedToTradingVenue", commonTransactionInformation -> commonTransactionInformation.getAdmittedToTradingVenue()), MapperS.of(AdmittedToTradingVenue.NOT_ADMITTED), CardinalityOperator.All)).get();
			
			return isMicXXXX;
		}
	}
}
