package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalQuantityScheduleEndDateRule;
import javax.inject.Inject;


@ImplementedBy(EndDateOfTheNotionalQuantityOfLeg1Rule.EndDateOfTheNotionalQuantityOfLeg1RuleDefault.class)
public abstract class EndDateOfTheNotionalQuantityOfLeg1Rule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalQuantityScheduleEndDateRule cDENotionalQuantityScheduleEndDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class EndDateOfTheNotionalQuantityOfLeg1RuleDefault extends EndDateOfTheNotionalQuantityOfLeg1Rule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalQuantityScheduleEndDateRule.evaluate(input);
			
			return output;
		}
	}
}
