package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg2;
import drr.regulation.common.functions.IsAllowableAction;
import javax.inject.Inject;


@ImplementedBy(NameOfTheFloatingRateOfLeg2Rule.NameOfTheFloatingRateOfLeg2RuleDefault.class)
public abstract class NameOfTheFloatingRateOfLeg2Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNameOfTheFloatingRateOfLeg2 getNameOfTheFloatingRateOfLeg2;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class NameOfTheFloatingRateOfLeg2RuleDefault extends NameOfTheFloatingRateOfLeg2Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = MapperS.of(getNameOfTheFloatingRateOfLeg2.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
