package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.Notional;
import drr.regulation.common.functions.PayoutLeg2;
import drr.regulation.common.functions.TradableProductForEvent;
import javax.inject.Inject;


@ImplementedBy(NotionalCurrency2Rule.NotionalCurrency2RuleDefault.class)
public abstract class NotionalCurrency2Rule implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected Notional notional;
	@Inject protected PayoutLeg2 payoutLeg2;
	@Inject protected TradableProductForEvent tradableProductForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input);

	public static class NotionalCurrency2RuleDefault extends NotionalCurrency2Rule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<FieldWithMetaString> thenArg1 = thenArg0
				.mapSingleToItem(reportableEvent -> {
					final Boolean _boolean = isActionTypeTERM.evaluate(thenArg0.get());
					final MapperS<TradableProduct> _thenArg0;
					if ((_boolean == null ? false : _boolean)) {
						_thenArg0 = MapperS.of(beforeTradeForEvent.evaluate(thenArg0.get())).<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct());
					} else {
						_thenArg0 = MapperS.of(tradableProductForEvent.evaluate(thenArg0.get()));
					}
					final MapperS<PayoutLegWithAuxiliary> _thenArg1 = _thenArg0
						.mapSingleToItem(item -> MapperS.of(payoutLeg2.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), reportableEvent.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get())));
					return _thenArg1
						.mapSingleToItem(item -> MapperS.of(notional.evaluate(item.get())).<UnitType>map("getUnit", measure -> measure.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency()));
				});
			output = thenArg1
				.mapSingleToItem(item -> {
					final FieldWithMetaString fieldWithMetaString = item.get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString == null ? null : fieldWithMetaString.getValue())));
				}).get();
			
			return output;
		}
	}
}
