package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.fca.ukemir.refit.trade.NotionalQuantityScheduleLeg2Report;
import drr.regulation.fca.ukemir.refit.trade.functions.UKEMIRReportableQuantityPeriodLeg2;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg2Rule.NotionalQuantityScheduleLeg2RuleDefault.class)
public abstract class NotionalQuantityScheduleLeg2Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalQuantityScheduleLeg2Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EffectiveDateOfTheNotionalQuantityOfLeg2Rule effectiveDateOfTheNotionalQuantityOfLeg2Rule;
	@Inject protected EndDateOfTheNotionalQuantityOfLeg2Rule endDateOfTheNotionalQuantityOfLeg2Rule;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected NotionalQuantityInEffectOnAssociatedEffectiveDateOfLeg2Rule notionalQuantityInEffectOnAssociatedEffectiveDateOfLeg2Rule;
	@Inject protected UKEMIRReportableQuantityPeriodLeg2 uKEMIRReportableQuantityPeriodLeg2;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalQuantityScheduleLeg2Report> evaluate(TransactionReportInstruction input) {
		List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalQuantityScheduleLeg2Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalQuantityScheduleLeg2Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalQuantityScheduleLeg2Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalQuantityScheduleLeg2RuleDefault extends NotionalQuantityScheduleLeg2Rule {
		@Override
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> assignOutput(List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperC<QuantityReportablePeriod> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<QuantityReportablePeriod>of(uKEMIRReportableQuantityPeriodLeg2.evaluate(item.get())));
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(NotionalQuantityScheduleLeg2Report.builder()
					.setValue(notionalQuantityInEffectOnAssociatedEffectiveDateOfLeg2Rule.evaluate(item.get()))
					.setEffectiveDate(effectiveDateOfTheNotionalQuantityOfLeg2Rule.evaluate(item.get()))
					.setEndDate(endDateOfTheNotionalQuantityOfLeg2Rule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
