package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.identifier.IdentifiedList;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iosco.cde.reports.CDEPackageIdentifierRule;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(PackageIdentifierRule.PackageIdentifierRuleDefault.class)
public abstract class PackageIdentifierRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPackageIdentifierRule cDEPackageIdentifierRule;
	@Inject protected GetPackageInformation getPackageInformation;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PackageIdentifierRuleDefault extends PackageIdentifierRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<IdentifiedList> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(getPackageInformation.evaluate(item.get())));
			final MapperC<FieldWithMetaString> thenArg2 = thenArg1
				.mapSingleToList(item -> MapperC.<FieldWithMetaString>of(cDEPackageIdentifierRule.evaluate(item.get()).stream()
					.<FieldWithMetaString>map(string -> FieldWithMetaString.builder().setValue(string).build())
					.collect(Collectors.toList())
				));
			final FieldWithMetaString fieldWithMetaString = MapperS.of(thenArg2.get()).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
