package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.ExecutionAgent;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ExecutionAgentValidator implements Validator<ExecutionAgent> {

	private List<ComparisonResult> getComparisonResults(ExecutionAgent o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("executionAgentReportingParty", (String) o.getExecutionAgentReportingParty() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionAgentReportingCounterparty", (String) o.getExecutionAgentReportingCounterparty() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ExecutionAgent o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ExecutionAgent", ValidationResult.ValidationType.CARDINALITY, "ExecutionAgent", path, "", res.getError());
				}
				return success("ExecutionAgent", ValidationResult.ValidationType.CARDINALITY, "ExecutionAgent", path, "");
			})
			.collect(toList());
	}

}
