package drr.regulation.fca.ukemir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.OtherPaymentReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class OtherPaymentReportTypeFormatValidator implements Validator<OtherPaymentReport> {

	private List<ComparisonResult> getComparisonResults(OtherPaymentReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("amount", o.getAmount(), of(25), of(5), empty(), empty()), 
				checkString("payer", o.getPayer(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkString("receiver", o.getReceiver(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, OtherPaymentReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("OtherPaymentReport", ValidationResult.ValidationType.TYPE_FORMAT, "OtherPaymentReport", path, "", res.getError());
				}
				return success("OtherPaymentReport", ValidationResult.ValidationType.TYPE_FORMAT, "OtherPaymentReport", path, "");
			})
			.collect(toList());
	}

}
