package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.52.1
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2106_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2106_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2106_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2106_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if floatingRateReferencePeriodOfLeg2TimePeriod exists and [\"YEAR\", \"MNTH\", \"WEEK\", \"DAIL\"] any = floatingRateReferencePeriodOfLeg2TimePeriod then floatingRateReferencePeriodOfLeg2Multiplier exists and floatingRateReferencePeriodOfLeg2Multiplier >= 0 and floatingRateReferencePeriodOfLeg2Multiplier < 1000 else floatingRateReferencePeriodOfLeg2Multiplier is absent";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2106_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (exists(MapperS.of(fCAUKEMIRTransactionReport).<String>map("getFloatingRateReferencePeriodOfLeg2TimePeriod", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2TimePeriod())).and(areEqual(MapperC.<String>of(MapperS.of("YEAR"), MapperS.of("MNTH"), MapperS.of("WEEK"), MapperS.of("DAIL")), MapperS.of(fCAUKEMIRTransactionReport).<String>map("getFloatingRateReferencePeriodOfLeg2TimePeriod", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2TimePeriod()), CardinalityOperator.Any)).getOrDefault(false)) {
						return exists(MapperS.of(fCAUKEMIRTransactionReport).<Integer>map("getFloatingRateReferencePeriodOfLeg2Multiplier", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2Multiplier())).and(greaterThanEquals(MapperS.of(fCAUKEMIRTransactionReport).<Integer>map("getFloatingRateReferencePeriodOfLeg2Multiplier", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2Multiplier()), MapperS.of(0), CardinalityOperator.All)).and(lessThan(MapperS.of(fCAUKEMIRTransactionReport).<Integer>map("getFloatingRateReferencePeriodOfLeg2Multiplier", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2Multiplier()), MapperS.of(1000), CardinalityOperator.All));
					}
					return notExists(MapperS.of(fCAUKEMIRTransactionReport).<Integer>map("getFloatingRateReferencePeriodOfLeg2Multiplier", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getFloatingRateReferencePeriodOfLeg2Multiplier()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2106_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
