package drr.regulation.jfsa.rewrite.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.PartyIdentifierFormatEnum;
import drr.regulation.jfsa.rewrite.trade.OtherPaymentReport;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class OtherPaymentReportValidator implements Validator<OtherPaymentReport> {

	private List<ComparisonResult> getComparisonResults(OtherPaymentReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("paymentType", (String) o.getPaymentType() != null ? 1 : 0, 1, 1), 
				checkCardinality("amount", (BigDecimal) o.getAmount() != null ? 1 : 0, 1, 1), 
				checkCardinality("currency", (ISOCurrencyCodeEnum) o.getCurrency() != null ? 1 : 0, 1, 1), 
				checkCardinality("date", (Date) o.getDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("payer", (String) o.getPayer() != null ? 1 : 0, 1, 1), 
				checkCardinality("payerFormat", (PartyIdentifierFormatEnum) o.getPayerFormat() != null ? 1 : 0, 1, 1), 
				checkCardinality("receiver", (String) o.getReceiver() != null ? 1 : 0, 1, 1), 
				checkCardinality("receiverFormat", (PartyIdentifierFormatEnum) o.getReceiverFormat() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, OtherPaymentReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("OtherPaymentReport", ValidationResult.ValidationType.CARDINALITY, "OtherPaymentReport", path, "", res.getError());
				}
				return success("OtherPaymentReport", ValidationResult.ValidationType.CARDINALITY, "OtherPaymentReport", path, "");
			})
			.collect(toList());
	}

}
