package drr.regulation.jfsa.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.PackageTransactionPrice;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class PackageTransactionPriceTypeFormatValidator implements Validator<PackageTransactionPrice> {

	private List<ComparisonResult> getComparisonResults(PackageTransactionPrice o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("packageTransactionPriceMonetary", o.getPackageTransactionPriceMonetary(), of(18), of(13), empty(), empty()), 
				checkNumber("packageTransactionPriceDecimal", o.getPackageTransactionPriceDecimal(), of(11), of(10), empty(), empty()), 
				checkNumber("packageTransactionPriceBasis", o.getPackageTransactionPriceBasis(), of(5), empty(), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PackageTransactionPrice o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PackageTransactionPrice", ValidationResult.ValidationType.TYPE_FORMAT, "PackageTransactionPrice", path, "", res.getError());
				}
				return success("PackageTransactionPrice", ValidationResult.ValidationType.TYPE_FORMAT, "PackageTransactionPrice", path, "");
			})
			.collect(toList());
	}

}
