package drr.regulation.mas.rewrite.margin.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.margin.MASMarginReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkNumber;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class MASMarginReportTypeFormatValidator implements Validator<MASMarginReport> {

	private List<ComparisonResult> getComparisonResults(MASMarginReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("counterparty1", o.getCounterparty1(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("counterparty2", o.getCounterparty2(), 20, of(72), of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), 
				checkString("reportingSpecifiedPerson", o.getReportingSpecifiedPerson(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), 
				checkString("uniqueTransactionIdentifier", o.getUniqueTransactionIdentifier(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), 
				checkString("uniqueTransactionIdentifierProprietary", o.getUniqueTransactionIdentifierProprietary(), 0, of(72), of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,70}[a-zA-Z0-9]{1}"))), 
				checkString("initialMarginCollateralPortfolioCode", o.getInitialMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkString("variationMarginCollateralPortfolioCode", o.getVariationMarginCollateralPortfolioCode(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), 
				checkNumber("initialMarginPostedByCounterparty1PreHaircut", o.getInitialMarginPostedByCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginPostedByCounterparty1PostHaircut", o.getInitialMarginPostedByCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByCounterparty1PreHaircut", o.getInitialMarginCollectedByCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("initialMarginCollectedByCounterparty1PostHaircut", o.getInitialMarginCollectedByCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByCounterparty1PreHaircut", o.getVariationMarginPostedByCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginPostedByCounterparty1PostHaircut", o.getVariationMarginPostedByCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByCounterparty1PreHaircut", o.getVariationMarginCollectedByCounterparty1PreHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("variationMarginCollectedByCounterparty1PostHaircut", o.getVariationMarginCollectedByCounterparty1PostHaircut(), of(25), of(5), empty(), empty()), 
				checkNumber("excessCollateralPostedByCounterparty1", o.getExcessCollateralPostedByCounterparty1(), of(25), of(5), empty(), empty()), 
				checkNumber("excessCollateralCollectedByCounterparty1", o.getExcessCollateralCollectedByCounterparty1(), of(25), of(5), empty(), empty()), 
				checkString("executionAgentOfTheCounterparty1", o.getExecutionAgentOfTheCounterparty1(), 0, empty(), of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASMarginReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MASMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "MASMarginReport", path, "", res.getError());
				}
				return success("MASMarginReport", ValidationResult.ValidationType.TYPE_FORMAT, "MASMarginReport", path, "");
			})
			.collect(toList());
	}

}
