package drr.regulation.mas.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.mas.rewrite.trade.meta.MASTransactionReportMeta;
import iso20022.auth030.mas.Frequency13Code__1;
import iso20022.auth030.mas.InterestComputationMethod4Code;
import iso20022.auth030.mas.TradingCapacity7Code;
import iso20022.auth030.mas.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 5.52.1
 */
@RosettaDataType(value="MASTransactionReport", builder=MASTransactionReport.MASTransactionReportBuilderImpl.class, version="5.52.1")
@RuneDataType(value="MASTransactionReport", model="drr", builder=MASTransactionReport.MASTransactionReportBuilderImpl.class, version="5.52.1")
public interface MASTransactionReport extends RosettaModelObject {

	MASTransactionReportMeta metaData = new MASTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	String getCounterparty1();
	String getCounterparty2();
	Boolean getCounterparty2IdentifierType();
	TradingCapacity7Code getTradingCapacityOfSpecifiedPerson();
	String getDirection();
	String getDirectionOfLeg1();
	String getDirectionOfLeg2();
	String getReportingSpecifiedPerson();
	String getDataSubmitter();
	String getUniqueTransactionIdentifier();
	String getUniqueTransactionIdentifierProprietary();
	String getUniqueProductIdentifier();
	String getPriorUTI();
	String getPriorUTIProprietary();
	String getContractType();
	String getAssetClass();
	String getUnderlying();
	String getUnderlyingIdentificationType();
	String getUnderlyingIdOther();
	String getUnderlyingIdOtherSource();
	String getNameOfTheUnderlyingIndex();
	BigDecimal getFixedRateOfLeg1();
	String getIdentifierOfFloatingRateOfLeg1();
	String getNameOfTheFloatingRateOfLeg1();
	SpreadOfLeg1 getSpreadOfLeg1();
	BigDecimal getFixedRateOfLeg2();
	String getIdentifierOfFloatingRateOfLeg2();
	String getNameOfTheFloatingRateOfLeg2();
	SpreadOfLeg2 getSpreadOfLeg2();
	String getOptionType();
	String getOptionStyle();
	Date getFirstExerciseDate();
	Date getEffectiveDate();
	Date getExpirationDate();
	String getSwapLinkID();
	String getPackageIdentifier();
	String getDeliveryType();
	ISOCurrencyCodeEnum getSettlementCurrency1();
	ISOCurrencyCodeEnum getSettlementCurrency2();
	Date getFinalContractualSettlementDate();
	String getCleared();
	String getCentralCounterparty();
	String getClearingMember();
	ZonedDateTime getClearingTimestamp();
	String getPlatformIdentifier();
	String getBookingLocation();
	String getTraderLocation();
	String getConfirmed();
	ZonedDateTime getConfirmationTimestamp();
	ZonedDateTime getExecutionTimestamp();
	ZonedDateTime getReportingTimestamp();
	List<? extends BasketConstituentsReport> getBasketConstituents();
	BigDecimal getValuationAmount();
	ISOCurrencyCodeEnum getValuationCurrency();
	ValuationType1Code getValuationMethod();
	ZonedDateTime getValuationTimestamp();
	Boolean getCollateralPortfolioIndicator();
	String getInitialMarginCollateralPortfolioCode();
	String getVariationMarginCollateralPortfolioCode();
	BigDecimal getNotionalAmountOfTheContractOrLeg1();
	ISOCurrencyCodeEnum getNotionalCurrencyOfTheContractOrLeg1();
	BigDecimal getNotionalAmountOfLeg2();
	ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2();
	BigDecimal getTotalNotionalQuantityOfTheContractOrLeg1();
	String getQuantityUnitOfMeasureForTheContractOrLeg1();
	BigDecimal getNotionalQuantityOfTheContractOrLeg1();
	String getQuantityFrequencyOfTheContractOrLeg1();
	Integer getQuantityFrequencyMultiplierOfTheContractOrLeg1();
	BigDecimal getTotalNotionalQuantityLeg2();
	String getQuantityUnitOfMeasureLeg2();
	BigDecimal getNotionalQuantityOfLeg2();
	String getQuantityFrequencyOfLeg2();
	Integer getQuantityFrequencyMultiplierOfLeg2();
	BigDecimal getCallAmount();
	ISOCurrencyCodeEnum getCallCurrency();
	BigDecimal getPutAmount();
	ISOCurrencyCodeEnum getPutCurrency();
	PriceAndNotation getPrice();
	String getPriceUnitOfMeasure();
	List<? extends PriceScheduleReport> getPriceSchedule();
	StrikePriceAndNotation getStrikePrice();
	List<? extends StrikePriceScheduleReport> getStrikePriceSchedule();
	BigDecimal getOptionPremiumAmount();
	ISOCurrencyCodeEnum getOptionPremiumCurrency();
	BigDecimal getExchangeRate();
	String getExchangeRateBasis();
	InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg1();
	InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg2();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1();
	InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2();
	String getFloatingRateResetFrequencyPeriodOfLeg1();
	Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg1();
	String getFloatingRateResetFrequencyPeriodOfLeg2();
	Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg2();
	Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg1();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1();
	Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg2();
	Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2();
	Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();
	Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg2();
	Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();
	List<? extends OtherPaymentReport> getOtherPayment();
	String getActionType();
	String getEventType();
	ZonedDateTime getEventDate();
	MASNonReportable getNonReportable();
	String getTechnicalRecordId();
	String getCounterparty2Name();
	String getExecutionAgentOfCounterparty1();
	String getExecutionAgentOfCounterparty2DTCC();
	List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1DTCC();
	List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2DTCC();
	List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1DTCC();
	List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2DTCC();

	/*********************** Build Methods  ***********************/
	MASTransactionReport build();
	
	MASTransactionReport.MASTransactionReportBuilder toBuilder();
	
	static MASTransactionReport.MASTransactionReportBuilder builder() {
		return new MASTransactionReport.MASTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends MASTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends MASTransactionReport> getType() {
		return MASTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("tradingCapacityOfSpecifiedPerson"), TradingCapacity7Code.class, getTradingCapacityOfSpecifiedPerson(), this);
		processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
		processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, getDirectionOfLeg1(), this);
		processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, getDirectionOfLeg2(), this);
		processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, getReportingSpecifiedPerson(), this);
		processor.processBasic(path.newSubPath("dataSubmitter"), String.class, getDataSubmitter(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("underlying"), String.class, getUnderlying(), this);
		processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
		processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
		processor.processBasic(path.newSubPath("underlyingIdOtherSource"), String.class, getUnderlyingIdOtherSource(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, getFixedRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, getIdentifierOfFloatingRateOfLeg1(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
		processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.class, getSpreadOfLeg1());
		processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, getFixedRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, getIdentifierOfFloatingRateOfLeg2(), this);
		processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
		processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.class, getSpreadOfLeg2());
		processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("swapLinkID"), String.class, getSwapLinkID(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("settlementCurrency1"), ISOCurrencyCodeEnum.class, getSettlementCurrency1(), this);
		processor.processBasic(path.newSubPath("settlementCurrency2"), ISOCurrencyCodeEnum.class, getSettlementCurrency2(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), String.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), String.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
		processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
		processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
		processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("notionalAmountOfTheContractOrLeg1"), BigDecimal.class, getNotionalAmountOfTheContractOrLeg1(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyOfTheContractOrLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfTheContractOrLeg1(), this);
		processor.processBasic(path.newSubPath("notionalAmountOfLeg2"), BigDecimal.class, getNotionalAmountOfLeg2(), this);
		processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfLeg2(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityOfTheContractOrLeg1"), BigDecimal.class, getTotalNotionalQuantityOfTheContractOrLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureForTheContractOrLeg1"), String.class, getQuantityUnitOfMeasureForTheContractOrLeg1(), this);
		processor.processBasic(path.newSubPath("notionalQuantityOfTheContractOrLeg1"), BigDecimal.class, getNotionalQuantityOfTheContractOrLeg1(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyOfTheContractOrLeg1"), String.class, getQuantityFrequencyOfTheContractOrLeg1(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfTheContractOrLeg1"), Integer.class, getQuantityFrequencyMultiplierOfTheContractOrLeg1(), this);
		processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("notionalQuantityOfLeg2"), BigDecimal.class, getNotionalQuantityOfLeg2(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyOfLeg2"), String.class, getQuantityFrequencyOfLeg2(), this);
		processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfLeg2"), Integer.class, getQuantityFrequencyMultiplierOfLeg2(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("price"), processor, PriceAndNotation.class, getPrice());
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.class, getStrikePrice());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.class, getStrikePriceSchedule());
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionOfLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, getFloatingRateResetFrequencyPeriodOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFixedRatePaymentFrequencyPeriodOfLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, getFixedRatePaymentFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg2(), this);
		processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.class, getOtherPayment());
		processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventDate"), ZonedDateTime.class, getEventDate(), this);
		processRosetta(path.newSubPath("nonReportable"), processor, MASNonReportable.class, getNonReportable());
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, getExecutionAgentOfCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, getExecutionAgentOfCounterparty2DTCC(), this);
		processRosetta(path.newSubPath("notionalAmountScheduleLeg1DTCC"), processor, NotionalAmountScheduleLeg1Report.class, getNotionalAmountScheduleLeg1DTCC());
		processRosetta(path.newSubPath("notionalAmountScheduleLeg2DTCC"), processor, NotionalAmountScheduleLeg2Report.class, getNotionalAmountScheduleLeg2DTCC());
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg1DTCC"), processor, NotionalQuantityScheduleLeg1Report.class, getNotionalQuantityScheduleLeg1DTCC());
		processRosetta(path.newSubPath("notionalQuantityScheduleLeg2DTCC"), processor, NotionalQuantityScheduleLeg2Report.class, getNotionalQuantityScheduleLeg2DTCC());
	}
	

	/*********************** Builder Interface  ***********************/
	interface MASTransactionReportBuilder extends MASTransactionReport, RosettaModelObjectBuilder {
		SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1();
		@Override
		SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1();
		SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2();
		@Override
		SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2();
		BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index);
		@Override
		List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents();
		PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice();
		@Override
		PriceAndNotation.PriceAndNotationBuilder getPrice();
		PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index);
		@Override
		List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule();
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice();
		@Override
		StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice();
		StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index);
		@Override
		List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule();
		OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index);
		@Override
		List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment();
		MASNonReportable.MASNonReportableBuilder getOrCreateNonReportable();
		@Override
		MASNonReportable.MASNonReportableBuilder getNonReportable();
		NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1DTCC(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1DTCC();
		NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2DTCC(int index);
		@Override
		List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2DTCC();
		NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1DTCC(int index);
		@Override
		List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1DTCC();
		NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2DTCC(int index);
		@Override
		List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2DTCC();
		MASTransactionReport.MASTransactionReportBuilder setCounterparty1(String counterparty1);
		MASTransactionReport.MASTransactionReportBuilder setCounterparty2(String counterparty2);
		MASTransactionReport.MASTransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		MASTransactionReport.MASTransactionReportBuilder setTradingCapacityOfSpecifiedPerson(TradingCapacity7Code tradingCapacityOfSpecifiedPerson);
		MASTransactionReport.MASTransactionReportBuilder setDirection(String direction);
		MASTransactionReport.MASTransactionReportBuilder setDirectionOfLeg1(String directionOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setDirectionOfLeg2(String directionOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setReportingSpecifiedPerson(String reportingSpecifiedPerson);
		MASTransactionReport.MASTransactionReportBuilder setDataSubmitter(String dataSubmitter);
		MASTransactionReport.MASTransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		MASTransactionReport.MASTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		MASTransactionReport.MASTransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		MASTransactionReport.MASTransactionReportBuilder setPriorUTI(String priorUTI);
		MASTransactionReport.MASTransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		MASTransactionReport.MASTransactionReportBuilder setContractType(String contractType);
		MASTransactionReport.MASTransactionReportBuilder setAssetClass(String assetClass);
		MASTransactionReport.MASTransactionReportBuilder setUnderlying(String underlying);
		MASTransactionReport.MASTransactionReportBuilder setUnderlyingIdentificationType(String underlyingIdentificationType);
		MASTransactionReport.MASTransactionReportBuilder setUnderlyingIdOther(String underlyingIdOther);
		MASTransactionReport.MASTransactionReportBuilder setUnderlyingIdOtherSource(String underlyingIdOtherSource);
		MASTransactionReport.MASTransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		MASTransactionReport.MASTransactionReportBuilder setFixedRateOfLeg1(BigDecimal fixedRateOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String identifierOfFloatingRateOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String nameOfTheFloatingRateOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 spreadOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFixedRateOfLeg2(BigDecimal fixedRateOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String identifierOfFloatingRateOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String nameOfTheFloatingRateOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 spreadOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setOptionType(String optionType);
		MASTransactionReport.MASTransactionReportBuilder setOptionStyle(String optionStyle);
		MASTransactionReport.MASTransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		MASTransactionReport.MASTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		MASTransactionReport.MASTransactionReportBuilder setExpirationDate(Date expirationDate);
		MASTransactionReport.MASTransactionReportBuilder setSwapLinkID(String swapLinkID);
		MASTransactionReport.MASTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		MASTransactionReport.MASTransactionReportBuilder setDeliveryType(String deliveryType);
		MASTransactionReport.MASTransactionReportBuilder setSettlementCurrency1(ISOCurrencyCodeEnum settlementCurrency1);
		MASTransactionReport.MASTransactionReportBuilder setSettlementCurrency2(ISOCurrencyCodeEnum settlementCurrency2);
		MASTransactionReport.MASTransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		MASTransactionReport.MASTransactionReportBuilder setCleared(String cleared);
		MASTransactionReport.MASTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		MASTransactionReport.MASTransactionReportBuilder setClearingMember(String clearingMember);
		MASTransactionReport.MASTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		MASTransactionReport.MASTransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		MASTransactionReport.MASTransactionReportBuilder setBookingLocation(String bookingLocation);
		MASTransactionReport.MASTransactionReportBuilder setTraderLocation(String traderLocation);
		MASTransactionReport.MASTransactionReportBuilder setConfirmed(String confirmed);
		MASTransactionReport.MASTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime confirmationTimestamp);
		MASTransactionReport.MASTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		MASTransactionReport.MASTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		MASTransactionReport.MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		MASTransactionReport.MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int idx);
		MASTransactionReport.MASTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		MASTransactionReport.MASTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		MASTransactionReport.MASTransactionReportBuilder setValuationAmount(BigDecimal valuationAmount);
		MASTransactionReport.MASTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum valuationCurrency);
		MASTransactionReport.MASTransactionReportBuilder setValuationMethod(ValuationType1Code valuationMethod);
		MASTransactionReport.MASTransactionReportBuilder setValuationTimestamp(ZonedDateTime valuationTimestamp);
		MASTransactionReport.MASTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		MASTransactionReport.MASTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		MASTransactionReport.MASTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);
		MASTransactionReport.MASTransactionReportBuilder setNotionalAmountOfTheContractOrLeg1(BigDecimal notionalAmountOfTheContractOrLeg1);
		MASTransactionReport.MASTransactionReportBuilder setNotionalCurrencyOfTheContractOrLeg1(ISOCurrencyCodeEnum notionalCurrencyOfTheContractOrLeg1);
		MASTransactionReport.MASTransactionReportBuilder setNotionalAmountOfLeg2(BigDecimal notionalAmountOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum notionalCurrencyOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setTotalNotionalQuantityOfTheContractOrLeg1(BigDecimal totalNotionalQuantityOfTheContractOrLeg1);
		MASTransactionReport.MASTransactionReportBuilder setQuantityUnitOfMeasureForTheContractOrLeg1(String quantityUnitOfMeasureForTheContractOrLeg1);
		MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityOfTheContractOrLeg1(BigDecimal notionalQuantityOfTheContractOrLeg1);
		MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyOfTheContractOrLeg1(String quantityFrequencyOfTheContractOrLeg1);
		MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyMultiplierOfTheContractOrLeg1(Integer quantityFrequencyMultiplierOfTheContractOrLeg1);
		MASTransactionReport.MASTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal totalNotionalQuantityLeg2);
		MASTransactionReport.MASTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityOfLeg2(BigDecimal notionalQuantityOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyOfLeg2(String quantityFrequencyOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyMultiplierOfLeg2(Integer quantityFrequencyMultiplierOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setCallAmount(BigDecimal callAmount);
		MASTransactionReport.MASTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		MASTransactionReport.MASTransactionReportBuilder setPutAmount(BigDecimal putAmount);
		MASTransactionReport.MASTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		MASTransactionReport.MASTransactionReportBuilder setPrice(PriceAndNotation price);
		MASTransactionReport.MASTransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		MASTransactionReport.MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport priceSchedule);
		MASTransactionReport.MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport priceSchedule, int idx);
		MASTransactionReport.MASTransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedule);
		MASTransactionReport.MASTransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedule);
		MASTransactionReport.MASTransactionReportBuilder setStrikePrice(StrikePriceAndNotation strikePrice);
		MASTransactionReport.MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport strikePriceSchedule);
		MASTransactionReport.MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport strikePriceSchedule, int idx);
		MASTransactionReport.MASTransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedule);
		MASTransactionReport.MASTransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedule);
		MASTransactionReport.MASTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		MASTransactionReport.MASTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		MASTransactionReport.MASTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		MASTransactionReport.MASTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		MASTransactionReport.MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg1(InterestComputationMethod4Code fixedRateDayCountConventionOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg2(InterestComputationMethod4Code fixedRateDayCountConventionOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String floatingRateResetFrequencyPeriodOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg1(Integer floatingRateResetFrequencyPeriodMultiplierOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String floatingRateResetFrequencyPeriodOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg2(Integer floatingRateResetFrequencyPeriodMultiplierOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
		MASTransactionReport.MASTransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment);
		MASTransactionReport.MASTransactionReportBuilder addOtherPayment(OtherPaymentReport otherPayment, int idx);
		MASTransactionReport.MASTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		MASTransactionReport.MASTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayment);
		MASTransactionReport.MASTransactionReportBuilder setActionType(String actionType);
		MASTransactionReport.MASTransactionReportBuilder setEventType(String eventType);
		MASTransactionReport.MASTransactionReportBuilder setEventDate(ZonedDateTime eventDate);
		MASTransactionReport.MASTransactionReportBuilder setNonReportable(MASNonReportable nonReportable);
		MASTransactionReport.MASTransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		MASTransactionReport.MASTransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		MASTransactionReport.MASTransactionReportBuilder setExecutionAgentOfCounterparty1(String executionAgentOfCounterparty1);
		MASTransactionReport.MASTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String executionAgentOfCounterparty2DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report notionalAmountScheduleLeg1DTCC, int idx);
		MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCC);
		MASTransactionReport.MASTransactionReportBuilder setNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report notionalAmountScheduleLeg2DTCC, int idx);
		MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCC);
		MASTransactionReport.MASTransactionReportBuilder setNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report notionalQuantityScheduleLeg1DTCC, int idx);
		MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCC);
		MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2DTCC);
		MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report notionalQuantityScheduleLeg2DTCC, int idx);
		MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCC);
		MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCC);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("tradingCapacityOfSpecifiedPerson"), TradingCapacity7Code.class, getTradingCapacityOfSpecifiedPerson(), this);
			processor.processBasic(path.newSubPath("direction"), String.class, getDirection(), this);
			processor.processBasic(path.newSubPath("directionOfLeg1"), String.class, getDirectionOfLeg1(), this);
			processor.processBasic(path.newSubPath("directionOfLeg2"), String.class, getDirectionOfLeg2(), this);
			processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, getReportingSpecifiedPerson(), this);
			processor.processBasic(path.newSubPath("dataSubmitter"), String.class, getDataSubmitter(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("contractType"), String.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), String.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("underlying"), String.class, getUnderlying(), this);
			processor.processBasic(path.newSubPath("underlyingIdentificationType"), String.class, getUnderlyingIdentificationType(), this);
			processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, getUnderlyingIdOther(), this);
			processor.processBasic(path.newSubPath("underlyingIdOtherSource"), String.class, getUnderlyingIdOtherSource(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processor.processBasic(path.newSubPath("fixedRateOfLeg1"), BigDecimal.class, getFixedRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg1"), String.class, getIdentifierOfFloatingRateOfLeg1(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg1"), String.class, getNameOfTheFloatingRateOfLeg1(), this);
			processRosetta(path.newSubPath("spreadOfLeg1"), processor, SpreadOfLeg1.SpreadOfLeg1Builder.class, getSpreadOfLeg1());
			processor.processBasic(path.newSubPath("fixedRateOfLeg2"), BigDecimal.class, getFixedRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("identifierOfFloatingRateOfLeg2"), String.class, getIdentifierOfFloatingRateOfLeg2(), this);
			processor.processBasic(path.newSubPath("nameOfTheFloatingRateOfLeg2"), String.class, getNameOfTheFloatingRateOfLeg2(), this);
			processRosetta(path.newSubPath("spreadOfLeg2"), processor, SpreadOfLeg2.SpreadOfLeg2Builder.class, getSpreadOfLeg2());
			processor.processBasic(path.newSubPath("optionType"), String.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), String.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("swapLinkID"), String.class, getSwapLinkID(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processor.processBasic(path.newSubPath("deliveryType"), String.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("settlementCurrency1"), ISOCurrencyCodeEnum.class, getSettlementCurrency1(), this);
			processor.processBasic(path.newSubPath("settlementCurrency2"), ISOCurrencyCodeEnum.class, getSettlementCurrency2(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processor.processBasic(path.newSubPath("cleared"), String.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), String.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), String.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("confirmed"), String.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, getConfirmationTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, getValuationAmount(), this);
			processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, getValuationCurrency(), this);
			processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, getValuationMethod(), this);
			processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, getValuationTimestamp(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("notionalAmountOfTheContractOrLeg1"), BigDecimal.class, getNotionalAmountOfTheContractOrLeg1(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyOfTheContractOrLeg1"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfTheContractOrLeg1(), this);
			processor.processBasic(path.newSubPath("notionalAmountOfLeg2"), BigDecimal.class, getNotionalAmountOfLeg2(), this);
			processor.processBasic(path.newSubPath("notionalCurrencyOfLeg2"), ISOCurrencyCodeEnum.class, getNotionalCurrencyOfLeg2(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityOfTheContractOrLeg1"), BigDecimal.class, getTotalNotionalQuantityOfTheContractOrLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureForTheContractOrLeg1"), String.class, getQuantityUnitOfMeasureForTheContractOrLeg1(), this);
			processor.processBasic(path.newSubPath("notionalQuantityOfTheContractOrLeg1"), BigDecimal.class, getNotionalQuantityOfTheContractOrLeg1(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyOfTheContractOrLeg1"), String.class, getQuantityFrequencyOfTheContractOrLeg1(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfTheContractOrLeg1"), Integer.class, getQuantityFrequencyMultiplierOfTheContractOrLeg1(), this);
			processor.processBasic(path.newSubPath("totalNotionalQuantityLeg2"), BigDecimal.class, getTotalNotionalQuantityLeg2(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("notionalQuantityOfLeg2"), BigDecimal.class, getNotionalQuantityOfLeg2(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyOfLeg2"), String.class, getQuantityFrequencyOfLeg2(), this);
			processor.processBasic(path.newSubPath("quantityFrequencyMultiplierOfLeg2"), Integer.class, getQuantityFrequencyMultiplierOfLeg2(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("price"), processor, PriceAndNotation.PriceAndNotationBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PriceScheduleReport.PriceScheduleReportBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePrice"), processor, StrikePriceAndNotation.StrikePriceAndNotationBuilder.class, getStrikePrice());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, StrikePriceScheduleReport.StrikePriceScheduleReportBuilder.class, getStrikePriceSchedule());
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionOfLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFixedRateDayCountConventionOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg1"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateDayCountConventionOfLeg2"), InterestComputationMethod4Code.class, getFloatingRateDayCountConventionOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg1"), String.class, getFloatingRateResetFrequencyPeriodOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodOfLeg2"), String.class, getFloatingRateResetFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRateResetFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFixedRatePaymentFrequencyPeriodOfLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, getFixedRatePaymentFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg1"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodOfLeg2"), Frequency13Code__1.class, getFloatingRatePaymentFrequencyPeriodOfLeg2(), this);
			processor.processBasic(path.newSubPath("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2"), Integer.class, getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPaymentReport.OtherPaymentReportBuilder.class, getOtherPayment());
			processor.processBasic(path.newSubPath("actionType"), String.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), String.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventDate"), ZonedDateTime.class, getEventDate(), this);
			processRosetta(path.newSubPath("nonReportable"), processor, MASNonReportable.MASNonReportableBuilder.class, getNonReportable());
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentOfCounterparty1"), String.class, getExecutionAgentOfCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentOfCounterparty2DTCC"), String.class, getExecutionAgentOfCounterparty2DTCC(), this);
			processRosetta(path.newSubPath("notionalAmountScheduleLeg1DTCC"), processor, NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder.class, getNotionalAmountScheduleLeg1DTCC());
			processRosetta(path.newSubPath("notionalAmountScheduleLeg2DTCC"), processor, NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder.class, getNotionalAmountScheduleLeg2DTCC());
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg1DTCC"), processor, NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder.class, getNotionalQuantityScheduleLeg1DTCC());
			processRosetta(path.newSubPath("notionalQuantityScheduleLeg2DTCC"), processor, NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder.class, getNotionalQuantityScheduleLeg2DTCC());
		}
		

		MASTransactionReport.MASTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of MASTransactionReport  ***********************/
	class MASTransactionReportImpl implements MASTransactionReport {
		private final String counterparty1;
		private final String counterparty2;
		private final Boolean counterparty2IdentifierType;
		private final TradingCapacity7Code tradingCapacityOfSpecifiedPerson;
		private final String direction;
		private final String directionOfLeg1;
		private final String directionOfLeg2;
		private final String reportingSpecifiedPerson;
		private final String dataSubmitter;
		private final String uniqueTransactionIdentifier;
		private final String uniqueTransactionIdentifierProprietary;
		private final String uniqueProductIdentifier;
		private final String priorUTI;
		private final String priorUTIProprietary;
		private final String contractType;
		private final String assetClass;
		private final String underlying;
		private final String underlyingIdentificationType;
		private final String underlyingIdOther;
		private final String underlyingIdOtherSource;
		private final String nameOfTheUnderlyingIndex;
		private final BigDecimal fixedRateOfLeg1;
		private final String identifierOfFloatingRateOfLeg1;
		private final String nameOfTheFloatingRateOfLeg1;
		private final SpreadOfLeg1 spreadOfLeg1;
		private final BigDecimal fixedRateOfLeg2;
		private final String identifierOfFloatingRateOfLeg2;
		private final String nameOfTheFloatingRateOfLeg2;
		private final SpreadOfLeg2 spreadOfLeg2;
		private final String optionType;
		private final String optionStyle;
		private final Date firstExerciseDate;
		private final Date effectiveDate;
		private final Date expirationDate;
		private final String swapLinkID;
		private final String packageIdentifier;
		private final String deliveryType;
		private final ISOCurrencyCodeEnum settlementCurrency1;
		private final ISOCurrencyCodeEnum settlementCurrency2;
		private final Date finalContractualSettlementDate;
		private final String cleared;
		private final String centralCounterparty;
		private final String clearingMember;
		private final ZonedDateTime clearingTimestamp;
		private final String platformIdentifier;
		private final String bookingLocation;
		private final String traderLocation;
		private final String confirmed;
		private final ZonedDateTime confirmationTimestamp;
		private final ZonedDateTime executionTimestamp;
		private final ZonedDateTime reportingTimestamp;
		private final List<? extends BasketConstituentsReport> basketConstituents;
		private final BigDecimal valuationAmount;
		private final ISOCurrencyCodeEnum valuationCurrency;
		private final ValuationType1Code valuationMethod;
		private final ZonedDateTime valuationTimestamp;
		private final Boolean collateralPortfolioIndicator;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		private final BigDecimal notionalAmountOfTheContractOrLeg1;
		private final ISOCurrencyCodeEnum notionalCurrencyOfTheContractOrLeg1;
		private final BigDecimal notionalAmountOfLeg2;
		private final ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
		private final BigDecimal totalNotionalQuantityOfTheContractOrLeg1;
		private final String quantityUnitOfMeasureForTheContractOrLeg1;
		private final BigDecimal notionalQuantityOfTheContractOrLeg1;
		private final String quantityFrequencyOfTheContractOrLeg1;
		private final Integer quantityFrequencyMultiplierOfTheContractOrLeg1;
		private final BigDecimal totalNotionalQuantityLeg2;
		private final String quantityUnitOfMeasureLeg2;
		private final BigDecimal notionalQuantityOfLeg2;
		private final String quantityFrequencyOfLeg2;
		private final Integer quantityFrequencyMultiplierOfLeg2;
		private final BigDecimal callAmount;
		private final ISOCurrencyCodeEnum callCurrency;
		private final BigDecimal putAmount;
		private final ISOCurrencyCodeEnum putCurrency;
		private final PriceAndNotation price;
		private final String priceUnitOfMeasure;
		private final List<? extends PriceScheduleReport> priceSchedule;
		private final StrikePriceAndNotation strikePrice;
		private final List<? extends StrikePriceScheduleReport> strikePriceSchedule;
		private final BigDecimal optionPremiumAmount;
		private final ISOCurrencyCodeEnum optionPremiumCurrency;
		private final BigDecimal exchangeRate;
		private final String exchangeRateBasis;
		private final InterestComputationMethod4Code fixedRateDayCountConventionOfLeg1;
		private final InterestComputationMethod4Code fixedRateDayCountConventionOfLeg2;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		private final InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		private final String floatingRateResetFrequencyPeriodOfLeg1;
		private final Integer floatingRateResetFrequencyPeriodMultiplierOfLeg1;
		private final String floatingRateResetFrequencyPeriodOfLeg2;
		private final Integer floatingRateResetFrequencyPeriodMultiplierOfLeg2;
		private final Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg1;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
		private final Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg2;
		private final Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
		private final Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		private final Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg2;
		private final Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		private final List<? extends OtherPaymentReport> otherPayment;
		private final String actionType;
		private final String eventType;
		private final ZonedDateTime eventDate;
		private final MASNonReportable nonReportable;
		private final String technicalRecordId;
		private final String counterparty2Name;
		private final String executionAgentOfCounterparty1;
		private final String executionAgentOfCounterparty2DTCC;
		private final List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCC;
		private final List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCC;
		private final List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCC;
		private final List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCC;
		
		protected MASTransactionReportImpl(MASTransactionReport.MASTransactionReportBuilder builder) {
			this.counterparty1 = builder.getCounterparty1();
			this.counterparty2 = builder.getCounterparty2();
			this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
			this.tradingCapacityOfSpecifiedPerson = builder.getTradingCapacityOfSpecifiedPerson();
			this.direction = builder.getDirection();
			this.directionOfLeg1 = builder.getDirectionOfLeg1();
			this.directionOfLeg2 = builder.getDirectionOfLeg2();
			this.reportingSpecifiedPerson = builder.getReportingSpecifiedPerson();
			this.dataSubmitter = builder.getDataSubmitter();
			this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
			this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
			this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
			this.priorUTI = builder.getPriorUTI();
			this.priorUTIProprietary = builder.getPriorUTIProprietary();
			this.contractType = builder.getContractType();
			this.assetClass = builder.getAssetClass();
			this.underlying = builder.getUnderlying();
			this.underlyingIdentificationType = builder.getUnderlyingIdentificationType();
			this.underlyingIdOther = builder.getUnderlyingIdOther();
			this.underlyingIdOtherSource = builder.getUnderlyingIdOtherSource();
			this.nameOfTheUnderlyingIndex = builder.getNameOfTheUnderlyingIndex();
			this.fixedRateOfLeg1 = builder.getFixedRateOfLeg1();
			this.identifierOfFloatingRateOfLeg1 = builder.getIdentifierOfFloatingRateOfLeg1();
			this.nameOfTheFloatingRateOfLeg1 = builder.getNameOfTheFloatingRateOfLeg1();
			this.spreadOfLeg1 = ofNullable(builder.getSpreadOfLeg1()).map(f->f.build()).orElse(null);
			this.fixedRateOfLeg2 = builder.getFixedRateOfLeg2();
			this.identifierOfFloatingRateOfLeg2 = builder.getIdentifierOfFloatingRateOfLeg2();
			this.nameOfTheFloatingRateOfLeg2 = builder.getNameOfTheFloatingRateOfLeg2();
			this.spreadOfLeg2 = ofNullable(builder.getSpreadOfLeg2()).map(f->f.build()).orElse(null);
			this.optionType = builder.getOptionType();
			this.optionStyle = builder.getOptionStyle();
			this.firstExerciseDate = builder.getFirstExerciseDate();
			this.effectiveDate = builder.getEffectiveDate();
			this.expirationDate = builder.getExpirationDate();
			this.swapLinkID = builder.getSwapLinkID();
			this.packageIdentifier = builder.getPackageIdentifier();
			this.deliveryType = builder.getDeliveryType();
			this.settlementCurrency1 = builder.getSettlementCurrency1();
			this.settlementCurrency2 = builder.getSettlementCurrency2();
			this.finalContractualSettlementDate = builder.getFinalContractualSettlementDate();
			this.cleared = builder.getCleared();
			this.centralCounterparty = builder.getCentralCounterparty();
			this.clearingMember = builder.getClearingMember();
			this.clearingTimestamp = builder.getClearingTimestamp();
			this.platformIdentifier = builder.getPlatformIdentifier();
			this.bookingLocation = builder.getBookingLocation();
			this.traderLocation = builder.getTraderLocation();
			this.confirmed = builder.getConfirmed();
			this.confirmationTimestamp = builder.getConfirmationTimestamp();
			this.executionTimestamp = builder.getExecutionTimestamp();
			this.reportingTimestamp = builder.getReportingTimestamp();
			this.basketConstituents = ofNullable(builder.getBasketConstituents()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.valuationAmount = builder.getValuationAmount();
			this.valuationCurrency = builder.getValuationCurrency();
			this.valuationMethod = builder.getValuationMethod();
			this.valuationTimestamp = builder.getValuationTimestamp();
			this.collateralPortfolioIndicator = builder.getCollateralPortfolioIndicator();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
			this.notionalAmountOfTheContractOrLeg1 = builder.getNotionalAmountOfTheContractOrLeg1();
			this.notionalCurrencyOfTheContractOrLeg1 = builder.getNotionalCurrencyOfTheContractOrLeg1();
			this.notionalAmountOfLeg2 = builder.getNotionalAmountOfLeg2();
			this.notionalCurrencyOfLeg2 = builder.getNotionalCurrencyOfLeg2();
			this.totalNotionalQuantityOfTheContractOrLeg1 = builder.getTotalNotionalQuantityOfTheContractOrLeg1();
			this.quantityUnitOfMeasureForTheContractOrLeg1 = builder.getQuantityUnitOfMeasureForTheContractOrLeg1();
			this.notionalQuantityOfTheContractOrLeg1 = builder.getNotionalQuantityOfTheContractOrLeg1();
			this.quantityFrequencyOfTheContractOrLeg1 = builder.getQuantityFrequencyOfTheContractOrLeg1();
			this.quantityFrequencyMultiplierOfTheContractOrLeg1 = builder.getQuantityFrequencyMultiplierOfTheContractOrLeg1();
			this.totalNotionalQuantityLeg2 = builder.getTotalNotionalQuantityLeg2();
			this.quantityUnitOfMeasureLeg2 = builder.getQuantityUnitOfMeasureLeg2();
			this.notionalQuantityOfLeg2 = builder.getNotionalQuantityOfLeg2();
			this.quantityFrequencyOfLeg2 = builder.getQuantityFrequencyOfLeg2();
			this.quantityFrequencyMultiplierOfLeg2 = builder.getQuantityFrequencyMultiplierOfLeg2();
			this.callAmount = builder.getCallAmount();
			this.callCurrency = builder.getCallCurrency();
			this.putAmount = builder.getPutAmount();
			this.putCurrency = builder.getPutCurrency();
			this.price = ofNullable(builder.getPrice()).map(f->f.build()).orElse(null);
			this.priceUnitOfMeasure = builder.getPriceUnitOfMeasure();
			this.priceSchedule = ofNullable(builder.getPriceSchedule()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.strikePrice = ofNullable(builder.getStrikePrice()).map(f->f.build()).orElse(null);
			this.strikePriceSchedule = ofNullable(builder.getStrikePriceSchedule()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.optionPremiumAmount = builder.getOptionPremiumAmount();
			this.optionPremiumCurrency = builder.getOptionPremiumCurrency();
			this.exchangeRate = builder.getExchangeRate();
			this.exchangeRateBasis = builder.getExchangeRateBasis();
			this.fixedRateDayCountConventionOfLeg1 = builder.getFixedRateDayCountConventionOfLeg1();
			this.fixedRateDayCountConventionOfLeg2 = builder.getFixedRateDayCountConventionOfLeg2();
			this.floatingRateDayCountConventionOfLeg1 = builder.getFloatingRateDayCountConventionOfLeg1();
			this.floatingRateDayCountConventionOfLeg2 = builder.getFloatingRateDayCountConventionOfLeg2();
			this.floatingRateResetFrequencyPeriodOfLeg1 = builder.getFloatingRateResetFrequencyPeriodOfLeg1();
			this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 = builder.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1();
			this.floatingRateResetFrequencyPeriodOfLeg2 = builder.getFloatingRateResetFrequencyPeriodOfLeg2();
			this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 = builder.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2();
			this.fixedRatePaymentFrequencyPeriodOfLeg1 = builder.getFixedRatePaymentFrequencyPeriodOfLeg1();
			this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 = builder.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1();
			this.fixedRatePaymentFrequencyPeriodOfLeg2 = builder.getFixedRatePaymentFrequencyPeriodOfLeg2();
			this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 = builder.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2();
			this.floatingRatePaymentFrequencyPeriodOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg1();
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1();
			this.floatingRatePaymentFrequencyPeriodOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodOfLeg2();
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = builder.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2();
			this.otherPayment = ofNullable(builder.getOtherPayment()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.actionType = builder.getActionType();
			this.eventType = builder.getEventType();
			this.eventDate = builder.getEventDate();
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
			this.technicalRecordId = builder.getTechnicalRecordId();
			this.counterparty2Name = builder.getCounterparty2Name();
			this.executionAgentOfCounterparty1 = builder.getExecutionAgentOfCounterparty1();
			this.executionAgentOfCounterparty2DTCC = builder.getExecutionAgentOfCounterparty2DTCC();
			this.notionalAmountScheduleLeg1DTCC = ofNullable(builder.getNotionalAmountScheduleLeg1DTCC()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalAmountScheduleLeg2DTCC = ofNullable(builder.getNotionalAmountScheduleLeg2DTCC()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalQuantityScheduleLeg1DTCC = ofNullable(builder.getNotionalQuantityScheduleLeg1DTCC()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
			this.notionalQuantityScheduleLeg2DTCC = ofNullable(builder.getNotionalQuantityScheduleLeg2DTCC()).filter(_l->!_l.isEmpty()).map(list -> list.stream().filter(Objects::nonNull).map(f->f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("tradingCapacityOfSpecifiedPerson")
		@RuneAttribute("tradingCapacityOfSpecifiedPerson")
		public TradingCapacity7Code getTradingCapacityOfSpecifiedPerson() {
			return tradingCapacityOfSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		public String getDirectionOfLeg1() {
			return directionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		public String getDirectionOfLeg2() {
			return directionOfLeg2;
		}
		
		@Override
		@RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
		public String getReportingSpecifiedPerson() {
			return reportingSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		public String getDataSubmitter() {
			return dataSubmitter;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public String getPriorUTIProprietary() {
			return priorUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public String getUnderlying() {
			return underlying;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public String getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public String getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		public BigDecimal getFixedRateOfLeg1() {
			return fixedRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		public String getIdentifierOfFloatingRateOfLeg1() {
			return identifierOfFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		public SpreadOfLeg1 getSpreadOfLeg1() {
			return spreadOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		public BigDecimal getFixedRateOfLeg2() {
			return fixedRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		public String getIdentifierOfFloatingRateOfLeg2() {
			return identifierOfFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		public SpreadOfLeg2 getSpreadOfLeg2() {
			return spreadOfLeg2;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public Date getFirstExerciseDate() {
			return firstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("swapLinkID")
		@RuneAttribute("swapLinkID")
		public String getSwapLinkID() {
			return swapLinkID;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public ISOCurrencyCodeEnum getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		public ISOCurrencyCodeEnum getSettlementCurrency2() {
			return settlementCurrency2;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public String getBookingLocation() {
			return bookingLocation;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public String getTraderLocation() {
			return traderLocation;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public List<? extends BasketConstituentsReport> getBasketConstituents() {
			return basketConstituents;
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("notionalAmountOfTheContractOrLeg1")
		@RuneAttribute("notionalAmountOfTheContractOrLeg1")
		public BigDecimal getNotionalAmountOfTheContractOrLeg1() {
			return notionalAmountOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfTheContractOrLeg1")
		@RuneAttribute("notionalCurrencyOfTheContractOrLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfTheContractOrLeg1() {
			return notionalCurrencyOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountOfLeg2")
		@RuneAttribute("notionalAmountOfLeg2")
		public BigDecimal getNotionalAmountOfLeg2() {
			return notionalAmountOfLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfLeg2")
		@RuneAttribute("notionalCurrencyOfLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
			return notionalCurrencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityOfTheContractOrLeg1")
		@RuneAttribute("totalNotionalQuantityOfTheContractOrLeg1")
		public BigDecimal getTotalNotionalQuantityOfTheContractOrLeg1() {
			return totalNotionalQuantityOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureForTheContractOrLeg1")
		@RuneAttribute("quantityUnitOfMeasureForTheContractOrLeg1")
		public String getQuantityUnitOfMeasureForTheContractOrLeg1() {
			return quantityUnitOfMeasureForTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityOfTheContractOrLeg1")
		@RuneAttribute("notionalQuantityOfTheContractOrLeg1")
		public BigDecimal getNotionalQuantityOfTheContractOrLeg1() {
			return notionalQuantityOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyOfTheContractOrLeg1")
		@RuneAttribute("quantityFrequencyOfTheContractOrLeg1")
		public String getQuantityFrequencyOfTheContractOrLeg1() {
			return quantityFrequencyOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierOfTheContractOrLeg1")
		@RuneAttribute("quantityFrequencyMultiplierOfTheContractOrLeg1")
		public Integer getQuantityFrequencyMultiplierOfTheContractOrLeg1() {
			return quantityFrequencyMultiplierOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityOfLeg2")
		@RuneAttribute("notionalQuantityOfLeg2")
		public BigDecimal getNotionalQuantityOfLeg2() {
			return notionalQuantityOfLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyOfLeg2")
		@RuneAttribute("quantityFrequencyOfLeg2")
		public String getQuantityFrequencyOfLeg2() {
			return quantityFrequencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierOfLeg2")
		@RuneAttribute("quantityFrequencyMultiplierOfLeg2")
		public Integer getQuantityFrequencyMultiplierOfLeg2() {
			return quantityFrequencyMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation getPrice() {
			return price;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public List<? extends PriceScheduleReport> getPriceSchedule() {
			return priceSchedule;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public List<? extends StrikePriceScheduleReport> getStrikePriceSchedule() {
			return strikePriceSchedule;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionOfLeg1")
		@RuneAttribute("fixedRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg1() {
			return fixedRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionOfLeg2")
		@RuneAttribute("fixedRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg2() {
			return fixedRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		public String getFloatingRateResetFrequencyPeriodOfLeg1() {
			return floatingRateResetFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg1() {
			return fixedRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodOfLeg2")
		public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg2() {
			return fixedRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
			return floatingRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg2() {
			return floatingRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public ZonedDateTime getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public MASNonReportable getNonReportable() {
			return nonReportable;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty1")
		@RuneAttribute("executionAgentOfCounterparty1")
		public String getExecutionAgentOfCounterparty1() {
			return executionAgentOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty2DTCC")
		@RuneAttribute("executionAgentOfCounterparty2DTCC")
		public String getExecutionAgentOfCounterparty2DTCC() {
			return executionAgentOfCounterparty2DTCC;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1DTCC")
		@RuneAttribute("notionalAmountScheduleLeg1DTCC")
		public List<? extends NotionalAmountScheduleLeg1Report> getNotionalAmountScheduleLeg1DTCC() {
			return notionalAmountScheduleLeg1DTCC;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2DTCC")
		@RuneAttribute("notionalAmountScheduleLeg2DTCC")
		public List<? extends NotionalAmountScheduleLeg2Report> getNotionalAmountScheduleLeg2DTCC() {
			return notionalAmountScheduleLeg2DTCC;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1DTCC")
		@RuneAttribute("notionalQuantityScheduleLeg1DTCC")
		public List<? extends NotionalQuantityScheduleLeg1Report> getNotionalQuantityScheduleLeg1DTCC() {
			return notionalQuantityScheduleLeg1DTCC;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2DTCC")
		@RuneAttribute("notionalQuantityScheduleLeg2DTCC")
		public List<? extends NotionalQuantityScheduleLeg2Report> getNotionalQuantityScheduleLeg2DTCC() {
			return notionalQuantityScheduleLeg2DTCC;
		}
		
		@Override
		public MASTransactionReport build() {
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder toBuilder() {
			MASTransactionReport.MASTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(MASTransactionReport.MASTransactionReportBuilder builder) {
			ofNullable(getCounterparty1()).ifPresent(builder::setCounterparty1);
			ofNullable(getCounterparty2()).ifPresent(builder::setCounterparty2);
			ofNullable(getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierType);
			ofNullable(getTradingCapacityOfSpecifiedPerson()).ifPresent(builder::setTradingCapacityOfSpecifiedPerson);
			ofNullable(getDirection()).ifPresent(builder::setDirection);
			ofNullable(getDirectionOfLeg1()).ifPresent(builder::setDirectionOfLeg1);
			ofNullable(getDirectionOfLeg2()).ifPresent(builder::setDirectionOfLeg2);
			ofNullable(getReportingSpecifiedPerson()).ifPresent(builder::setReportingSpecifiedPerson);
			ofNullable(getDataSubmitter()).ifPresent(builder::setDataSubmitter);
			ofNullable(getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
			ofNullable(getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
			ofNullable(getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
			ofNullable(getPriorUTI()).ifPresent(builder::setPriorUTI);
			ofNullable(getPriorUTIProprietary()).ifPresent(builder::setPriorUTIProprietary);
			ofNullable(getContractType()).ifPresent(builder::setContractType);
			ofNullable(getAssetClass()).ifPresent(builder::setAssetClass);
			ofNullable(getUnderlying()).ifPresent(builder::setUnderlying);
			ofNullable(getUnderlyingIdentificationType()).ifPresent(builder::setUnderlyingIdentificationType);
			ofNullable(getUnderlyingIdOther()).ifPresent(builder::setUnderlyingIdOther);
			ofNullable(getUnderlyingIdOtherSource()).ifPresent(builder::setUnderlyingIdOtherSource);
			ofNullable(getNameOfTheUnderlyingIndex()).ifPresent(builder::setNameOfTheUnderlyingIndex);
			ofNullable(getFixedRateOfLeg1()).ifPresent(builder::setFixedRateOfLeg1);
			ofNullable(getIdentifierOfFloatingRateOfLeg1()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg1);
			ofNullable(getNameOfTheFloatingRateOfLeg1()).ifPresent(builder::setNameOfTheFloatingRateOfLeg1);
			ofNullable(getSpreadOfLeg1()).ifPresent(builder::setSpreadOfLeg1);
			ofNullable(getFixedRateOfLeg2()).ifPresent(builder::setFixedRateOfLeg2);
			ofNullable(getIdentifierOfFloatingRateOfLeg2()).ifPresent(builder::setIdentifierOfFloatingRateOfLeg2);
			ofNullable(getNameOfTheFloatingRateOfLeg2()).ifPresent(builder::setNameOfTheFloatingRateOfLeg2);
			ofNullable(getSpreadOfLeg2()).ifPresent(builder::setSpreadOfLeg2);
			ofNullable(getOptionType()).ifPresent(builder::setOptionType);
			ofNullable(getOptionStyle()).ifPresent(builder::setOptionStyle);
			ofNullable(getFirstExerciseDate()).ifPresent(builder::setFirstExerciseDate);
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getExpirationDate()).ifPresent(builder::setExpirationDate);
			ofNullable(getSwapLinkID()).ifPresent(builder::setSwapLinkID);
			ofNullable(getPackageIdentifier()).ifPresent(builder::setPackageIdentifier);
			ofNullable(getDeliveryType()).ifPresent(builder::setDeliveryType);
			ofNullable(getSettlementCurrency1()).ifPresent(builder::setSettlementCurrency1);
			ofNullable(getSettlementCurrency2()).ifPresent(builder::setSettlementCurrency2);
			ofNullable(getFinalContractualSettlementDate()).ifPresent(builder::setFinalContractualSettlementDate);
			ofNullable(getCleared()).ifPresent(builder::setCleared);
			ofNullable(getCentralCounterparty()).ifPresent(builder::setCentralCounterparty);
			ofNullable(getClearingMember()).ifPresent(builder::setClearingMember);
			ofNullable(getClearingTimestamp()).ifPresent(builder::setClearingTimestamp);
			ofNullable(getPlatformIdentifier()).ifPresent(builder::setPlatformIdentifier);
			ofNullable(getBookingLocation()).ifPresent(builder::setBookingLocation);
			ofNullable(getTraderLocation()).ifPresent(builder::setTraderLocation);
			ofNullable(getConfirmed()).ifPresent(builder::setConfirmed);
			ofNullable(getConfirmationTimestamp()).ifPresent(builder::setConfirmationTimestamp);
			ofNullable(getExecutionTimestamp()).ifPresent(builder::setExecutionTimestamp);
			ofNullable(getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
			ofNullable(getBasketConstituents()).ifPresent(builder::setBasketConstituents);
			ofNullable(getValuationAmount()).ifPresent(builder::setValuationAmount);
			ofNullable(getValuationCurrency()).ifPresent(builder::setValuationCurrency);
			ofNullable(getValuationMethod()).ifPresent(builder::setValuationMethod);
			ofNullable(getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
			ofNullable(getCollateralPortfolioIndicator()).ifPresent(builder::setCollateralPortfolioIndicator);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
			ofNullable(getNotionalAmountOfTheContractOrLeg1()).ifPresent(builder::setNotionalAmountOfTheContractOrLeg1);
			ofNullable(getNotionalCurrencyOfTheContractOrLeg1()).ifPresent(builder::setNotionalCurrencyOfTheContractOrLeg1);
			ofNullable(getNotionalAmountOfLeg2()).ifPresent(builder::setNotionalAmountOfLeg2);
			ofNullable(getNotionalCurrencyOfLeg2()).ifPresent(builder::setNotionalCurrencyOfLeg2);
			ofNullable(getTotalNotionalQuantityOfTheContractOrLeg1()).ifPresent(builder::setTotalNotionalQuantityOfTheContractOrLeg1);
			ofNullable(getQuantityUnitOfMeasureForTheContractOrLeg1()).ifPresent(builder::setQuantityUnitOfMeasureForTheContractOrLeg1);
			ofNullable(getNotionalQuantityOfTheContractOrLeg1()).ifPresent(builder::setNotionalQuantityOfTheContractOrLeg1);
			ofNullable(getQuantityFrequencyOfTheContractOrLeg1()).ifPresent(builder::setQuantityFrequencyOfTheContractOrLeg1);
			ofNullable(getQuantityFrequencyMultiplierOfTheContractOrLeg1()).ifPresent(builder::setQuantityFrequencyMultiplierOfTheContractOrLeg1);
			ofNullable(getTotalNotionalQuantityLeg2()).ifPresent(builder::setTotalNotionalQuantityLeg2);
			ofNullable(getQuantityUnitOfMeasureLeg2()).ifPresent(builder::setQuantityUnitOfMeasureLeg2);
			ofNullable(getNotionalQuantityOfLeg2()).ifPresent(builder::setNotionalQuantityOfLeg2);
			ofNullable(getQuantityFrequencyOfLeg2()).ifPresent(builder::setQuantityFrequencyOfLeg2);
			ofNullable(getQuantityFrequencyMultiplierOfLeg2()).ifPresent(builder::setQuantityFrequencyMultiplierOfLeg2);
			ofNullable(getCallAmount()).ifPresent(builder::setCallAmount);
			ofNullable(getCallCurrency()).ifPresent(builder::setCallCurrency);
			ofNullable(getPutAmount()).ifPresent(builder::setPutAmount);
			ofNullable(getPutCurrency()).ifPresent(builder::setPutCurrency);
			ofNullable(getPrice()).ifPresent(builder::setPrice);
			ofNullable(getPriceUnitOfMeasure()).ifPresent(builder::setPriceUnitOfMeasure);
			ofNullable(getPriceSchedule()).ifPresent(builder::setPriceSchedule);
			ofNullable(getStrikePrice()).ifPresent(builder::setStrikePrice);
			ofNullable(getStrikePriceSchedule()).ifPresent(builder::setStrikePriceSchedule);
			ofNullable(getOptionPremiumAmount()).ifPresent(builder::setOptionPremiumAmount);
			ofNullable(getOptionPremiumCurrency()).ifPresent(builder::setOptionPremiumCurrency);
			ofNullable(getExchangeRate()).ifPresent(builder::setExchangeRate);
			ofNullable(getExchangeRateBasis()).ifPresent(builder::setExchangeRateBasis);
			ofNullable(getFixedRateDayCountConventionOfLeg1()).ifPresent(builder::setFixedRateDayCountConventionOfLeg1);
			ofNullable(getFixedRateDayCountConventionOfLeg2()).ifPresent(builder::setFixedRateDayCountConventionOfLeg2);
			ofNullable(getFloatingRateDayCountConventionOfLeg1()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg1);
			ofNullable(getFloatingRateDayCountConventionOfLeg2()).ifPresent(builder::setFloatingRateDayCountConventionOfLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierOfLeg1);
			ofNullable(getFloatingRateResetFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodOfLeg2);
			ofNullable(getFloatingRateResetFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFloatingRateResetFrequencyPeriodMultiplierOfLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodOfLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodOfLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1);
			ofNullable(getFixedRatePaymentFrequencyPeriodOfLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodOfLeg2);
			ofNullable(getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
			ofNullable(getFloatingRatePaymentFrequencyPeriodOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodOfLeg2);
			ofNullable(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()).ifPresent(builder::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
			ofNullable(getOtherPayment()).ifPresent(builder::setOtherPayment);
			ofNullable(getActionType()).ifPresent(builder::setActionType);
			ofNullable(getEventType()).ifPresent(builder::setEventType);
			ofNullable(getEventDate()).ifPresent(builder::setEventDate);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
			ofNullable(getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
			ofNullable(getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
			ofNullable(getExecutionAgentOfCounterparty1()).ifPresent(builder::setExecutionAgentOfCounterparty1);
			ofNullable(getExecutionAgentOfCounterparty2DTCC()).ifPresent(builder::setExecutionAgentOfCounterparty2DTCC);
			ofNullable(getNotionalAmountScheduleLeg1DTCC()).ifPresent(builder::setNotionalAmountScheduleLeg1DTCC);
			ofNullable(getNotionalAmountScheduleLeg2DTCC()).ifPresent(builder::setNotionalAmountScheduleLeg2DTCC);
			ofNullable(getNotionalQuantityScheduleLeg1DTCC()).ifPresent(builder::setNotionalQuantityScheduleLeg1DTCC);
			ofNullable(getNotionalQuantityScheduleLeg2DTCC()).ifPresent(builder::setNotionalQuantityScheduleLeg2DTCC);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(tradingCapacityOfSpecifiedPerson, _that.getTradingCapacityOfSpecifiedPerson())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(directionOfLeg1, _that.getDirectionOfLeg1())) return false;
			if (!Objects.equals(directionOfLeg2, _that.getDirectionOfLeg2())) return false;
			if (!Objects.equals(reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) return false;
			if (!Objects.equals(dataSubmitter, _that.getDataSubmitter())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(priorUTIProprietary, _that.getPriorUTIProprietary())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(underlying, _that.getUnderlying())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			if (!Objects.equals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!Objects.equals(fixedRateOfLeg1, _that.getFixedRateOfLeg1())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(spreadOfLeg1, _that.getSpreadOfLeg1())) return false;
			if (!Objects.equals(fixedRateOfLeg2, _that.getFixedRateOfLeg2())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(spreadOfLeg2, _that.getSpreadOfLeg2())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(firstExerciseDate, _that.getFirstExerciseDate())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(swapLinkID, _that.getSwapLinkID())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(settlementCurrency1, _that.getSettlementCurrency1())) return false;
			if (!Objects.equals(settlementCurrency2, _that.getSettlementCurrency2())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(bookingLocation, _that.getBookingLocation())) return false;
			if (!Objects.equals(traderLocation, _that.getTraderLocation())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!ListEquals.listEquals(basketConstituents, _that.getBasketConstituents())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(notionalAmountOfTheContractOrLeg1, _that.getNotionalAmountOfTheContractOrLeg1())) return false;
			if (!Objects.equals(notionalCurrencyOfTheContractOrLeg1, _that.getNotionalCurrencyOfTheContractOrLeg1())) return false;
			if (!Objects.equals(notionalAmountOfLeg2, _that.getNotionalAmountOfLeg2())) return false;
			if (!Objects.equals(notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityOfTheContractOrLeg1, _that.getTotalNotionalQuantityOfTheContractOrLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureForTheContractOrLeg1, _that.getQuantityUnitOfMeasureForTheContractOrLeg1())) return false;
			if (!Objects.equals(notionalQuantityOfTheContractOrLeg1, _that.getNotionalQuantityOfTheContractOrLeg1())) return false;
			if (!Objects.equals(quantityFrequencyOfTheContractOrLeg1, _that.getQuantityFrequencyOfTheContractOrLeg1())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierOfTheContractOrLeg1, _that.getQuantityFrequencyMultiplierOfTheContractOrLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!Objects.equals(notionalQuantityOfLeg2, _that.getNotionalQuantityOfLeg2())) return false;
			if (!Objects.equals(quantityFrequencyOfLeg2, _that.getQuantityFrequencyOfLeg2())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierOfLeg2, _that.getQuantityFrequencyMultiplierOfLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!ListEquals.listEquals(priceSchedule, _that.getPriceSchedule())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!ListEquals.listEquals(strikePriceSchedule, _that.getStrikePriceSchedule())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(fixedRateDayCountConventionOfLeg1, _that.getFixedRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionOfLeg2, _that.getFixedRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodOfLeg1, _that.getFixedRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodOfLeg2, _that.getFixedRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) return false;
			if (!Objects.equals(executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1DTCC, _that.getNotionalAmountScheduleLeg1DTCC())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2DTCC, _that.getNotionalAmountScheduleLeg2DTCC())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1DTCC, _that.getNotionalQuantityScheduleLeg1DTCC())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2DTCC, _that.getNotionalQuantityScheduleLeg2DTCC())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (tradingCapacityOfSpecifiedPerson != null ? tradingCapacityOfSpecifiedPerson.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg1 != null ? directionOfLeg1.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg2 != null ? directionOfLeg2.hashCode() : 0);
			_result = 31 * _result + (reportingSpecifiedPerson != null ? reportingSpecifiedPerson.hashCode() : 0);
			_result = 31 * _result + (dataSubmitter != null ? dataSubmitter.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (priorUTIProprietary != null ? priorUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (underlying != null ? underlying.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg1 != null ? fixedRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg1 != null ? identifierOfFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1 != null ? spreadOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg2 != null ? fixedRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg2 != null ? identifierOfFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2 != null ? spreadOfLeg2.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (firstExerciseDate != null ? firstExerciseDate.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (swapLinkID != null ? swapLinkID.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency1 != null ? settlementCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrency2 != null ? settlementCurrency2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (bookingLocation != null ? bookingLocation.hashCode() : 0);
			_result = 31 * _result + (traderLocation != null ? traderLocation.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (basketConstituents != null ? basketConstituents.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (notionalAmountOfTheContractOrLeg1 != null ? notionalAmountOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfTheContractOrLeg1 != null ? notionalCurrencyOfTheContractOrLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountOfLeg2 != null ? notionalAmountOfLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfLeg2 != null ? notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityOfTheContractOrLeg1 != null ? totalNotionalQuantityOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureForTheContractOrLeg1 != null ? quantityUnitOfMeasureForTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityOfTheContractOrLeg1 != null ? notionalQuantityOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyOfTheContractOrLeg1 != null ? quantityFrequencyOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierOfTheContractOrLeg1 != null ? quantityFrequencyMultiplierOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityOfLeg2 != null ? notionalQuantityOfLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyOfLeg2 != null ? quantityFrequencyOfLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierOfLeg2 != null ? quantityFrequencyMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (priceSchedule != null ? priceSchedule.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceSchedule != null ? strikePriceSchedule.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionOfLeg1 != null ? fixedRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionOfLeg2 != null ? fixedRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg1 != null ? floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierOfLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierOfLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodOfLeg1 != null ? fixedRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodOfLeg2 != null ? fixedRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg1 != null ? floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg2 != null ? floatingRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty1 != null ? executionAgentOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty2DTCC != null ? executionAgentOfCounterparty2DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1DTCC != null ? notionalAmountScheduleLeg1DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2DTCC != null ? notionalAmountScheduleLeg2DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1DTCC != null ? notionalQuantityScheduleLeg1DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2DTCC != null ? notionalQuantityScheduleLeg2DTCC.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASTransactionReport {" +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"tradingCapacityOfSpecifiedPerson=" + this.tradingCapacityOfSpecifiedPerson + ", " +
				"direction=" + this.direction + ", " +
				"directionOfLeg1=" + this.directionOfLeg1 + ", " +
				"directionOfLeg2=" + this.directionOfLeg2 + ", " +
				"reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", " +
				"dataSubmitter=" + this.dataSubmitter + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"priorUTIProprietary=" + this.priorUTIProprietary + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"underlying=" + this.underlying + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"fixedRateOfLeg1=" + this.fixedRateOfLeg1 + ", " +
				"identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"spreadOfLeg1=" + this.spreadOfLeg1 + ", " +
				"fixedRateOfLeg2=" + this.fixedRateOfLeg2 + ", " +
				"identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"spreadOfLeg2=" + this.spreadOfLeg2 + ", " +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"firstExerciseDate=" + this.firstExerciseDate + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"swapLinkID=" + this.swapLinkID + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"settlementCurrency1=" + this.settlementCurrency1 + ", " +
				"settlementCurrency2=" + this.settlementCurrency2 + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"bookingLocation=" + this.bookingLocation + ", " +
				"traderLocation=" + this.traderLocation + ", " +
				"confirmed=" + this.confirmed + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"basketConstituents=" + this.basketConstituents + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"notionalAmountOfTheContractOrLeg1=" + this.notionalAmountOfTheContractOrLeg1 + ", " +
				"notionalCurrencyOfTheContractOrLeg1=" + this.notionalCurrencyOfTheContractOrLeg1 + ", " +
				"notionalAmountOfLeg2=" + this.notionalAmountOfLeg2 + ", " +
				"notionalCurrencyOfLeg2=" + this.notionalCurrencyOfLeg2 + ", " +
				"totalNotionalQuantityOfTheContractOrLeg1=" + this.totalNotionalQuantityOfTheContractOrLeg1 + ", " +
				"quantityUnitOfMeasureForTheContractOrLeg1=" + this.quantityUnitOfMeasureForTheContractOrLeg1 + ", " +
				"notionalQuantityOfTheContractOrLeg1=" + this.notionalQuantityOfTheContractOrLeg1 + ", " +
				"quantityFrequencyOfTheContractOrLeg1=" + this.quantityFrequencyOfTheContractOrLeg1 + ", " +
				"quantityFrequencyMultiplierOfTheContractOrLeg1=" + this.quantityFrequencyMultiplierOfTheContractOrLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"notionalQuantityOfLeg2=" + this.notionalQuantityOfLeg2 + ", " +
				"quantityFrequencyOfLeg2=" + this.quantityFrequencyOfLeg2 + ", " +
				"quantityFrequencyMultiplierOfLeg2=" + this.quantityFrequencyMultiplierOfLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putAmount=" + this.putAmount + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"price=" + this.price + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"priceSchedule=" + this.priceSchedule + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceSchedule=" + this.strikePriceSchedule + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"fixedRateDayCountConventionOfLeg1=" + this.fixedRateDayCountConventionOfLeg1 + ", " +
				"fixedRateDayCountConventionOfLeg2=" + this.fixedRateDayCountConventionOfLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierOfLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierOfLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodOfLeg1=" + this.fixedRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodOfLeg2=" + this.fixedRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg1=" + this.floatingRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg2=" + this.floatingRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"nonReportable=" + this.nonReportable + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", " +
				"executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", " +
				"notionalAmountScheduleLeg1DTCC=" + this.notionalAmountScheduleLeg1DTCC + ", " +
				"notionalAmountScheduleLeg2DTCC=" + this.notionalAmountScheduleLeg2DTCC + ", " +
				"notionalQuantityScheduleLeg1DTCC=" + this.notionalQuantityScheduleLeg1DTCC + ", " +
				"notionalQuantityScheduleLeg2DTCC=" + this.notionalQuantityScheduleLeg2DTCC +
			'}';
		}
	}

	/*********************** Builder Implementation of MASTransactionReport  ***********************/
	class MASTransactionReportBuilderImpl implements MASTransactionReport.MASTransactionReportBuilder {
	
		protected String counterparty1;
		protected String counterparty2;
		protected Boolean counterparty2IdentifierType;
		protected TradingCapacity7Code tradingCapacityOfSpecifiedPerson;
		protected String direction;
		protected String directionOfLeg1;
		protected String directionOfLeg2;
		protected String reportingSpecifiedPerson;
		protected String dataSubmitter;
		protected String uniqueTransactionIdentifier;
		protected String uniqueTransactionIdentifierProprietary;
		protected String uniqueProductIdentifier;
		protected String priorUTI;
		protected String priorUTIProprietary;
		protected String contractType;
		protected String assetClass;
		protected String underlying;
		protected String underlyingIdentificationType;
		protected String underlyingIdOther;
		protected String underlyingIdOtherSource;
		protected String nameOfTheUnderlyingIndex;
		protected BigDecimal fixedRateOfLeg1;
		protected String identifierOfFloatingRateOfLeg1;
		protected String nameOfTheFloatingRateOfLeg1;
		protected SpreadOfLeg1.SpreadOfLeg1Builder spreadOfLeg1;
		protected BigDecimal fixedRateOfLeg2;
		protected String identifierOfFloatingRateOfLeg2;
		protected String nameOfTheFloatingRateOfLeg2;
		protected SpreadOfLeg2.SpreadOfLeg2Builder spreadOfLeg2;
		protected String optionType;
		protected String optionStyle;
		protected Date firstExerciseDate;
		protected Date effectiveDate;
		protected Date expirationDate;
		protected String swapLinkID;
		protected String packageIdentifier;
		protected String deliveryType;
		protected ISOCurrencyCodeEnum settlementCurrency1;
		protected ISOCurrencyCodeEnum settlementCurrency2;
		protected Date finalContractualSettlementDate;
		protected String cleared;
		protected String centralCounterparty;
		protected String clearingMember;
		protected ZonedDateTime clearingTimestamp;
		protected String platformIdentifier;
		protected String bookingLocation;
		protected String traderLocation;
		protected String confirmed;
		protected ZonedDateTime confirmationTimestamp;
		protected ZonedDateTime executionTimestamp;
		protected ZonedDateTime reportingTimestamp;
		protected List<BasketConstituentsReport.BasketConstituentsReportBuilder> basketConstituents = new ArrayList<>();
		protected BigDecimal valuationAmount;
		protected ISOCurrencyCodeEnum valuationCurrency;
		protected ValuationType1Code valuationMethod;
		protected ZonedDateTime valuationTimestamp;
		protected Boolean collateralPortfolioIndicator;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		protected BigDecimal notionalAmountOfTheContractOrLeg1;
		protected ISOCurrencyCodeEnum notionalCurrencyOfTheContractOrLeg1;
		protected BigDecimal notionalAmountOfLeg2;
		protected ISOCurrencyCodeEnum notionalCurrencyOfLeg2;
		protected BigDecimal totalNotionalQuantityOfTheContractOrLeg1;
		protected String quantityUnitOfMeasureForTheContractOrLeg1;
		protected BigDecimal notionalQuantityOfTheContractOrLeg1;
		protected String quantityFrequencyOfTheContractOrLeg1;
		protected Integer quantityFrequencyMultiplierOfTheContractOrLeg1;
		protected BigDecimal totalNotionalQuantityLeg2;
		protected String quantityUnitOfMeasureLeg2;
		protected BigDecimal notionalQuantityOfLeg2;
		protected String quantityFrequencyOfLeg2;
		protected Integer quantityFrequencyMultiplierOfLeg2;
		protected BigDecimal callAmount;
		protected ISOCurrencyCodeEnum callCurrency;
		protected BigDecimal putAmount;
		protected ISOCurrencyCodeEnum putCurrency;
		protected PriceAndNotation.PriceAndNotationBuilder price;
		protected String priceUnitOfMeasure;
		protected List<PriceScheduleReport.PriceScheduleReportBuilder> priceSchedule = new ArrayList<>();
		protected StrikePriceAndNotation.StrikePriceAndNotationBuilder strikePrice;
		protected List<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> strikePriceSchedule = new ArrayList<>();
		protected BigDecimal optionPremiumAmount;
		protected ISOCurrencyCodeEnum optionPremiumCurrency;
		protected BigDecimal exchangeRate;
		protected String exchangeRateBasis;
		protected InterestComputationMethod4Code fixedRateDayCountConventionOfLeg1;
		protected InterestComputationMethod4Code fixedRateDayCountConventionOfLeg2;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg1;
		protected InterestComputationMethod4Code floatingRateDayCountConventionOfLeg2;
		protected String floatingRateResetFrequencyPeriodOfLeg1;
		protected Integer floatingRateResetFrequencyPeriodMultiplierOfLeg1;
		protected String floatingRateResetFrequencyPeriodOfLeg2;
		protected Integer floatingRateResetFrequencyPeriodMultiplierOfLeg2;
		protected Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg1;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
		protected Frequency13Code__1 fixedRatePaymentFrequencyPeriodOfLeg2;
		protected Integer fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
		protected Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg1;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		protected Frequency13Code__1 floatingRatePaymentFrequencyPeriodOfLeg2;
		protected Integer floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		protected List<OtherPaymentReport.OtherPaymentReportBuilder> otherPayment = new ArrayList<>();
		protected String actionType;
		protected String eventType;
		protected ZonedDateTime eventDate;
		protected MASNonReportable.MASNonReportableBuilder nonReportable;
		protected String technicalRecordId;
		protected String counterparty2Name;
		protected String executionAgentOfCounterparty1;
		protected String executionAgentOfCounterparty2DTCC;
		protected List<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> notionalAmountScheduleLeg1DTCC = new ArrayList<>();
		protected List<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> notionalAmountScheduleLeg2DTCC = new ArrayList<>();
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> notionalQuantityScheduleLeg1DTCC = new ArrayList<>();
		protected List<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> notionalQuantityScheduleLeg2DTCC = new ArrayList<>();
		
		@Override
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		public String getCounterparty1() {
			return counterparty1;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		public String getCounterparty2() {
			return counterparty2;
		}
		
		@Override
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		public Boolean getCounterparty2IdentifierType() {
			return counterparty2IdentifierType;
		}
		
		@Override
		@RosettaAttribute("tradingCapacityOfSpecifiedPerson")
		@RuneAttribute("tradingCapacityOfSpecifiedPerson")
		public TradingCapacity7Code getTradingCapacityOfSpecifiedPerson() {
			return tradingCapacityOfSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		public String getDirection() {
			return direction;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		public String getDirectionOfLeg1() {
			return directionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		public String getDirectionOfLeg2() {
			return directionOfLeg2;
		}
		
		@Override
		@RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
		public String getReportingSpecifiedPerson() {
			return reportingSpecifiedPerson;
		}
		
		@Override
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		public String getDataSubmitter() {
			return dataSubmitter;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public String getUniqueTransactionIdentifier() {
			return uniqueTransactionIdentifier;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public String getUniqueTransactionIdentifierProprietary() {
			return uniqueTransactionIdentifierProprietary;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public String getUniqueProductIdentifier() {
			return uniqueProductIdentifier;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public String getPriorUTI() {
			return priorUTI;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public String getPriorUTIProprietary() {
			return priorUTIProprietary;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public String getContractType() {
			return contractType;
		}
		
		@Override
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		public String getAssetClass() {
			return assetClass;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public String getUnderlying() {
			return underlying;
		}
		
		@Override
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		public String getUnderlyingIdentificationType() {
			return underlyingIdentificationType;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		public String getUnderlyingIdOther() {
			return underlyingIdOther;
		}
		
		@Override
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		public String getUnderlyingIdOtherSource() {
			return underlyingIdOtherSource;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public String getNameOfTheUnderlyingIndex() {
			return nameOfTheUnderlyingIndex;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		public BigDecimal getFixedRateOfLeg1() {
			return fixedRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		public String getIdentifierOfFloatingRateOfLeg1() {
			return identifierOfFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		public String getNameOfTheFloatingRateOfLeg1() {
			return nameOfTheFloatingRateOfLeg1;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		public SpreadOfLeg1.SpreadOfLeg1Builder getSpreadOfLeg1() {
			return spreadOfLeg1;
		}
		
		@Override
		public SpreadOfLeg1.SpreadOfLeg1Builder getOrCreateSpreadOfLeg1() {
			SpreadOfLeg1.SpreadOfLeg1Builder result;
			if (spreadOfLeg1!=null) {
				result = spreadOfLeg1;
			}
			else {
				result = spreadOfLeg1 = SpreadOfLeg1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		public BigDecimal getFixedRateOfLeg2() {
			return fixedRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		public String getIdentifierOfFloatingRateOfLeg2() {
			return identifierOfFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		public String getNameOfTheFloatingRateOfLeg2() {
			return nameOfTheFloatingRateOfLeg2;
		}
		
		@Override
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		public SpreadOfLeg2.SpreadOfLeg2Builder getSpreadOfLeg2() {
			return spreadOfLeg2;
		}
		
		@Override
		public SpreadOfLeg2.SpreadOfLeg2Builder getOrCreateSpreadOfLeg2() {
			SpreadOfLeg2.SpreadOfLeg2Builder result;
			if (spreadOfLeg2!=null) {
				result = spreadOfLeg2;
			}
			else {
				result = spreadOfLeg2 = SpreadOfLeg2.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public String getOptionType() {
			return optionType;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public String getOptionStyle() {
			return optionStyle;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public Date getFirstExerciseDate() {
			return firstExerciseDate;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public Date getExpirationDate() {
			return expirationDate;
		}
		
		@Override
		@RosettaAttribute("swapLinkID")
		@RuneAttribute("swapLinkID")
		public String getSwapLinkID() {
			return swapLinkID;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public String getPackageIdentifier() {
			return packageIdentifier;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public String getDeliveryType() {
			return deliveryType;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		public ISOCurrencyCodeEnum getSettlementCurrency1() {
			return settlementCurrency1;
		}
		
		@Override
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		public ISOCurrencyCodeEnum getSettlementCurrency2() {
			return settlementCurrency2;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public Date getFinalContractualSettlementDate() {
			return finalContractualSettlementDate;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public String getCleared() {
			return cleared;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public String getCentralCounterparty() {
			return centralCounterparty;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public String getClearingMember() {
			return clearingMember;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public ZonedDateTime getClearingTimestamp() {
			return clearingTimestamp;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public String getPlatformIdentifier() {
			return platformIdentifier;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public String getBookingLocation() {
			return bookingLocation;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public String getTraderLocation() {
			return traderLocation;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public String getConfirmed() {
			return confirmed;
		}
		
		@Override
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		public ZonedDateTime getConfirmationTimestamp() {
			return confirmationTimestamp;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public ZonedDateTime getExecutionTimestamp() {
			return executionTimestamp;
		}
		
		@Override
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		public ZonedDateTime getReportingTimestamp() {
			return reportingTimestamp;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public List<? extends BasketConstituentsReport.BasketConstituentsReportBuilder> getBasketConstituents() {
			return basketConstituents;
		}
		
		@Override
		public BasketConstituentsReport.BasketConstituentsReportBuilder getOrCreateBasketConstituents(int index) {
			if (basketConstituents==null) {
				this.basketConstituents = new ArrayList<>();
			}
			return getIndex(basketConstituents, index, () -> {
						BasketConstituentsReport.BasketConstituentsReportBuilder newBasketConstituents = BasketConstituentsReport.builder();
						return newBasketConstituents;
					});
		}
		
		@Override
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		public BigDecimal getValuationAmount() {
			return valuationAmount;
		}
		
		@Override
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		public ISOCurrencyCodeEnum getValuationCurrency() {
			return valuationCurrency;
		}
		
		@Override
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		public ValuationType1Code getValuationMethod() {
			return valuationMethod;
		}
		
		@Override
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		public ZonedDateTime getValuationTimestamp() {
			return valuationTimestamp;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public Boolean getCollateralPortfolioIndicator() {
			return collateralPortfolioIndicator;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("notionalAmountOfTheContractOrLeg1")
		@RuneAttribute("notionalAmountOfTheContractOrLeg1")
		public BigDecimal getNotionalAmountOfTheContractOrLeg1() {
			return notionalAmountOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfTheContractOrLeg1")
		@RuneAttribute("notionalCurrencyOfTheContractOrLeg1")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfTheContractOrLeg1() {
			return notionalCurrencyOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalAmountOfLeg2")
		@RuneAttribute("notionalAmountOfLeg2")
		public BigDecimal getNotionalAmountOfLeg2() {
			return notionalAmountOfLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalCurrencyOfLeg2")
		@RuneAttribute("notionalCurrencyOfLeg2")
		public ISOCurrencyCodeEnum getNotionalCurrencyOfLeg2() {
			return notionalCurrencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityOfTheContractOrLeg1")
		@RuneAttribute("totalNotionalQuantityOfTheContractOrLeg1")
		public BigDecimal getTotalNotionalQuantityOfTheContractOrLeg1() {
			return totalNotionalQuantityOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureForTheContractOrLeg1")
		@RuneAttribute("quantityUnitOfMeasureForTheContractOrLeg1")
		public String getQuantityUnitOfMeasureForTheContractOrLeg1() {
			return quantityUnitOfMeasureForTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityOfTheContractOrLeg1")
		@RuneAttribute("notionalQuantityOfTheContractOrLeg1")
		public BigDecimal getNotionalQuantityOfTheContractOrLeg1() {
			return notionalQuantityOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyOfTheContractOrLeg1")
		@RuneAttribute("quantityFrequencyOfTheContractOrLeg1")
		public String getQuantityFrequencyOfTheContractOrLeg1() {
			return quantityFrequencyOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierOfTheContractOrLeg1")
		@RuneAttribute("quantityFrequencyMultiplierOfTheContractOrLeg1")
		public Integer getQuantityFrequencyMultiplierOfTheContractOrLeg1() {
			return quantityFrequencyMultiplierOfTheContractOrLeg1;
		}
		
		@Override
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		public BigDecimal getTotalNotionalQuantityLeg2() {
			return totalNotionalQuantityLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public String getQuantityUnitOfMeasureLeg2() {
			return quantityUnitOfMeasureLeg2;
		}
		
		@Override
		@RosettaAttribute("notionalQuantityOfLeg2")
		@RuneAttribute("notionalQuantityOfLeg2")
		public BigDecimal getNotionalQuantityOfLeg2() {
			return notionalQuantityOfLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyOfLeg2")
		@RuneAttribute("quantityFrequencyOfLeg2")
		public String getQuantityFrequencyOfLeg2() {
			return quantityFrequencyOfLeg2;
		}
		
		@Override
		@RosettaAttribute("quantityFrequencyMultiplierOfLeg2")
		@RuneAttribute("quantityFrequencyMultiplierOfLeg2")
		public Integer getQuantityFrequencyMultiplierOfLeg2() {
			return quantityFrequencyMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public BigDecimal getCallAmount() {
			return callAmount;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public ISOCurrencyCodeEnum getCallCurrency() {
			return callCurrency;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public BigDecimal getPutAmount() {
			return putAmount;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public ISOCurrencyCodeEnum getPutCurrency() {
			return putCurrency;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public PriceAndNotation.PriceAndNotationBuilder getPrice() {
			return price;
		}
		
		@Override
		public PriceAndNotation.PriceAndNotationBuilder getOrCreatePrice() {
			PriceAndNotation.PriceAndNotationBuilder result;
			if (price!=null) {
				result = price;
			}
			else {
				result = price = PriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public String getPriceUnitOfMeasure() {
			return priceUnitOfMeasure;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public List<? extends PriceScheduleReport.PriceScheduleReportBuilder> getPriceSchedule() {
			return priceSchedule;
		}
		
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder getOrCreatePriceSchedule(int index) {
			if (priceSchedule==null) {
				this.priceSchedule = new ArrayList<>();
			}
			return getIndex(priceSchedule, index, () -> {
						PriceScheduleReport.PriceScheduleReportBuilder newPriceSchedule = PriceScheduleReport.builder();
						return newPriceSchedule;
					});
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getStrikePrice() {
			return strikePrice;
		}
		
		@Override
		public StrikePriceAndNotation.StrikePriceAndNotationBuilder getOrCreateStrikePrice() {
			StrikePriceAndNotation.StrikePriceAndNotationBuilder result;
			if (strikePrice!=null) {
				result = strikePrice;
			}
			else {
				result = strikePrice = StrikePriceAndNotation.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public List<? extends StrikePriceScheduleReport.StrikePriceScheduleReportBuilder> getStrikePriceSchedule() {
			return strikePriceSchedule;
		}
		
		@Override
		public StrikePriceScheduleReport.StrikePriceScheduleReportBuilder getOrCreateStrikePriceSchedule(int index) {
			if (strikePriceSchedule==null) {
				this.strikePriceSchedule = new ArrayList<>();
			}
			return getIndex(strikePriceSchedule, index, () -> {
						StrikePriceScheduleReport.StrikePriceScheduleReportBuilder newStrikePriceSchedule = StrikePriceScheduleReport.builder();
						return newStrikePriceSchedule;
					});
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public BigDecimal getOptionPremiumAmount() {
			return optionPremiumAmount;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public ISOCurrencyCodeEnum getOptionPremiumCurrency() {
			return optionPremiumCurrency;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public BigDecimal getExchangeRate() {
			return exchangeRate;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public String getExchangeRateBasis() {
			return exchangeRateBasis;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionOfLeg1")
		@RuneAttribute("fixedRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg1() {
			return fixedRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRateDayCountConventionOfLeg2")
		@RuneAttribute("fixedRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFixedRateDayCountConventionOfLeg2() {
			return fixedRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg1() {
			return floatingRateDayCountConventionOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		public InterestComputationMethod4Code getFloatingRateDayCountConventionOfLeg2() {
			return floatingRateDayCountConventionOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		public String getFloatingRateResetFrequencyPeriodOfLeg1() {
			return floatingRateResetFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg1() {
			return floatingRateResetFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		public String getFloatingRateResetFrequencyPeriodOfLeg2() {
			return floatingRateResetFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRateResetFrequencyPeriodMultiplierOfLeg2() {
			return floatingRateResetFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg1() {
			return fixedRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodOfLeg2")
		public Frequency13Code__1 getFixedRatePaymentFrequencyPeriodOfLeg2() {
			return fixedRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg1() {
			return floatingRatePaymentFrequencyPeriodOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		public Frequency13Code__1 getFloatingRatePaymentFrequencyPeriodOfLeg2() {
			return floatingRatePaymentFrequencyPeriodOfLeg2;
		}
		
		@Override
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		public Integer getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() {
			return floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public List<? extends OtherPaymentReport.OtherPaymentReportBuilder> getOtherPayment() {
			return otherPayment;
		}
		
		@Override
		public OtherPaymentReport.OtherPaymentReportBuilder getOrCreateOtherPayment(int index) {
			if (otherPayment==null) {
				this.otherPayment = new ArrayList<>();
			}
			return getIndex(otherPayment, index, () -> {
						OtherPaymentReport.OtherPaymentReportBuilder newOtherPayment = OtherPaymentReport.builder();
						return newOtherPayment;
					});
		}
		
		@Override
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		public String getActionType() {
			return actionType;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public String getEventType() {
			return eventType;
		}
		
		@Override
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		public ZonedDateTime getEventDate() {
			return eventDate;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public MASNonReportable.MASNonReportableBuilder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public MASNonReportable.MASNonReportableBuilder getOrCreateNonReportable() {
			MASNonReportable.MASNonReportableBuilder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = MASNonReportable.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		public String getTechnicalRecordId() {
			return technicalRecordId;
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public String getCounterparty2Name() {
			return counterparty2Name;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty1")
		@RuneAttribute("executionAgentOfCounterparty1")
		public String getExecutionAgentOfCounterparty1() {
			return executionAgentOfCounterparty1;
		}
		
		@Override
		@RosettaAttribute("executionAgentOfCounterparty2DTCC")
		@RuneAttribute("executionAgentOfCounterparty2DTCC")
		public String getExecutionAgentOfCounterparty2DTCC() {
			return executionAgentOfCounterparty2DTCC;
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg1DTCC")
		@RuneAttribute("notionalAmountScheduleLeg1DTCC")
		public List<? extends NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder> getNotionalAmountScheduleLeg1DTCC() {
			return notionalAmountScheduleLeg1DTCC;
		}
		
		@Override
		public NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder getOrCreateNotionalAmountScheduleLeg1DTCC(int index) {
			if (notionalAmountScheduleLeg1DTCC==null) {
				this.notionalAmountScheduleLeg1DTCC = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg1DTCC, index, () -> {
						NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder newNotionalAmountScheduleLeg1DTCC = NotionalAmountScheduleLeg1Report.builder();
						return newNotionalAmountScheduleLeg1DTCC;
					});
		}
		
		@Override
		@RosettaAttribute("notionalAmountScheduleLeg2DTCC")
		@RuneAttribute("notionalAmountScheduleLeg2DTCC")
		public List<? extends NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder> getNotionalAmountScheduleLeg2DTCC() {
			return notionalAmountScheduleLeg2DTCC;
		}
		
		@Override
		public NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder getOrCreateNotionalAmountScheduleLeg2DTCC(int index) {
			if (notionalAmountScheduleLeg2DTCC==null) {
				this.notionalAmountScheduleLeg2DTCC = new ArrayList<>();
			}
			return getIndex(notionalAmountScheduleLeg2DTCC, index, () -> {
						NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder newNotionalAmountScheduleLeg2DTCC = NotionalAmountScheduleLeg2Report.builder();
						return newNotionalAmountScheduleLeg2DTCC;
					});
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg1DTCC")
		@RuneAttribute("notionalQuantityScheduleLeg1DTCC")
		public List<? extends NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> getNotionalQuantityScheduleLeg1DTCC() {
			return notionalQuantityScheduleLeg1DTCC;
		}
		
		@Override
		public NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder getOrCreateNotionalQuantityScheduleLeg1DTCC(int index) {
			if (notionalQuantityScheduleLeg1DTCC==null) {
				this.notionalQuantityScheduleLeg1DTCC = new ArrayList<>();
			}
			return getIndex(notionalQuantityScheduleLeg1DTCC, index, () -> {
						NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder newNotionalQuantityScheduleLeg1DTCC = NotionalQuantityScheduleLeg1Report.builder();
						return newNotionalQuantityScheduleLeg1DTCC;
					});
		}
		
		@Override
		@RosettaAttribute("notionalQuantityScheduleLeg2DTCC")
		@RuneAttribute("notionalQuantityScheduleLeg2DTCC")
		public List<? extends NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder> getNotionalQuantityScheduleLeg2DTCC() {
			return notionalQuantityScheduleLeg2DTCC;
		}
		
		@Override
		public NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder getOrCreateNotionalQuantityScheduleLeg2DTCC(int index) {
			if (notionalQuantityScheduleLeg2DTCC==null) {
				this.notionalQuantityScheduleLeg2DTCC = new ArrayList<>();
			}
			return getIndex(notionalQuantityScheduleLeg2DTCC, index, () -> {
						NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder newNotionalQuantityScheduleLeg2DTCC = NotionalQuantityScheduleLeg2Report.builder();
						return newNotionalQuantityScheduleLeg2DTCC;
					});
		}
		
		@RosettaAttribute(value="counterparty1", isRequired=true)
		@RuneAttribute(value="counterparty1", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2", isRequired=true)
		@RuneAttribute(value="counterparty2", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
		@RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@RosettaAttribute("tradingCapacityOfSpecifiedPerson")
		@RuneAttribute("tradingCapacityOfSpecifiedPerson")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setTradingCapacityOfSpecifiedPerson(TradingCapacity7Code _tradingCapacityOfSpecifiedPerson) {
			this.tradingCapacityOfSpecifiedPerson = _tradingCapacityOfSpecifiedPerson == null ? null : _tradingCapacityOfSpecifiedPerson;
			return this;
		}
		
		@RosettaAttribute("direction")
		@RuneAttribute("direction")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setDirection(String _direction) {
			this.direction = _direction == null ? null : _direction;
			return this;
		}
		
		@RosettaAttribute("directionOfLeg1")
		@RuneAttribute("directionOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setDirectionOfLeg1(String _directionOfLeg1) {
			this.directionOfLeg1 = _directionOfLeg1 == null ? null : _directionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("directionOfLeg2")
		@RuneAttribute("directionOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setDirectionOfLeg2(String _directionOfLeg2) {
			this.directionOfLeg2 = _directionOfLeg2 == null ? null : _directionOfLeg2;
			return this;
		}
		
		@RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setReportingSpecifiedPerson(String _reportingSpecifiedPerson) {
			this.reportingSpecifiedPerson = _reportingSpecifiedPerson == null ? null : _reportingSpecifiedPerson;
			return this;
		}
		
		@RosettaAttribute(value="dataSubmitter", isRequired=true)
		@RuneAttribute(value="dataSubmitter", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setDataSubmitter(String _dataSubmitter) {
			this.dataSubmitter = _dataSubmitter == null ? null : _dataSubmitter;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setContractType(String _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@RosettaAttribute(value="assetClass", isRequired=true)
		@RuneAttribute(value="assetClass", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setAssetClass(String _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setUnderlying(String _underlying) {
			this.underlying = _underlying == null ? null : _underlying;
			return this;
		}
		
		@RosettaAttribute("underlyingIdentificationType")
		@RuneAttribute("underlyingIdentificationType")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setUnderlyingIdentificationType(String _underlyingIdentificationType) {
			this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
			return this;
		}
		
		@RosettaAttribute("underlyingIdOther")
		@RuneAttribute("underlyingIdOther")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
			this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
			return this;
		}
		
		@RosettaAttribute("underlyingIdOtherSource")
		@RuneAttribute("underlyingIdOtherSource")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setUnderlyingIdOtherSource(String _underlyingIdOtherSource) {
			this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
			return this;
		}
		
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@RosettaAttribute("fixedRateOfLeg1")
		@RuneAttribute("fixedRateOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRateOfLeg1(BigDecimal _fixedRateOfLeg1) {
			this.fixedRateOfLeg1 = _fixedRateOfLeg1 == null ? null : _fixedRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("identifierOfFloatingRateOfLeg1")
		@RuneAttribute("identifierOfFloatingRateOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg1(String _identifierOfFloatingRateOfLeg1) {
			this.identifierOfFloatingRateOfLeg1 = _identifierOfFloatingRateOfLeg1 == null ? null : _identifierOfFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg1")
		@RuneAttribute("nameOfTheFloatingRateOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg1(String _nameOfTheFloatingRateOfLeg1) {
			this.nameOfTheFloatingRateOfLeg1 = _nameOfTheFloatingRateOfLeg1 == null ? null : _nameOfTheFloatingRateOfLeg1;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg1")
		@RuneAttribute("spreadOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setSpreadOfLeg1(SpreadOfLeg1 _spreadOfLeg1) {
			this.spreadOfLeg1 = _spreadOfLeg1 == null ? null : _spreadOfLeg1.toBuilder();
			return this;
		}
		
		@RosettaAttribute("fixedRateOfLeg2")
		@RuneAttribute("fixedRateOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRateOfLeg2(BigDecimal _fixedRateOfLeg2) {
			this.fixedRateOfLeg2 = _fixedRateOfLeg2 == null ? null : _fixedRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("identifierOfFloatingRateOfLeg2")
		@RuneAttribute("identifierOfFloatingRateOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setIdentifierOfFloatingRateOfLeg2(String _identifierOfFloatingRateOfLeg2) {
			this.identifierOfFloatingRateOfLeg2 = _identifierOfFloatingRateOfLeg2 == null ? null : _identifierOfFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("nameOfTheFloatingRateOfLeg2")
		@RuneAttribute("nameOfTheFloatingRateOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNameOfTheFloatingRateOfLeg2(String _nameOfTheFloatingRateOfLeg2) {
			this.nameOfTheFloatingRateOfLeg2 = _nameOfTheFloatingRateOfLeg2 == null ? null : _nameOfTheFloatingRateOfLeg2;
			return this;
		}
		
		@RosettaAttribute("spreadOfLeg2")
		@RuneAttribute("spreadOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setSpreadOfLeg2(SpreadOfLeg2 _spreadOfLeg2) {
			this.spreadOfLeg2 = _spreadOfLeg2 == null ? null : _spreadOfLeg2.toBuilder();
			return this;
		}
		
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setOptionType(String _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setOptionStyle(String _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@RosettaAttribute("swapLinkID")
		@RuneAttribute("swapLinkID")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setSwapLinkID(String _swapLinkID) {
			this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
			return this;
		}
		
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setDeliveryType(String _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@RosettaAttribute("settlementCurrency1")
		@RuneAttribute("settlementCurrency1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setSettlementCurrency1(ISOCurrencyCodeEnum _settlementCurrency1) {
			this.settlementCurrency1 = _settlementCurrency1 == null ? null : _settlementCurrency1;
			return this;
		}
		
		@RosettaAttribute("settlementCurrency2")
		@RuneAttribute("settlementCurrency2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setSettlementCurrency2(ISOCurrencyCodeEnum _settlementCurrency2) {
			this.settlementCurrency2 = _settlementCurrency2 == null ? null : _settlementCurrency2;
			return this;
		}
		
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCleared(String _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setBookingLocation(String _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setTraderLocation(String _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setConfirmed(String _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@RosettaAttribute("confirmationTimestamp")
		@RuneAttribute("confirmationTimestamp")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
			this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
			return this;
		}
		
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@RosettaAttribute(value="reportingTimestamp", isRequired=true)
		@RuneAttribute(value="reportingTimestamp", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
			getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("basketConstituents")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("valuationAmount")
		@RuneAttribute("valuationAmount")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
			this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
			return this;
		}
		
		@RosettaAttribute("valuationCurrency")
		@RuneAttribute("valuationCurrency")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
			this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
			return this;
		}
		
		@RosettaAttribute("valuationMethod")
		@RuneAttribute("valuationMethod")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
			this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
			return this;
		}
		
		@RosettaAttribute("valuationTimestamp")
		@RuneAttribute("valuationTimestamp")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
			this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
			return this;
		}
		
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@RosettaAttribute("notionalAmountOfTheContractOrLeg1")
		@RuneAttribute("notionalAmountOfTheContractOrLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalAmountOfTheContractOrLeg1(BigDecimal _notionalAmountOfTheContractOrLeg1) {
			this.notionalAmountOfTheContractOrLeg1 = _notionalAmountOfTheContractOrLeg1 == null ? null : _notionalAmountOfTheContractOrLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyOfTheContractOrLeg1")
		@RuneAttribute("notionalCurrencyOfTheContractOrLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalCurrencyOfTheContractOrLeg1(ISOCurrencyCodeEnum _notionalCurrencyOfTheContractOrLeg1) {
			this.notionalCurrencyOfTheContractOrLeg1 = _notionalCurrencyOfTheContractOrLeg1 == null ? null : _notionalCurrencyOfTheContractOrLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalAmountOfLeg2")
		@RuneAttribute("notionalAmountOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalAmountOfLeg2(BigDecimal _notionalAmountOfLeg2) {
			this.notionalAmountOfLeg2 = _notionalAmountOfLeg2 == null ? null : _notionalAmountOfLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalCurrencyOfLeg2")
		@RuneAttribute("notionalCurrencyOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalCurrencyOfLeg2(ISOCurrencyCodeEnum _notionalCurrencyOfLeg2) {
			this.notionalCurrencyOfLeg2 = _notionalCurrencyOfLeg2 == null ? null : _notionalCurrencyOfLeg2;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityOfTheContractOrLeg1")
		@RuneAttribute("totalNotionalQuantityOfTheContractOrLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setTotalNotionalQuantityOfTheContractOrLeg1(BigDecimal _totalNotionalQuantityOfTheContractOrLeg1) {
			this.totalNotionalQuantityOfTheContractOrLeg1 = _totalNotionalQuantityOfTheContractOrLeg1 == null ? null : _totalNotionalQuantityOfTheContractOrLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureForTheContractOrLeg1")
		@RuneAttribute("quantityUnitOfMeasureForTheContractOrLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setQuantityUnitOfMeasureForTheContractOrLeg1(String _quantityUnitOfMeasureForTheContractOrLeg1) {
			this.quantityUnitOfMeasureForTheContractOrLeg1 = _quantityUnitOfMeasureForTheContractOrLeg1 == null ? null : _quantityUnitOfMeasureForTheContractOrLeg1;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityOfTheContractOrLeg1")
		@RuneAttribute("notionalQuantityOfTheContractOrLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityOfTheContractOrLeg1(BigDecimal _notionalQuantityOfTheContractOrLeg1) {
			this.notionalQuantityOfTheContractOrLeg1 = _notionalQuantityOfTheContractOrLeg1 == null ? null : _notionalQuantityOfTheContractOrLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyOfTheContractOrLeg1")
		@RuneAttribute("quantityFrequencyOfTheContractOrLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyOfTheContractOrLeg1(String _quantityFrequencyOfTheContractOrLeg1) {
			this.quantityFrequencyOfTheContractOrLeg1 = _quantityFrequencyOfTheContractOrLeg1 == null ? null : _quantityFrequencyOfTheContractOrLeg1;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyMultiplierOfTheContractOrLeg1")
		@RuneAttribute("quantityFrequencyMultiplierOfTheContractOrLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyMultiplierOfTheContractOrLeg1(Integer _quantityFrequencyMultiplierOfTheContractOrLeg1) {
			this.quantityFrequencyMultiplierOfTheContractOrLeg1 = _quantityFrequencyMultiplierOfTheContractOrLeg1 == null ? null : _quantityFrequencyMultiplierOfTheContractOrLeg1;
			return this;
		}
		
		@RosettaAttribute("totalNotionalQuantityLeg2")
		@RuneAttribute("totalNotionalQuantityLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setTotalNotionalQuantityLeg2(BigDecimal _totalNotionalQuantityLeg2) {
			this.totalNotionalQuantityLeg2 = _totalNotionalQuantityLeg2 == null ? null : _totalNotionalQuantityLeg2;
			return this;
		}
		
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@RosettaAttribute("notionalQuantityOfLeg2")
		@RuneAttribute("notionalQuantityOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityOfLeg2(BigDecimal _notionalQuantityOfLeg2) {
			this.notionalQuantityOfLeg2 = _notionalQuantityOfLeg2 == null ? null : _notionalQuantityOfLeg2;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyOfLeg2")
		@RuneAttribute("quantityFrequencyOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyOfLeg2(String _quantityFrequencyOfLeg2) {
			this.quantityFrequencyOfLeg2 = _quantityFrequencyOfLeg2 == null ? null : _quantityFrequencyOfLeg2;
			return this;
		}
		
		@RosettaAttribute("quantityFrequencyMultiplierOfLeg2")
		@RuneAttribute("quantityFrequencyMultiplierOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setQuantityFrequencyMultiplierOfLeg2(Integer _quantityFrequencyMultiplierOfLeg2) {
			this.quantityFrequencyMultiplierOfLeg2 = _quantityFrequencyMultiplierOfLeg2 == null ? null : _quantityFrequencyMultiplierOfLeg2;
			return this;
		}
		
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@RosettaAttribute("price")
		@RuneAttribute("price")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPrice(PriceAndNotation _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addPriceSchedule(PriceScheduleReport _priceSchedule, int idx) {
			getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
			if (priceSchedules != null) {
				for (final PriceScheduleReport toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("priceSchedule")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setPriceSchedule(List<? extends PriceScheduleReport> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setStrikePrice(StrikePriceAndNotation _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addStrikePriceSchedule(StrikePriceScheduleReport _strikePriceSchedule, int idx) {
			getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final StrikePriceScheduleReport toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("strikePriceSchedule")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setStrikePriceSchedule(List<? extends StrikePriceScheduleReport> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionOfLeg1")
		@RuneAttribute("fixedRateDayCountConventionOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg1(InterestComputationMethod4Code _fixedRateDayCountConventionOfLeg1) {
			this.fixedRateDayCountConventionOfLeg1 = _fixedRateDayCountConventionOfLeg1 == null ? null : _fixedRateDayCountConventionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRateDayCountConventionOfLeg2")
		@RuneAttribute("fixedRateDayCountConventionOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRateDayCountConventionOfLeg2(InterestComputationMethod4Code _fixedRateDayCountConventionOfLeg2) {
			this.fixedRateDayCountConventionOfLeg2 = _fixedRateDayCountConventionOfLeg2 == null ? null : _fixedRateDayCountConventionOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg1")
		@RuneAttribute("floatingRateDayCountConventionOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg1(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg1) {
			this.floatingRateDayCountConventionOfLeg1 = _floatingRateDayCountConventionOfLeg1 == null ? null : _floatingRateDayCountConventionOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateDayCountConventionOfLeg2")
		@RuneAttribute("floatingRateDayCountConventionOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRateDayCountConventionOfLeg2(InterestComputationMethod4Code _floatingRateDayCountConventionOfLeg2) {
			this.floatingRateDayCountConventionOfLeg2 = _floatingRateDayCountConventionOfLeg2 == null ? null : _floatingRateDayCountConventionOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg1(String _floatingRateResetFrequencyPeriodOfLeg1) {
			this.floatingRateResetFrequencyPeriodOfLeg1 = _floatingRateResetFrequencyPeriodOfLeg1 == null ? null : _floatingRateResetFrequencyPeriodOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg1(Integer _floatingRateResetFrequencyPeriodMultiplierOfLeg1) {
			this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 = _floatingRateResetFrequencyPeriodMultiplierOfLeg1 == null ? null : _floatingRateResetFrequencyPeriodMultiplierOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodOfLeg2(String _floatingRateResetFrequencyPeriodOfLeg2) {
			this.floatingRateResetFrequencyPeriodOfLeg2 = _floatingRateResetFrequencyPeriodOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRateResetFrequencyPeriodMultiplierOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRateResetFrequencyPeriodMultiplierOfLeg2(Integer _floatingRateResetFrequencyPeriodMultiplierOfLeg2) {
			this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 = _floatingRateResetFrequencyPeriodMultiplierOfLeg2 == null ? null : _floatingRateResetFrequencyPeriodMultiplierOfLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 _fixedRatePaymentFrequencyPeriodOfLeg1) {
			this.fixedRatePaymentFrequencyPeriodOfLeg1 = _fixedRatePaymentFrequencyPeriodOfLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodOfLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer _fixedRatePaymentFrequencyPeriodMultiplierOfLeg1) {
			this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 = _fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierOfLeg1;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 _fixedRatePaymentFrequencyPeriodOfLeg2) {
			this.fixedRatePaymentFrequencyPeriodOfLeg2 = _fixedRatePaymentFrequencyPeriodOfLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer _fixedRatePaymentFrequencyPeriodMultiplierOfLeg2) {
			this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 = _fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 == null ? null : _fixedRatePaymentFrequencyPeriodMultiplierOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg1(Frequency13Code__1 _floatingRatePaymentFrequencyPeriodOfLeg1) {
			this.floatingRatePaymentFrequencyPeriodOfLeg1 = _floatingRatePaymentFrequencyPeriodOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1) {
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg1;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodOfLeg2(Frequency13Code__1 _floatingRatePaymentFrequencyPeriodOfLeg2) {
			this.floatingRatePaymentFrequencyPeriodOfLeg2 = _floatingRatePaymentFrequencyPeriodOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodOfLeg2;
			return this;
		}
		
		@RosettaAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@RuneAttribute("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(Integer _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2) {
			this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 = _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 == null ? null : _floatingRatePaymentFrequencyPeriodMultiplierOfLeg2;
			return this;
		}
		
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addOtherPayment(OtherPaymentReport _otherPayment, int idx) {
			getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPaymentReport toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("otherPayment")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setOtherPayment(List<? extends OtherPaymentReport> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute(value="actionType", isRequired=true)
		@RuneAttribute(value="actionType", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setActionType(String _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setEventType(String _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@RosettaAttribute(value="eventDate", isRequired=true)
		@RuneAttribute(value="eventDate", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setEventDate(ZonedDateTime _eventDate) {
			this.eventDate = _eventDate == null ? null : _eventDate;
			return this;
		}
		
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNonReportable(MASNonReportable _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@RosettaAttribute(value="technicalRecordId", isRequired=true)
		@RuneAttribute(value="technicalRecordId", isRequired=true)
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfCounterparty1")
		@RuneAttribute("executionAgentOfCounterparty1")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setExecutionAgentOfCounterparty1(String _executionAgentOfCounterparty1) {
			this.executionAgentOfCounterparty1 = _executionAgentOfCounterparty1 == null ? null : _executionAgentOfCounterparty1;
			return this;
		}
		
		@RosettaAttribute("executionAgentOfCounterparty2DTCC")
		@RuneAttribute("executionAgentOfCounterparty2DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setExecutionAgentOfCounterparty2DTCC(String _executionAgentOfCounterparty2DTCC) {
			this.executionAgentOfCounterparty2DTCC = _executionAgentOfCounterparty2DTCC == null ? null : _executionAgentOfCounterparty2DTCC;
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg1DTCC")
		@RuneAttribute("notionalAmountScheduleLeg1DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1DTCC) {
			if (_notionalAmountScheduleLeg1DTCC != null) {
				this.notionalAmountScheduleLeg1DTCC.add(_notionalAmountScheduleLeg1DTCC.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(NotionalAmountScheduleLeg1Report _notionalAmountScheduleLeg1DTCC, int idx) {
			getIndex(this.notionalAmountScheduleLeg1DTCC, idx, () -> _notionalAmountScheduleLeg1DTCC.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCCs) {
			if (notionalAmountScheduleLeg1DTCCs != null) {
				for (final NotionalAmountScheduleLeg1Report toAdd : notionalAmountScheduleLeg1DTCCs) {
					this.notionalAmountScheduleLeg1DTCC.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg1DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalAmountScheduleLeg1DTCC(List<? extends NotionalAmountScheduleLeg1Report> notionalAmountScheduleLeg1DTCCs) {
			if (notionalAmountScheduleLeg1DTCCs == null) {
				this.notionalAmountScheduleLeg1DTCC = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg1DTCC = notionalAmountScheduleLeg1DTCCs.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalAmountScheduleLeg2DTCC")
		@RuneAttribute("notionalAmountScheduleLeg2DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2DTCC) {
			if (_notionalAmountScheduleLeg2DTCC != null) {
				this.notionalAmountScheduleLeg2DTCC.add(_notionalAmountScheduleLeg2DTCC.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(NotionalAmountScheduleLeg2Report _notionalAmountScheduleLeg2DTCC, int idx) {
			getIndex(this.notionalAmountScheduleLeg2DTCC, idx, () -> _notionalAmountScheduleLeg2DTCC.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCCs) {
			if (notionalAmountScheduleLeg2DTCCs != null) {
				for (final NotionalAmountScheduleLeg2Report toAdd : notionalAmountScheduleLeg2DTCCs) {
					this.notionalAmountScheduleLeg2DTCC.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalAmountScheduleLeg2DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalAmountScheduleLeg2DTCC(List<? extends NotionalAmountScheduleLeg2Report> notionalAmountScheduleLeg2DTCCs) {
			if (notionalAmountScheduleLeg2DTCCs == null) {
				this.notionalAmountScheduleLeg2DTCC = new ArrayList<>();
			} else {
				this.notionalAmountScheduleLeg2DTCC = notionalAmountScheduleLeg2DTCCs.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalQuantityScheduleLeg1DTCC")
		@RuneAttribute("notionalQuantityScheduleLeg1DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1DTCC) {
			if (_notionalQuantityScheduleLeg1DTCC != null) {
				this.notionalQuantityScheduleLeg1DTCC.add(_notionalQuantityScheduleLeg1DTCC.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(NotionalQuantityScheduleLeg1Report _notionalQuantityScheduleLeg1DTCC, int idx) {
			getIndex(this.notionalQuantityScheduleLeg1DTCC, idx, () -> _notionalQuantityScheduleLeg1DTCC.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCCs) {
			if (notionalQuantityScheduleLeg1DTCCs != null) {
				for (final NotionalQuantityScheduleLeg1Report toAdd : notionalQuantityScheduleLeg1DTCCs) {
					this.notionalQuantityScheduleLeg1DTCC.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalQuantityScheduleLeg1DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityScheduleLeg1DTCC(List<? extends NotionalQuantityScheduleLeg1Report> notionalQuantityScheduleLeg1DTCCs) {
			if (notionalQuantityScheduleLeg1DTCCs == null) {
				this.notionalQuantityScheduleLeg1DTCC = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg1DTCC = notionalQuantityScheduleLeg1DTCCs.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@RosettaAttribute("notionalQuantityScheduleLeg2DTCC")
		@RuneAttribute("notionalQuantityScheduleLeg2DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2DTCC) {
			if (_notionalQuantityScheduleLeg2DTCC != null) {
				this.notionalQuantityScheduleLeg2DTCC.add(_notionalQuantityScheduleLeg2DTCC.toBuilder());
			}
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(NotionalQuantityScheduleLeg2Report _notionalQuantityScheduleLeg2DTCC, int idx) {
			getIndex(this.notionalQuantityScheduleLeg2DTCC, idx, () -> _notionalQuantityScheduleLeg2DTCC.toBuilder());
			return this;
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder addNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCCs) {
			if (notionalQuantityScheduleLeg2DTCCs != null) {
				for (final NotionalQuantityScheduleLeg2Report toAdd : notionalQuantityScheduleLeg2DTCCs) {
					this.notionalQuantityScheduleLeg2DTCC.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@RuneAttribute("notionalQuantityScheduleLeg2DTCC")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder setNotionalQuantityScheduleLeg2DTCC(List<? extends NotionalQuantityScheduleLeg2Report> notionalQuantityScheduleLeg2DTCCs) {
			if (notionalQuantityScheduleLeg2DTCCs == null) {
				this.notionalQuantityScheduleLeg2DTCC = new ArrayList<>();
			} else {
				this.notionalQuantityScheduleLeg2DTCC = notionalQuantityScheduleLeg2DTCCs.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		public MASTransactionReport build() {
			return new MASTransactionReport.MASTransactionReportImpl(this);
		}
		
		@Override
		public MASTransactionReport.MASTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder prune() {
			if (spreadOfLeg1!=null && !spreadOfLeg1.prune().hasData()) spreadOfLeg1 = null;
			if (spreadOfLeg2!=null && !spreadOfLeg2.prune().hasData()) spreadOfLeg2 = null;
			basketConstituents = basketConstituents.stream().filter(b->b!=null).<BasketConstituentsReport.BasketConstituentsReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (price!=null && !price.prune().hasData()) price = null;
			priceSchedule = priceSchedule.stream().filter(b->b!=null).<PriceScheduleReport.PriceScheduleReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (strikePrice!=null && !strikePrice.prune().hasData()) strikePrice = null;
			strikePriceSchedule = strikePriceSchedule.stream().filter(b->b!=null).<StrikePriceScheduleReport.StrikePriceScheduleReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			otherPayment = otherPayment.stream().filter(b->b!=null).<OtherPaymentReport.OtherPaymentReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			notionalAmountScheduleLeg1DTCC = notionalAmountScheduleLeg1DTCC.stream().filter(b->b!=null).<NotionalAmountScheduleLeg1Report.NotionalAmountScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalAmountScheduleLeg2DTCC = notionalAmountScheduleLeg2DTCC.stream().filter(b->b!=null).<NotionalAmountScheduleLeg2Report.NotionalAmountScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalQuantityScheduleLeg1DTCC = notionalQuantityScheduleLeg1DTCC.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			notionalQuantityScheduleLeg2DTCC = notionalQuantityScheduleLeg2DTCC.stream().filter(b->b!=null).<NotionalQuantityScheduleLeg2Report.NotionalQuantityScheduleLeg2ReportBuilder>map(b->b.prune()).filter(b->b.hasData()).collect(Collectors.toList());
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCounterparty1()!=null) return true;
			if (getCounterparty2()!=null) return true;
			if (getCounterparty2IdentifierType()!=null) return true;
			if (getTradingCapacityOfSpecifiedPerson()!=null) return true;
			if (getDirection()!=null) return true;
			if (getDirectionOfLeg1()!=null) return true;
			if (getDirectionOfLeg2()!=null) return true;
			if (getReportingSpecifiedPerson()!=null) return true;
			if (getDataSubmitter()!=null) return true;
			if (getUniqueTransactionIdentifier()!=null) return true;
			if (getUniqueTransactionIdentifierProprietary()!=null) return true;
			if (getUniqueProductIdentifier()!=null) return true;
			if (getPriorUTI()!=null) return true;
			if (getPriorUTIProprietary()!=null) return true;
			if (getContractType()!=null) return true;
			if (getAssetClass()!=null) return true;
			if (getUnderlying()!=null) return true;
			if (getUnderlyingIdentificationType()!=null) return true;
			if (getUnderlyingIdOther()!=null) return true;
			if (getUnderlyingIdOtherSource()!=null) return true;
			if (getNameOfTheUnderlyingIndex()!=null) return true;
			if (getFixedRateOfLeg1()!=null) return true;
			if (getIdentifierOfFloatingRateOfLeg1()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg1()!=null) return true;
			if (getSpreadOfLeg1()!=null && getSpreadOfLeg1().hasData()) return true;
			if (getFixedRateOfLeg2()!=null) return true;
			if (getIdentifierOfFloatingRateOfLeg2()!=null) return true;
			if (getNameOfTheFloatingRateOfLeg2()!=null) return true;
			if (getSpreadOfLeg2()!=null && getSpreadOfLeg2().hasData()) return true;
			if (getOptionType()!=null) return true;
			if (getOptionStyle()!=null) return true;
			if (getFirstExerciseDate()!=null) return true;
			if (getEffectiveDate()!=null) return true;
			if (getExpirationDate()!=null) return true;
			if (getSwapLinkID()!=null) return true;
			if (getPackageIdentifier()!=null) return true;
			if (getDeliveryType()!=null) return true;
			if (getSettlementCurrency1()!=null) return true;
			if (getSettlementCurrency2()!=null) return true;
			if (getFinalContractualSettlementDate()!=null) return true;
			if (getCleared()!=null) return true;
			if (getCentralCounterparty()!=null) return true;
			if (getClearingMember()!=null) return true;
			if (getClearingTimestamp()!=null) return true;
			if (getPlatformIdentifier()!=null) return true;
			if (getBookingLocation()!=null) return true;
			if (getTraderLocation()!=null) return true;
			if (getConfirmed()!=null) return true;
			if (getConfirmationTimestamp()!=null) return true;
			if (getExecutionTimestamp()!=null) return true;
			if (getReportingTimestamp()!=null) return true;
			if (getBasketConstituents()!=null && getBasketConstituents().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getValuationAmount()!=null) return true;
			if (getValuationCurrency()!=null) return true;
			if (getValuationMethod()!=null) return true;
			if (getValuationTimestamp()!=null) return true;
			if (getCollateralPortfolioIndicator()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			if (getNotionalAmountOfTheContractOrLeg1()!=null) return true;
			if (getNotionalCurrencyOfTheContractOrLeg1()!=null) return true;
			if (getNotionalAmountOfLeg2()!=null) return true;
			if (getNotionalCurrencyOfLeg2()!=null) return true;
			if (getTotalNotionalQuantityOfTheContractOrLeg1()!=null) return true;
			if (getQuantityUnitOfMeasureForTheContractOrLeg1()!=null) return true;
			if (getNotionalQuantityOfTheContractOrLeg1()!=null) return true;
			if (getQuantityFrequencyOfTheContractOrLeg1()!=null) return true;
			if (getQuantityFrequencyMultiplierOfTheContractOrLeg1()!=null) return true;
			if (getTotalNotionalQuantityLeg2()!=null) return true;
			if (getQuantityUnitOfMeasureLeg2()!=null) return true;
			if (getNotionalQuantityOfLeg2()!=null) return true;
			if (getQuantityFrequencyOfLeg2()!=null) return true;
			if (getQuantityFrequencyMultiplierOfLeg2()!=null) return true;
			if (getCallAmount()!=null) return true;
			if (getCallCurrency()!=null) return true;
			if (getPutAmount()!=null) return true;
			if (getPutCurrency()!=null) return true;
			if (getPrice()!=null && getPrice().hasData()) return true;
			if (getPriceUnitOfMeasure()!=null) return true;
			if (getPriceSchedule()!=null && getPriceSchedule().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getStrikePrice()!=null && getStrikePrice().hasData()) return true;
			if (getStrikePriceSchedule()!=null && getStrikePriceSchedule().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getOptionPremiumAmount()!=null) return true;
			if (getOptionPremiumCurrency()!=null) return true;
			if (getExchangeRate()!=null) return true;
			if (getExchangeRateBasis()!=null) return true;
			if (getFixedRateDayCountConventionOfLeg1()!=null) return true;
			if (getFixedRateDayCountConventionOfLeg2()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg1()!=null) return true;
			if (getFloatingRateDayCountConventionOfLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodOfLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierOfLeg1()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodOfLeg2()!=null) return true;
			if (getFloatingRateResetFrequencyPeriodMultiplierOfLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodOfLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodOfLeg2()!=null) return true;
			if (getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodOfLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodOfLeg2()!=null) return true;
			if (getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2()!=null) return true;
			if (getOtherPayment()!=null && getOtherPayment().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getActionType()!=null) return true;
			if (getEventType()!=null) return true;
			if (getEventDate()!=null) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			if (getTechnicalRecordId()!=null) return true;
			if (getCounterparty2Name()!=null) return true;
			if (getExecutionAgentOfCounterparty1()!=null) return true;
			if (getExecutionAgentOfCounterparty2DTCC()!=null) return true;
			if (getNotionalAmountScheduleLeg1DTCC()!=null && getNotionalAmountScheduleLeg1DTCC().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalAmountScheduleLeg2DTCC()!=null && getNotionalAmountScheduleLeg2DTCC().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalQuantityScheduleLeg1DTCC()!=null && getNotionalQuantityScheduleLeg1DTCC().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			if (getNotionalQuantityScheduleLeg2DTCC()!=null && getNotionalQuantityScheduleLeg2DTCC().stream().filter(Objects::nonNull).anyMatch(a->a.hasData())) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public MASTransactionReport.MASTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			MASTransactionReport.MASTransactionReportBuilder o = (MASTransactionReport.MASTransactionReportBuilder) other;
			
			merger.mergeRosetta(getSpreadOfLeg1(), o.getSpreadOfLeg1(), this::setSpreadOfLeg1);
			merger.mergeRosetta(getSpreadOfLeg2(), o.getSpreadOfLeg2(), this::setSpreadOfLeg2);
			merger.mergeRosetta(getBasketConstituents(), o.getBasketConstituents(), this::getOrCreateBasketConstituents);
			merger.mergeRosetta(getPrice(), o.getPrice(), this::setPrice);
			merger.mergeRosetta(getPriceSchedule(), o.getPriceSchedule(), this::getOrCreatePriceSchedule);
			merger.mergeRosetta(getStrikePrice(), o.getStrikePrice(), this::setStrikePrice);
			merger.mergeRosetta(getStrikePriceSchedule(), o.getStrikePriceSchedule(), this::getOrCreateStrikePriceSchedule);
			merger.mergeRosetta(getOtherPayment(), o.getOtherPayment(), this::getOrCreateOtherPayment);
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			merger.mergeRosetta(getNotionalAmountScheduleLeg1DTCC(), o.getNotionalAmountScheduleLeg1DTCC(), this::getOrCreateNotionalAmountScheduleLeg1DTCC);
			merger.mergeRosetta(getNotionalAmountScheduleLeg2DTCC(), o.getNotionalAmountScheduleLeg2DTCC(), this::getOrCreateNotionalAmountScheduleLeg2DTCC);
			merger.mergeRosetta(getNotionalQuantityScheduleLeg1DTCC(), o.getNotionalQuantityScheduleLeg1DTCC(), this::getOrCreateNotionalQuantityScheduleLeg1DTCC);
			merger.mergeRosetta(getNotionalQuantityScheduleLeg2DTCC(), o.getNotionalQuantityScheduleLeg2DTCC(), this::getOrCreateNotionalQuantityScheduleLeg2DTCC);
			
			merger.mergeBasic(getCounterparty1(), o.getCounterparty1(), this::setCounterparty1);
			merger.mergeBasic(getCounterparty2(), o.getCounterparty2(), this::setCounterparty2);
			merger.mergeBasic(getCounterparty2IdentifierType(), o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierType);
			merger.mergeBasic(getTradingCapacityOfSpecifiedPerson(), o.getTradingCapacityOfSpecifiedPerson(), this::setTradingCapacityOfSpecifiedPerson);
			merger.mergeBasic(getDirection(), o.getDirection(), this::setDirection);
			merger.mergeBasic(getDirectionOfLeg1(), o.getDirectionOfLeg1(), this::setDirectionOfLeg1);
			merger.mergeBasic(getDirectionOfLeg2(), o.getDirectionOfLeg2(), this::setDirectionOfLeg2);
			merger.mergeBasic(getReportingSpecifiedPerson(), o.getReportingSpecifiedPerson(), this::setReportingSpecifiedPerson);
			merger.mergeBasic(getDataSubmitter(), o.getDataSubmitter(), this::setDataSubmitter);
			merger.mergeBasic(getUniqueTransactionIdentifier(), o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier);
			merger.mergeBasic(getUniqueTransactionIdentifierProprietary(), o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary);
			merger.mergeBasic(getUniqueProductIdentifier(), o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier);
			merger.mergeBasic(getPriorUTI(), o.getPriorUTI(), this::setPriorUTI);
			merger.mergeBasic(getPriorUTIProprietary(), o.getPriorUTIProprietary(), this::setPriorUTIProprietary);
			merger.mergeBasic(getContractType(), o.getContractType(), this::setContractType);
			merger.mergeBasic(getAssetClass(), o.getAssetClass(), this::setAssetClass);
			merger.mergeBasic(getUnderlying(), o.getUnderlying(), this::setUnderlying);
			merger.mergeBasic(getUnderlyingIdentificationType(), o.getUnderlyingIdentificationType(), this::setUnderlyingIdentificationType);
			merger.mergeBasic(getUnderlyingIdOther(), o.getUnderlyingIdOther(), this::setUnderlyingIdOther);
			merger.mergeBasic(getUnderlyingIdOtherSource(), o.getUnderlyingIdOtherSource(), this::setUnderlyingIdOtherSource);
			merger.mergeBasic(getNameOfTheUnderlyingIndex(), o.getNameOfTheUnderlyingIndex(), this::setNameOfTheUnderlyingIndex);
			merger.mergeBasic(getFixedRateOfLeg1(), o.getFixedRateOfLeg1(), this::setFixedRateOfLeg1);
			merger.mergeBasic(getIdentifierOfFloatingRateOfLeg1(), o.getIdentifierOfFloatingRateOfLeg1(), this::setIdentifierOfFloatingRateOfLeg1);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg1(), o.getNameOfTheFloatingRateOfLeg1(), this::setNameOfTheFloatingRateOfLeg1);
			merger.mergeBasic(getFixedRateOfLeg2(), o.getFixedRateOfLeg2(), this::setFixedRateOfLeg2);
			merger.mergeBasic(getIdentifierOfFloatingRateOfLeg2(), o.getIdentifierOfFloatingRateOfLeg2(), this::setIdentifierOfFloatingRateOfLeg2);
			merger.mergeBasic(getNameOfTheFloatingRateOfLeg2(), o.getNameOfTheFloatingRateOfLeg2(), this::setNameOfTheFloatingRateOfLeg2);
			merger.mergeBasic(getOptionType(), o.getOptionType(), this::setOptionType);
			merger.mergeBasic(getOptionStyle(), o.getOptionStyle(), this::setOptionStyle);
			merger.mergeBasic(getFirstExerciseDate(), o.getFirstExerciseDate(), this::setFirstExerciseDate);
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getExpirationDate(), o.getExpirationDate(), this::setExpirationDate);
			merger.mergeBasic(getSwapLinkID(), o.getSwapLinkID(), this::setSwapLinkID);
			merger.mergeBasic(getPackageIdentifier(), o.getPackageIdentifier(), this::setPackageIdentifier);
			merger.mergeBasic(getDeliveryType(), o.getDeliveryType(), this::setDeliveryType);
			merger.mergeBasic(getSettlementCurrency1(), o.getSettlementCurrency1(), this::setSettlementCurrency1);
			merger.mergeBasic(getSettlementCurrency2(), o.getSettlementCurrency2(), this::setSettlementCurrency2);
			merger.mergeBasic(getFinalContractualSettlementDate(), o.getFinalContractualSettlementDate(), this::setFinalContractualSettlementDate);
			merger.mergeBasic(getCleared(), o.getCleared(), this::setCleared);
			merger.mergeBasic(getCentralCounterparty(), o.getCentralCounterparty(), this::setCentralCounterparty);
			merger.mergeBasic(getClearingMember(), o.getClearingMember(), this::setClearingMember);
			merger.mergeBasic(getClearingTimestamp(), o.getClearingTimestamp(), this::setClearingTimestamp);
			merger.mergeBasic(getPlatformIdentifier(), o.getPlatformIdentifier(), this::setPlatformIdentifier);
			merger.mergeBasic(getBookingLocation(), o.getBookingLocation(), this::setBookingLocation);
			merger.mergeBasic(getTraderLocation(), o.getTraderLocation(), this::setTraderLocation);
			merger.mergeBasic(getConfirmed(), o.getConfirmed(), this::setConfirmed);
			merger.mergeBasic(getConfirmationTimestamp(), o.getConfirmationTimestamp(), this::setConfirmationTimestamp);
			merger.mergeBasic(getExecutionTimestamp(), o.getExecutionTimestamp(), this::setExecutionTimestamp);
			merger.mergeBasic(getReportingTimestamp(), o.getReportingTimestamp(), this::setReportingTimestamp);
			merger.mergeBasic(getValuationAmount(), o.getValuationAmount(), this::setValuationAmount);
			merger.mergeBasic(getValuationCurrency(), o.getValuationCurrency(), this::setValuationCurrency);
			merger.mergeBasic(getValuationMethod(), o.getValuationMethod(), this::setValuationMethod);
			merger.mergeBasic(getValuationTimestamp(), o.getValuationTimestamp(), this::setValuationTimestamp);
			merger.mergeBasic(getCollateralPortfolioIndicator(), o.getCollateralPortfolioIndicator(), this::setCollateralPortfolioIndicator);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			merger.mergeBasic(getNotionalAmountOfTheContractOrLeg1(), o.getNotionalAmountOfTheContractOrLeg1(), this::setNotionalAmountOfTheContractOrLeg1);
			merger.mergeBasic(getNotionalCurrencyOfTheContractOrLeg1(), o.getNotionalCurrencyOfTheContractOrLeg1(), this::setNotionalCurrencyOfTheContractOrLeg1);
			merger.mergeBasic(getNotionalAmountOfLeg2(), o.getNotionalAmountOfLeg2(), this::setNotionalAmountOfLeg2);
			merger.mergeBasic(getNotionalCurrencyOfLeg2(), o.getNotionalCurrencyOfLeg2(), this::setNotionalCurrencyOfLeg2);
			merger.mergeBasic(getTotalNotionalQuantityOfTheContractOrLeg1(), o.getTotalNotionalQuantityOfTheContractOrLeg1(), this::setTotalNotionalQuantityOfTheContractOrLeg1);
			merger.mergeBasic(getQuantityUnitOfMeasureForTheContractOrLeg1(), o.getQuantityUnitOfMeasureForTheContractOrLeg1(), this::setQuantityUnitOfMeasureForTheContractOrLeg1);
			merger.mergeBasic(getNotionalQuantityOfTheContractOrLeg1(), o.getNotionalQuantityOfTheContractOrLeg1(), this::setNotionalQuantityOfTheContractOrLeg1);
			merger.mergeBasic(getQuantityFrequencyOfTheContractOrLeg1(), o.getQuantityFrequencyOfTheContractOrLeg1(), this::setQuantityFrequencyOfTheContractOrLeg1);
			merger.mergeBasic(getQuantityFrequencyMultiplierOfTheContractOrLeg1(), o.getQuantityFrequencyMultiplierOfTheContractOrLeg1(), this::setQuantityFrequencyMultiplierOfTheContractOrLeg1);
			merger.mergeBasic(getTotalNotionalQuantityLeg2(), o.getTotalNotionalQuantityLeg2(), this::setTotalNotionalQuantityLeg2);
			merger.mergeBasic(getQuantityUnitOfMeasureLeg2(), o.getQuantityUnitOfMeasureLeg2(), this::setQuantityUnitOfMeasureLeg2);
			merger.mergeBasic(getNotionalQuantityOfLeg2(), o.getNotionalQuantityOfLeg2(), this::setNotionalQuantityOfLeg2);
			merger.mergeBasic(getQuantityFrequencyOfLeg2(), o.getQuantityFrequencyOfLeg2(), this::setQuantityFrequencyOfLeg2);
			merger.mergeBasic(getQuantityFrequencyMultiplierOfLeg2(), o.getQuantityFrequencyMultiplierOfLeg2(), this::setQuantityFrequencyMultiplierOfLeg2);
			merger.mergeBasic(getCallAmount(), o.getCallAmount(), this::setCallAmount);
			merger.mergeBasic(getCallCurrency(), o.getCallCurrency(), this::setCallCurrency);
			merger.mergeBasic(getPutAmount(), o.getPutAmount(), this::setPutAmount);
			merger.mergeBasic(getPutCurrency(), o.getPutCurrency(), this::setPutCurrency);
			merger.mergeBasic(getPriceUnitOfMeasure(), o.getPriceUnitOfMeasure(), this::setPriceUnitOfMeasure);
			merger.mergeBasic(getOptionPremiumAmount(), o.getOptionPremiumAmount(), this::setOptionPremiumAmount);
			merger.mergeBasic(getOptionPremiumCurrency(), o.getOptionPremiumCurrency(), this::setOptionPremiumCurrency);
			merger.mergeBasic(getExchangeRate(), o.getExchangeRate(), this::setExchangeRate);
			merger.mergeBasic(getExchangeRateBasis(), o.getExchangeRateBasis(), this::setExchangeRateBasis);
			merger.mergeBasic(getFixedRateDayCountConventionOfLeg1(), o.getFixedRateDayCountConventionOfLeg1(), this::setFixedRateDayCountConventionOfLeg1);
			merger.mergeBasic(getFixedRateDayCountConventionOfLeg2(), o.getFixedRateDayCountConventionOfLeg2(), this::setFixedRateDayCountConventionOfLeg2);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg1(), o.getFloatingRateDayCountConventionOfLeg1(), this::setFloatingRateDayCountConventionOfLeg1);
			merger.mergeBasic(getFloatingRateDayCountConventionOfLeg2(), o.getFloatingRateDayCountConventionOfLeg2(), this::setFloatingRateDayCountConventionOfLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodOfLeg1(), o.getFloatingRateResetFrequencyPeriodOfLeg1(), this::setFloatingRateResetFrequencyPeriodOfLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1(), this::setFloatingRateResetFrequencyPeriodMultiplierOfLeg1);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodOfLeg2(), o.getFloatingRateResetFrequencyPeriodOfLeg2(), this::setFloatingRateResetFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2(), this::setFloatingRateResetFrequencyPeriodMultiplierOfLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodOfLeg1(), o.getFixedRatePaymentFrequencyPeriodOfLeg1(), this::setFixedRatePaymentFrequencyPeriodOfLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1(), this::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg1);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodOfLeg2(), o.getFixedRatePaymentFrequencyPeriodOfLeg2(), this::setFixedRatePaymentFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2(), this::setFixedRatePaymentFrequencyPeriodMultiplierOfLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodOfLeg1(), o.getFloatingRatePaymentFrequencyPeriodOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodOfLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodOfLeg2(), o.getFloatingRatePaymentFrequencyPeriodOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodOfLeg2);
			merger.mergeBasic(getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2(), this::setFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2);
			merger.mergeBasic(getActionType(), o.getActionType(), this::setActionType);
			merger.mergeBasic(getEventType(), o.getEventType(), this::setEventType);
			merger.mergeBasic(getEventDate(), o.getEventDate(), this::setEventDate);
			merger.mergeBasic(getTechnicalRecordId(), o.getTechnicalRecordId(), this::setTechnicalRecordId);
			merger.mergeBasic(getCounterparty2Name(), o.getCounterparty2Name(), this::setCounterparty2Name);
			merger.mergeBasic(getExecutionAgentOfCounterparty1(), o.getExecutionAgentOfCounterparty1(), this::setExecutionAgentOfCounterparty1);
			merger.mergeBasic(getExecutionAgentOfCounterparty2DTCC(), o.getExecutionAgentOfCounterparty2DTCC(), this::setExecutionAgentOfCounterparty2DTCC);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			MASTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1, _that.getCounterparty1())) return false;
			if (!Objects.equals(counterparty2, _that.getCounterparty2())) return false;
			if (!Objects.equals(counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) return false;
			if (!Objects.equals(tradingCapacityOfSpecifiedPerson, _that.getTradingCapacityOfSpecifiedPerson())) return false;
			if (!Objects.equals(direction, _that.getDirection())) return false;
			if (!Objects.equals(directionOfLeg1, _that.getDirectionOfLeg1())) return false;
			if (!Objects.equals(directionOfLeg2, _that.getDirectionOfLeg2())) return false;
			if (!Objects.equals(reportingSpecifiedPerson, _that.getReportingSpecifiedPerson())) return false;
			if (!Objects.equals(dataSubmitter, _that.getDataSubmitter())) return false;
			if (!Objects.equals(uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) return false;
			if (!Objects.equals(uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) return false;
			if (!Objects.equals(uniqueProductIdentifier, _that.getUniqueProductIdentifier())) return false;
			if (!Objects.equals(priorUTI, _that.getPriorUTI())) return false;
			if (!Objects.equals(priorUTIProprietary, _that.getPriorUTIProprietary())) return false;
			if (!Objects.equals(contractType, _that.getContractType())) return false;
			if (!Objects.equals(assetClass, _that.getAssetClass())) return false;
			if (!Objects.equals(underlying, _that.getUnderlying())) return false;
			if (!Objects.equals(underlyingIdentificationType, _that.getUnderlyingIdentificationType())) return false;
			if (!Objects.equals(underlyingIdOther, _that.getUnderlyingIdOther())) return false;
			if (!Objects.equals(underlyingIdOtherSource, _that.getUnderlyingIdOtherSource())) return false;
			if (!Objects.equals(nameOfTheUnderlyingIndex, _that.getNameOfTheUnderlyingIndex())) return false;
			if (!Objects.equals(fixedRateOfLeg1, _that.getFixedRateOfLeg1())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg1, _that.getIdentifierOfFloatingRateOfLeg1())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg1, _that.getNameOfTheFloatingRateOfLeg1())) return false;
			if (!Objects.equals(spreadOfLeg1, _that.getSpreadOfLeg1())) return false;
			if (!Objects.equals(fixedRateOfLeg2, _that.getFixedRateOfLeg2())) return false;
			if (!Objects.equals(identifierOfFloatingRateOfLeg2, _that.getIdentifierOfFloatingRateOfLeg2())) return false;
			if (!Objects.equals(nameOfTheFloatingRateOfLeg2, _that.getNameOfTheFloatingRateOfLeg2())) return false;
			if (!Objects.equals(spreadOfLeg2, _that.getSpreadOfLeg2())) return false;
			if (!Objects.equals(optionType, _that.getOptionType())) return false;
			if (!Objects.equals(optionStyle, _that.getOptionStyle())) return false;
			if (!Objects.equals(firstExerciseDate, _that.getFirstExerciseDate())) return false;
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(expirationDate, _that.getExpirationDate())) return false;
			if (!Objects.equals(swapLinkID, _that.getSwapLinkID())) return false;
			if (!Objects.equals(packageIdentifier, _that.getPackageIdentifier())) return false;
			if (!Objects.equals(deliveryType, _that.getDeliveryType())) return false;
			if (!Objects.equals(settlementCurrency1, _that.getSettlementCurrency1())) return false;
			if (!Objects.equals(settlementCurrency2, _that.getSettlementCurrency2())) return false;
			if (!Objects.equals(finalContractualSettlementDate, _that.getFinalContractualSettlementDate())) return false;
			if (!Objects.equals(cleared, _that.getCleared())) return false;
			if (!Objects.equals(centralCounterparty, _that.getCentralCounterparty())) return false;
			if (!Objects.equals(clearingMember, _that.getClearingMember())) return false;
			if (!Objects.equals(clearingTimestamp, _that.getClearingTimestamp())) return false;
			if (!Objects.equals(platformIdentifier, _that.getPlatformIdentifier())) return false;
			if (!Objects.equals(bookingLocation, _that.getBookingLocation())) return false;
			if (!Objects.equals(traderLocation, _that.getTraderLocation())) return false;
			if (!Objects.equals(confirmed, _that.getConfirmed())) return false;
			if (!Objects.equals(confirmationTimestamp, _that.getConfirmationTimestamp())) return false;
			if (!Objects.equals(executionTimestamp, _that.getExecutionTimestamp())) return false;
			if (!Objects.equals(reportingTimestamp, _that.getReportingTimestamp())) return false;
			if (!ListEquals.listEquals(basketConstituents, _that.getBasketConstituents())) return false;
			if (!Objects.equals(valuationAmount, _that.getValuationAmount())) return false;
			if (!Objects.equals(valuationCurrency, _that.getValuationCurrency())) return false;
			if (!Objects.equals(valuationMethod, _that.getValuationMethod())) return false;
			if (!Objects.equals(valuationTimestamp, _that.getValuationTimestamp())) return false;
			if (!Objects.equals(collateralPortfolioIndicator, _that.getCollateralPortfolioIndicator())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(notionalAmountOfTheContractOrLeg1, _that.getNotionalAmountOfTheContractOrLeg1())) return false;
			if (!Objects.equals(notionalCurrencyOfTheContractOrLeg1, _that.getNotionalCurrencyOfTheContractOrLeg1())) return false;
			if (!Objects.equals(notionalAmountOfLeg2, _that.getNotionalAmountOfLeg2())) return false;
			if (!Objects.equals(notionalCurrencyOfLeg2, _that.getNotionalCurrencyOfLeg2())) return false;
			if (!Objects.equals(totalNotionalQuantityOfTheContractOrLeg1, _that.getTotalNotionalQuantityOfTheContractOrLeg1())) return false;
			if (!Objects.equals(quantityUnitOfMeasureForTheContractOrLeg1, _that.getQuantityUnitOfMeasureForTheContractOrLeg1())) return false;
			if (!Objects.equals(notionalQuantityOfTheContractOrLeg1, _that.getNotionalQuantityOfTheContractOrLeg1())) return false;
			if (!Objects.equals(quantityFrequencyOfTheContractOrLeg1, _that.getQuantityFrequencyOfTheContractOrLeg1())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierOfTheContractOrLeg1, _that.getQuantityFrequencyMultiplierOfTheContractOrLeg1())) return false;
			if (!Objects.equals(totalNotionalQuantityLeg2, _that.getTotalNotionalQuantityLeg2())) return false;
			if (!Objects.equals(quantityUnitOfMeasureLeg2, _that.getQuantityUnitOfMeasureLeg2())) return false;
			if (!Objects.equals(notionalQuantityOfLeg2, _that.getNotionalQuantityOfLeg2())) return false;
			if (!Objects.equals(quantityFrequencyOfLeg2, _that.getQuantityFrequencyOfLeg2())) return false;
			if (!Objects.equals(quantityFrequencyMultiplierOfLeg2, _that.getQuantityFrequencyMultiplierOfLeg2())) return false;
			if (!Objects.equals(callAmount, _that.getCallAmount())) return false;
			if (!Objects.equals(callCurrency, _that.getCallCurrency())) return false;
			if (!Objects.equals(putAmount, _that.getPutAmount())) return false;
			if (!Objects.equals(putCurrency, _that.getPutCurrency())) return false;
			if (!Objects.equals(price, _that.getPrice())) return false;
			if (!Objects.equals(priceUnitOfMeasure, _that.getPriceUnitOfMeasure())) return false;
			if (!ListEquals.listEquals(priceSchedule, _that.getPriceSchedule())) return false;
			if (!Objects.equals(strikePrice, _that.getStrikePrice())) return false;
			if (!ListEquals.listEquals(strikePriceSchedule, _that.getStrikePriceSchedule())) return false;
			if (!Objects.equals(optionPremiumAmount, _that.getOptionPremiumAmount())) return false;
			if (!Objects.equals(optionPremiumCurrency, _that.getOptionPremiumCurrency())) return false;
			if (!Objects.equals(exchangeRate, _that.getExchangeRate())) return false;
			if (!Objects.equals(exchangeRateBasis, _that.getExchangeRateBasis())) return false;
			if (!Objects.equals(fixedRateDayCountConventionOfLeg1, _that.getFixedRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(fixedRateDayCountConventionOfLeg2, _that.getFixedRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg1, _that.getFloatingRateDayCountConventionOfLeg1())) return false;
			if (!Objects.equals(floatingRateDayCountConventionOfLeg2, _that.getFloatingRateDayCountConventionOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg1, _that.getFloatingRateResetFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodOfLeg2, _that.getFloatingRateResetFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRateResetFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodOfLeg1, _that.getFixedRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodOfLeg2, _that.getFixedRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(fixedRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg1, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodOfLeg2())) return false;
			if (!Objects.equals(floatingRatePaymentFrequencyPeriodMultiplierOfLeg2, _that.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2())) return false;
			if (!ListEquals.listEquals(otherPayment, _that.getOtherPayment())) return false;
			if (!Objects.equals(actionType, _that.getActionType())) return false;
			if (!Objects.equals(eventType, _that.getEventType())) return false;
			if (!Objects.equals(eventDate, _that.getEventDate())) return false;
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			if (!Objects.equals(technicalRecordId, _that.getTechnicalRecordId())) return false;
			if (!Objects.equals(counterparty2Name, _that.getCounterparty2Name())) return false;
			if (!Objects.equals(executionAgentOfCounterparty1, _that.getExecutionAgentOfCounterparty1())) return false;
			if (!Objects.equals(executionAgentOfCounterparty2DTCC, _that.getExecutionAgentOfCounterparty2DTCC())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg1DTCC, _that.getNotionalAmountScheduleLeg1DTCC())) return false;
			if (!ListEquals.listEquals(notionalAmountScheduleLeg2DTCC, _that.getNotionalAmountScheduleLeg2DTCC())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg1DTCC, _that.getNotionalQuantityScheduleLeg1DTCC())) return false;
			if (!ListEquals.listEquals(notionalQuantityScheduleLeg2DTCC, _that.getNotionalQuantityScheduleLeg2DTCC())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1 != null ? counterparty1.hashCode() : 0);
			_result = 31 * _result + (counterparty2 != null ? counterparty2.hashCode() : 0);
			_result = 31 * _result + (counterparty2IdentifierType != null ? counterparty2IdentifierType.hashCode() : 0);
			_result = 31 * _result + (tradingCapacityOfSpecifiedPerson != null ? tradingCapacityOfSpecifiedPerson.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (direction != null ? direction.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg1 != null ? directionOfLeg1.hashCode() : 0);
			_result = 31 * _result + (directionOfLeg2 != null ? directionOfLeg2.hashCode() : 0);
			_result = 31 * _result + (reportingSpecifiedPerson != null ? reportingSpecifiedPerson.hashCode() : 0);
			_result = 31 * _result + (dataSubmitter != null ? dataSubmitter.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifier != null ? uniqueTransactionIdentifier.hashCode() : 0);
			_result = 31 * _result + (uniqueTransactionIdentifierProprietary != null ? uniqueTransactionIdentifierProprietary.hashCode() : 0);
			_result = 31 * _result + (uniqueProductIdentifier != null ? uniqueProductIdentifier.hashCode() : 0);
			_result = 31 * _result + (priorUTI != null ? priorUTI.hashCode() : 0);
			_result = 31 * _result + (priorUTIProprietary != null ? priorUTIProprietary.hashCode() : 0);
			_result = 31 * _result + (contractType != null ? contractType.hashCode() : 0);
			_result = 31 * _result + (assetClass != null ? assetClass.hashCode() : 0);
			_result = 31 * _result + (underlying != null ? underlying.hashCode() : 0);
			_result = 31 * _result + (underlyingIdentificationType != null ? underlyingIdentificationType.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOther != null ? underlyingIdOther.hashCode() : 0);
			_result = 31 * _result + (underlyingIdOtherSource != null ? underlyingIdOtherSource.hashCode() : 0);
			_result = 31 * _result + (nameOfTheUnderlyingIndex != null ? nameOfTheUnderlyingIndex.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg1 != null ? fixedRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg1 != null ? identifierOfFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg1 != null ? nameOfTheFloatingRateOfLeg1.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg1 != null ? spreadOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRateOfLeg2 != null ? fixedRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (identifierOfFloatingRateOfLeg2 != null ? identifierOfFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (nameOfTheFloatingRateOfLeg2 != null ? nameOfTheFloatingRateOfLeg2.hashCode() : 0);
			_result = 31 * _result + (spreadOfLeg2 != null ? spreadOfLeg2.hashCode() : 0);
			_result = 31 * _result + (optionType != null ? optionType.hashCode() : 0);
			_result = 31 * _result + (optionStyle != null ? optionStyle.hashCode() : 0);
			_result = 31 * _result + (firstExerciseDate != null ? firstExerciseDate.hashCode() : 0);
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (expirationDate != null ? expirationDate.hashCode() : 0);
			_result = 31 * _result + (swapLinkID != null ? swapLinkID.hashCode() : 0);
			_result = 31 * _result + (packageIdentifier != null ? packageIdentifier.hashCode() : 0);
			_result = 31 * _result + (deliveryType != null ? deliveryType.hashCode() : 0);
			_result = 31 * _result + (settlementCurrency1 != null ? settlementCurrency1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementCurrency2 != null ? settlementCurrency2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (finalContractualSettlementDate != null ? finalContractualSettlementDate.hashCode() : 0);
			_result = 31 * _result + (cleared != null ? cleared.hashCode() : 0);
			_result = 31 * _result + (centralCounterparty != null ? centralCounterparty.hashCode() : 0);
			_result = 31 * _result + (clearingMember != null ? clearingMember.hashCode() : 0);
			_result = 31 * _result + (clearingTimestamp != null ? clearingTimestamp.hashCode() : 0);
			_result = 31 * _result + (platformIdentifier != null ? platformIdentifier.hashCode() : 0);
			_result = 31 * _result + (bookingLocation != null ? bookingLocation.hashCode() : 0);
			_result = 31 * _result + (traderLocation != null ? traderLocation.hashCode() : 0);
			_result = 31 * _result + (confirmed != null ? confirmed.hashCode() : 0);
			_result = 31 * _result + (confirmationTimestamp != null ? confirmationTimestamp.hashCode() : 0);
			_result = 31 * _result + (executionTimestamp != null ? executionTimestamp.hashCode() : 0);
			_result = 31 * _result + (reportingTimestamp != null ? reportingTimestamp.hashCode() : 0);
			_result = 31 * _result + (basketConstituents != null ? basketConstituents.hashCode() : 0);
			_result = 31 * _result + (valuationAmount != null ? valuationAmount.hashCode() : 0);
			_result = 31 * _result + (valuationCurrency != null ? valuationCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationMethod != null ? valuationMethod.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (valuationTimestamp != null ? valuationTimestamp.hashCode() : 0);
			_result = 31 * _result + (collateralPortfolioIndicator != null ? collateralPortfolioIndicator.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (notionalAmountOfTheContractOrLeg1 != null ? notionalAmountOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfTheContractOrLeg1 != null ? notionalCurrencyOfTheContractOrLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (notionalAmountOfLeg2 != null ? notionalAmountOfLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalCurrencyOfLeg2 != null ? notionalCurrencyOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityOfTheContractOrLeg1 != null ? totalNotionalQuantityOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureForTheContractOrLeg1 != null ? quantityUnitOfMeasureForTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityOfTheContractOrLeg1 != null ? notionalQuantityOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyOfTheContractOrLeg1 != null ? quantityFrequencyOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierOfTheContractOrLeg1 != null ? quantityFrequencyMultiplierOfTheContractOrLeg1.hashCode() : 0);
			_result = 31 * _result + (totalNotionalQuantityLeg2 != null ? totalNotionalQuantityLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityUnitOfMeasureLeg2 != null ? quantityUnitOfMeasureLeg2.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityOfLeg2 != null ? notionalQuantityOfLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyOfLeg2 != null ? quantityFrequencyOfLeg2.hashCode() : 0);
			_result = 31 * _result + (quantityFrequencyMultiplierOfLeg2 != null ? quantityFrequencyMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (callAmount != null ? callAmount.hashCode() : 0);
			_result = 31 * _result + (callCurrency != null ? callCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (putAmount != null ? putAmount.hashCode() : 0);
			_result = 31 * _result + (putCurrency != null ? putCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (price != null ? price.hashCode() : 0);
			_result = 31 * _result + (priceUnitOfMeasure != null ? priceUnitOfMeasure.hashCode() : 0);
			_result = 31 * _result + (priceSchedule != null ? priceSchedule.hashCode() : 0);
			_result = 31 * _result + (strikePrice != null ? strikePrice.hashCode() : 0);
			_result = 31 * _result + (strikePriceSchedule != null ? strikePriceSchedule.hashCode() : 0);
			_result = 31 * _result + (optionPremiumAmount != null ? optionPremiumAmount.hashCode() : 0);
			_result = 31 * _result + (optionPremiumCurrency != null ? optionPremiumCurrency.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (exchangeRate != null ? exchangeRate.hashCode() : 0);
			_result = 31 * _result + (exchangeRateBasis != null ? exchangeRateBasis.hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionOfLeg1 != null ? fixedRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRateDayCountConventionOfLeg2 != null ? fixedRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg1 != null ? floatingRateDayCountConventionOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateDayCountConventionOfLeg2 != null ? floatingRateDayCountConventionOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg1 != null ? floatingRateResetFrequencyPeriodOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierOfLeg1 != null ? floatingRateResetFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodOfLeg2 != null ? floatingRateResetFrequencyPeriodOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRateResetFrequencyPeriodMultiplierOfLeg2 != null ? floatingRateResetFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodOfLeg1 != null ? fixedRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? fixedRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodOfLeg2 != null ? fixedRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? fixedRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg1 != null ? floatingRatePaymentFrequencyPeriodOfLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg1.hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodOfLeg2 != null ? floatingRatePaymentFrequencyPeriodOfLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 != null ? floatingRatePaymentFrequencyPeriodMultiplierOfLeg2.hashCode() : 0);
			_result = 31 * _result + (otherPayment != null ? otherPayment.hashCode() : 0);
			_result = 31 * _result + (actionType != null ? actionType.hashCode() : 0);
			_result = 31 * _result + (eventType != null ? eventType.hashCode() : 0);
			_result = 31 * _result + (eventDate != null ? eventDate.hashCode() : 0);
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			_result = 31 * _result + (technicalRecordId != null ? technicalRecordId.hashCode() : 0);
			_result = 31 * _result + (counterparty2Name != null ? counterparty2Name.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty1 != null ? executionAgentOfCounterparty1.hashCode() : 0);
			_result = 31 * _result + (executionAgentOfCounterparty2DTCC != null ? executionAgentOfCounterparty2DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg1DTCC != null ? notionalAmountScheduleLeg1DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalAmountScheduleLeg2DTCC != null ? notionalAmountScheduleLeg2DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg1DTCC != null ? notionalQuantityScheduleLeg1DTCC.hashCode() : 0);
			_result = 31 * _result + (notionalQuantityScheduleLeg2DTCC != null ? notionalQuantityScheduleLeg2DTCC.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "MASTransactionReportBuilder {" +
				"counterparty1=" + this.counterparty1 + ", " +
				"counterparty2=" + this.counterparty2 + ", " +
				"counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", " +
				"tradingCapacityOfSpecifiedPerson=" + this.tradingCapacityOfSpecifiedPerson + ", " +
				"direction=" + this.direction + ", " +
				"directionOfLeg1=" + this.directionOfLeg1 + ", " +
				"directionOfLeg2=" + this.directionOfLeg2 + ", " +
				"reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + ", " +
				"dataSubmitter=" + this.dataSubmitter + ", " +
				"uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", " +
				"uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", " +
				"uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", " +
				"priorUTI=" + this.priorUTI + ", " +
				"priorUTIProprietary=" + this.priorUTIProprietary + ", " +
				"contractType=" + this.contractType + ", " +
				"assetClass=" + this.assetClass + ", " +
				"underlying=" + this.underlying + ", " +
				"underlyingIdentificationType=" + this.underlyingIdentificationType + ", " +
				"underlyingIdOther=" + this.underlyingIdOther + ", " +
				"underlyingIdOtherSource=" + this.underlyingIdOtherSource + ", " +
				"nameOfTheUnderlyingIndex=" + this.nameOfTheUnderlyingIndex + ", " +
				"fixedRateOfLeg1=" + this.fixedRateOfLeg1 + ", " +
				"identifierOfFloatingRateOfLeg1=" + this.identifierOfFloatingRateOfLeg1 + ", " +
				"nameOfTheFloatingRateOfLeg1=" + this.nameOfTheFloatingRateOfLeg1 + ", " +
				"spreadOfLeg1=" + this.spreadOfLeg1 + ", " +
				"fixedRateOfLeg2=" + this.fixedRateOfLeg2 + ", " +
				"identifierOfFloatingRateOfLeg2=" + this.identifierOfFloatingRateOfLeg2 + ", " +
				"nameOfTheFloatingRateOfLeg2=" + this.nameOfTheFloatingRateOfLeg2 + ", " +
				"spreadOfLeg2=" + this.spreadOfLeg2 + ", " +
				"optionType=" + this.optionType + ", " +
				"optionStyle=" + this.optionStyle + ", " +
				"firstExerciseDate=" + this.firstExerciseDate + ", " +
				"effectiveDate=" + this.effectiveDate + ", " +
				"expirationDate=" + this.expirationDate + ", " +
				"swapLinkID=" + this.swapLinkID + ", " +
				"packageIdentifier=" + this.packageIdentifier + ", " +
				"deliveryType=" + this.deliveryType + ", " +
				"settlementCurrency1=" + this.settlementCurrency1 + ", " +
				"settlementCurrency2=" + this.settlementCurrency2 + ", " +
				"finalContractualSettlementDate=" + this.finalContractualSettlementDate + ", " +
				"cleared=" + this.cleared + ", " +
				"centralCounterparty=" + this.centralCounterparty + ", " +
				"clearingMember=" + this.clearingMember + ", " +
				"clearingTimestamp=" + this.clearingTimestamp + ", " +
				"platformIdentifier=" + this.platformIdentifier + ", " +
				"bookingLocation=" + this.bookingLocation + ", " +
				"traderLocation=" + this.traderLocation + ", " +
				"confirmed=" + this.confirmed + ", " +
				"confirmationTimestamp=" + this.confirmationTimestamp + ", " +
				"executionTimestamp=" + this.executionTimestamp + ", " +
				"reportingTimestamp=" + this.reportingTimestamp + ", " +
				"basketConstituents=" + this.basketConstituents + ", " +
				"valuationAmount=" + this.valuationAmount + ", " +
				"valuationCurrency=" + this.valuationCurrency + ", " +
				"valuationMethod=" + this.valuationMethod + ", " +
				"valuationTimestamp=" + this.valuationTimestamp + ", " +
				"collateralPortfolioIndicator=" + this.collateralPortfolioIndicator + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", " +
				"notionalAmountOfTheContractOrLeg1=" + this.notionalAmountOfTheContractOrLeg1 + ", " +
				"notionalCurrencyOfTheContractOrLeg1=" + this.notionalCurrencyOfTheContractOrLeg1 + ", " +
				"notionalAmountOfLeg2=" + this.notionalAmountOfLeg2 + ", " +
				"notionalCurrencyOfLeg2=" + this.notionalCurrencyOfLeg2 + ", " +
				"totalNotionalQuantityOfTheContractOrLeg1=" + this.totalNotionalQuantityOfTheContractOrLeg1 + ", " +
				"quantityUnitOfMeasureForTheContractOrLeg1=" + this.quantityUnitOfMeasureForTheContractOrLeg1 + ", " +
				"notionalQuantityOfTheContractOrLeg1=" + this.notionalQuantityOfTheContractOrLeg1 + ", " +
				"quantityFrequencyOfTheContractOrLeg1=" + this.quantityFrequencyOfTheContractOrLeg1 + ", " +
				"quantityFrequencyMultiplierOfTheContractOrLeg1=" + this.quantityFrequencyMultiplierOfTheContractOrLeg1 + ", " +
				"totalNotionalQuantityLeg2=" + this.totalNotionalQuantityLeg2 + ", " +
				"quantityUnitOfMeasureLeg2=" + this.quantityUnitOfMeasureLeg2 + ", " +
				"notionalQuantityOfLeg2=" + this.notionalQuantityOfLeg2 + ", " +
				"quantityFrequencyOfLeg2=" + this.quantityFrequencyOfLeg2 + ", " +
				"quantityFrequencyMultiplierOfLeg2=" + this.quantityFrequencyMultiplierOfLeg2 + ", " +
				"callAmount=" + this.callAmount + ", " +
				"callCurrency=" + this.callCurrency + ", " +
				"putAmount=" + this.putAmount + ", " +
				"putCurrency=" + this.putCurrency + ", " +
				"price=" + this.price + ", " +
				"priceUnitOfMeasure=" + this.priceUnitOfMeasure + ", " +
				"priceSchedule=" + this.priceSchedule + ", " +
				"strikePrice=" + this.strikePrice + ", " +
				"strikePriceSchedule=" + this.strikePriceSchedule + ", " +
				"optionPremiumAmount=" + this.optionPremiumAmount + ", " +
				"optionPremiumCurrency=" + this.optionPremiumCurrency + ", " +
				"exchangeRate=" + this.exchangeRate + ", " +
				"exchangeRateBasis=" + this.exchangeRateBasis + ", " +
				"fixedRateDayCountConventionOfLeg1=" + this.fixedRateDayCountConventionOfLeg1 + ", " +
				"fixedRateDayCountConventionOfLeg2=" + this.fixedRateDayCountConventionOfLeg2 + ", " +
				"floatingRateDayCountConventionOfLeg1=" + this.floatingRateDayCountConventionOfLeg1 + ", " +
				"floatingRateDayCountConventionOfLeg2=" + this.floatingRateDayCountConventionOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodOfLeg1=" + this.floatingRateResetFrequencyPeriodOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierOfLeg1=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRateResetFrequencyPeriodOfLeg2=" + this.floatingRateResetFrequencyPeriodOfLeg2 + ", " +
				"floatingRateResetFrequencyPeriodMultiplierOfLeg2=" + this.floatingRateResetFrequencyPeriodMultiplierOfLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodOfLeg1=" + this.fixedRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"fixedRatePaymentFrequencyPeriodOfLeg2=" + this.fixedRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"fixedRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.fixedRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg1=" + this.floatingRatePaymentFrequencyPeriodOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg1=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg1 + ", " +
				"floatingRatePaymentFrequencyPeriodOfLeg2=" + this.floatingRatePaymentFrequencyPeriodOfLeg2 + ", " +
				"floatingRatePaymentFrequencyPeriodMultiplierOfLeg2=" + this.floatingRatePaymentFrequencyPeriodMultiplierOfLeg2 + ", " +
				"otherPayment=" + this.otherPayment + ", " +
				"actionType=" + this.actionType + ", " +
				"eventType=" + this.eventType + ", " +
				"eventDate=" + this.eventDate + ", " +
				"nonReportable=" + this.nonReportable + ", " +
				"technicalRecordId=" + this.technicalRecordId + ", " +
				"counterparty2Name=" + this.counterparty2Name + ", " +
				"executionAgentOfCounterparty1=" + this.executionAgentOfCounterparty1 + ", " +
				"executionAgentOfCounterparty2DTCC=" + this.executionAgentOfCounterparty2DTCC + ", " +
				"notionalAmountScheduleLeg1DTCC=" + this.notionalAmountScheduleLeg1DTCC + ", " +
				"notionalAmountScheduleLeg2DTCC=" + this.notionalAmountScheduleLeg2DTCC + ", " +
				"notionalQuantityScheduleLeg1DTCC=" + this.notionalQuantityScheduleLeg1DTCC + ", " +
				"notionalQuantityScheduleLeg2DTCC=" + this.notionalQuantityScheduleLeg2DTCC +
			'}';
		}
	}
}
