package drr.regulation.mas.rewrite.trade.reports;

import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.standards.iosco.cde.reports.CDEPaymentFrequencyPeriodRule;
import iso20022.auth030.mas.Frequency13Code__1;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(FixedRatePaymentFrequencyPeriodOfLeg1Rule.FixedRatePaymentFrequencyPeriodOfLeg1RuleDefault.class)
public abstract class FixedRatePaymentFrequencyPeriodOfLeg1Rule implements ReportFunction<TransactionReportInstruction, Frequency13Code__1> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPaymentFrequencyPeriodRule cDEPaymentFrequencyPeriodRule;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Frequency13Code__1 evaluate(TransactionReportInstruction input) {
		Frequency13Code__1 output = doEvaluate(input);
		
		return output;
	}

	protected abstract Frequency13Code__1 doEvaluate(TransactionReportInstruction input);

	public static class FixedRatePaymentFrequencyPeriodOfLeg1RuleDefault extends FixedRatePaymentFrequencyPeriodOfLeg1Rule {
		@Override
		protected Frequency13Code__1 doEvaluate(TransactionReportInstruction input) {
			Frequency13Code__1 output = null;
			return assignOutput(output, input);
		}
		
		protected Frequency13Code__1 assignOutput(Frequency13Code__1 output, TransactionReportInstruction input) {
			final MapperS<Product> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg3 = thenArg2
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
			output = MapperS.of(cDEPaymentFrequencyPeriodRule.evaluate(thenArg3.get())).checkedMap("to-enum", Frequency13Code__1::fromDisplayName, IllegalArgumentException.class).get();
			
			return output;
		}
	}
}
