package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.observable.asset.FloatingRateOption;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsFRA;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.regulation.common.functions.RateOption;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(IdentifierOfFloatingRateOfLeg1Rule.IdentifierOfFloatingRateOfLeg1RuleDefault.class)
public abstract class IdentifierOfFloatingRateOfLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected IsFRA isFRA;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected ProductOrUnderlierProduct productOrUnderlierProduct;
	@Inject protected RateOption rateOption;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class IdentifierOfFloatingRateOfLeg1RuleDefault extends IdentifierOfFloatingRateOfLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			final MapperS<Product> thenArg2 = thenArg1
				.filterSingleNullSafe(item -> areEqual(MapperS.of(isFRA.evaluate(item.get())), MapperS.of(false), CardinalityOperator.All).get());
			final MapperS<Product> thenArg3 = thenArg2
				.mapSingleToItem(item -> MapperS.of(productOrUnderlierProduct.evaluate(item.get())));
			final MapperS<InterestRatePayout> thenArg4 = thenArg3
				.mapSingleToItem(item -> MapperS.of(interestRateLeg1.evaluate(item.get())));
			final MapperS<FloatingRateOption> thenArg5 = thenArg4
				.mapSingleToItem(item -> MapperS.of(rateOption.evaluate(item.get())));
			final FieldWithMetaString fieldWithMetaString = thenArg5
				.mapSingleToItem(item -> MapperS.of(item.<IndexReferenceInformation>map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation()).<FieldWithMetaString>mapC("getIndexId", indexReferenceInformation -> indexReferenceInformation.getIndexId()).get())).get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
