package drr.regulation.mas.rewrite.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.mas.rewrite.trade.MASNonReportable;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.PriceAndNotation;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg1;
import drr.regulation.mas.rewrite.trade.SpreadOfLeg2;
import drr.regulation.mas.rewrite.trade.StrikePriceAndNotation;
import iso20022.auth030.mas.Frequency13Code__1;
import iso20022.auth030.mas.InterestComputationMethod4Code;
import iso20022.auth030.mas.TradingCapacity7Code;
import iso20022.auth030.mas.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class MASTransactionReportValidator implements Validator<MASTransactionReport> {

	private List<ComparisonResult> getComparisonResults(MASTransactionReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("counterparty1", (String) o.getCounterparty1() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2", (String) o.getCounterparty2() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2IdentifierType", (Boolean) o.getCounterparty2IdentifierType() != null ? 1 : 0, 1, 1), 
				checkCardinality("tradingCapacityOfSpecifiedPerson", (TradingCapacity7Code) o.getTradingCapacityOfSpecifiedPerson() != null ? 1 : 0, 0, 1), 
				checkCardinality("direction", (String) o.getDirection() != null ? 1 : 0, 0, 1), 
				checkCardinality("directionOfLeg1", (String) o.getDirectionOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("directionOfLeg2", (String) o.getDirectionOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportingSpecifiedPerson", (String) o.getReportingSpecifiedPerson() != null ? 1 : 0, 1, 1), 
				checkCardinality("dataSubmitter", (String) o.getDataSubmitter() != null ? 1 : 0, 1, 1), 
				checkCardinality("uniqueTransactionIdentifier", (String) o.getUniqueTransactionIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueTransactionIdentifierProprietary", (String) o.getUniqueTransactionIdentifierProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("uniqueProductIdentifier", (String) o.getUniqueProductIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUTI", (String) o.getPriorUTI() != null ? 1 : 0, 0, 1), 
				checkCardinality("priorUTIProprietary", (String) o.getPriorUTIProprietary() != null ? 1 : 0, 0, 1), 
				checkCardinality("contractType", (String) o.getContractType() != null ? 1 : 0, 0, 1), 
				checkCardinality("assetClass", (String) o.getAssetClass() != null ? 1 : 0, 1, 1), 
				checkCardinality("underlying", (String) o.getUnderlying() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdentificationType", (String) o.getUnderlyingIdentificationType() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdOther", (String) o.getUnderlyingIdOther() != null ? 1 : 0, 0, 1), 
				checkCardinality("underlyingIdOtherSource", (String) o.getUnderlyingIdOtherSource() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheUnderlyingIndex", (String) o.getNameOfTheUnderlyingIndex() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateOfLeg1", (BigDecimal) o.getFixedRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("identifierOfFloatingRateOfLeg1", (String) o.getIdentifierOfFloatingRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheFloatingRateOfLeg1", (String) o.getNameOfTheFloatingRateOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg1", (SpreadOfLeg1) o.getSpreadOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateOfLeg2", (BigDecimal) o.getFixedRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("identifierOfFloatingRateOfLeg2", (String) o.getIdentifierOfFloatingRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("nameOfTheFloatingRateOfLeg2", (String) o.getNameOfTheFloatingRateOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg2", (SpreadOfLeg2) o.getSpreadOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionType", (String) o.getOptionType() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionStyle", (String) o.getOptionStyle() != null ? 1 : 0, 0, 1), 
				checkCardinality("firstExerciseDate", (Date) o.getFirstExerciseDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("effectiveDate", (Date) o.getEffectiveDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("expirationDate", (Date) o.getExpirationDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("swapLinkID", (String) o.getSwapLinkID() != null ? 1 : 0, 0, 1), 
				checkCardinality("packageIdentifier", (String) o.getPackageIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("deliveryType", (String) o.getDeliveryType() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrency1", (ISOCurrencyCodeEnum) o.getSettlementCurrency1() != null ? 1 : 0, 0, 1), 
				checkCardinality("settlementCurrency2", (ISOCurrencyCodeEnum) o.getSettlementCurrency2() != null ? 1 : 0, 0, 1), 
				checkCardinality("finalContractualSettlementDate", (Date) o.getFinalContractualSettlementDate() != null ? 1 : 0, 0, 1), 
				checkCardinality("cleared", (String) o.getCleared() != null ? 1 : 0, 0, 1), 
				checkCardinality("centralCounterparty", (String) o.getCentralCounterparty() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingMember", (String) o.getClearingMember() != null ? 1 : 0, 0, 1), 
				checkCardinality("clearingTimestamp", (ZonedDateTime) o.getClearingTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("platformIdentifier", (String) o.getPlatformIdentifier() != null ? 1 : 0, 0, 1), 
				checkCardinality("bookingLocation", (String) o.getBookingLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("traderLocation", (String) o.getTraderLocation() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmed", (String) o.getConfirmed() != null ? 1 : 0, 0, 1), 
				checkCardinality("confirmationTimestamp", (ZonedDateTime) o.getConfirmationTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionTimestamp", (ZonedDateTime) o.getExecutionTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("reportingTimestamp", (ZonedDateTime) o.getReportingTimestamp() != null ? 1 : 0, 1, 1), 
				checkCardinality("valuationAmount", (BigDecimal) o.getValuationAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationCurrency", (ISOCurrencyCodeEnum) o.getValuationCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationMethod", (ValuationType1Code) o.getValuationMethod() != null ? 1 : 0, 0, 1), 
				checkCardinality("valuationTimestamp", (ZonedDateTime) o.getValuationTimestamp() != null ? 1 : 0, 0, 1), 
				checkCardinality("collateralPortfolioIndicator", (Boolean) o.getCollateralPortfolioIndicator() != null ? 1 : 0, 0, 1), 
				checkCardinality("initialMarginCollateralPortfolioCode", (String) o.getInitialMarginCollateralPortfolioCode() != null ? 1 : 0, 0, 1), 
				checkCardinality("variationMarginCollateralPortfolioCode", (String) o.getVariationMarginCollateralPortfolioCode() != null ? 1 : 0, 1, 1), 
				checkCardinality("notionalAmountOfTheContractOrLeg1", (BigDecimal) o.getNotionalAmountOfTheContractOrLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyOfTheContractOrLeg1", (ISOCurrencyCodeEnum) o.getNotionalCurrencyOfTheContractOrLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalAmountOfLeg2", (BigDecimal) o.getNotionalAmountOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalCurrencyOfLeg2", (ISOCurrencyCodeEnum) o.getNotionalCurrencyOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityOfTheContractOrLeg1", (BigDecimal) o.getTotalNotionalQuantityOfTheContractOrLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureForTheContractOrLeg1", (String) o.getQuantityUnitOfMeasureForTheContractOrLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityOfTheContractOrLeg1", (BigDecimal) o.getNotionalQuantityOfTheContractOrLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyOfTheContractOrLeg1", (String) o.getQuantityFrequencyOfTheContractOrLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierOfTheContractOrLeg1", (Integer) o.getQuantityFrequencyMultiplierOfTheContractOrLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("totalNotionalQuantityLeg2", (BigDecimal) o.getTotalNotionalQuantityLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityUnitOfMeasureLeg2", (String) o.getQuantityUnitOfMeasureLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("notionalQuantityOfLeg2", (BigDecimal) o.getNotionalQuantityOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyOfLeg2", (String) o.getQuantityFrequencyOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("quantityFrequencyMultiplierOfLeg2", (Integer) o.getQuantityFrequencyMultiplierOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("callAmount", (BigDecimal) o.getCallAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("callCurrency", (ISOCurrencyCodeEnum) o.getCallCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("putAmount", (BigDecimal) o.getPutAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("putCurrency", (ISOCurrencyCodeEnum) o.getPutCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("price", (PriceAndNotation) o.getPrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("priceUnitOfMeasure", (String) o.getPriceUnitOfMeasure() != null ? 1 : 0, 0, 1), 
				checkCardinality("strikePrice", (StrikePriceAndNotation) o.getStrikePrice() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumAmount", (BigDecimal) o.getOptionPremiumAmount() != null ? 1 : 0, 0, 1), 
				checkCardinality("optionPremiumCurrency", (ISOCurrencyCodeEnum) o.getOptionPremiumCurrency() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRate", (BigDecimal) o.getExchangeRate() != null ? 1 : 0, 0, 1), 
				checkCardinality("exchangeRateBasis", (String) o.getExchangeRateBasis() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionOfLeg1", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRateDayCountConventionOfLeg2", (InterestComputationMethod4Code) o.getFixedRateDayCountConventionOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionOfLeg1", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateDayCountConventionOfLeg2", (InterestComputationMethod4Code) o.getFloatingRateDayCountConventionOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodOfLeg1", (String) o.getFloatingRateResetFrequencyPeriodOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierOfLeg1", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodOfLeg2", (String) o.getFloatingRateResetFrequencyPeriodOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRateResetFrequencyPeriodMultiplierOfLeg2", (Integer) o.getFloatingRateResetFrequencyPeriodMultiplierOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodOfLeg1", (Frequency13Code__1) o.getFixedRatePaymentFrequencyPeriodOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierOfLeg1", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodOfLeg2", (Frequency13Code__1) o.getFixedRatePaymentFrequencyPeriodOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("fixedRatePaymentFrequencyPeriodMultiplierOfLeg2", (Integer) o.getFixedRatePaymentFrequencyPeriodMultiplierOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodOfLeg1", (Frequency13Code__1) o.getFloatingRatePaymentFrequencyPeriodOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierOfLeg1", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodOfLeg2", (Frequency13Code__1) o.getFloatingRatePaymentFrequencyPeriodOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("floatingRatePaymentFrequencyPeriodMultiplierOfLeg2", (Integer) o.getFloatingRatePaymentFrequencyPeriodMultiplierOfLeg2() != null ? 1 : 0, 0, 1), 
				checkCardinality("actionType", (String) o.getActionType() != null ? 1 : 0, 1, 1), 
				checkCardinality("eventType", (String) o.getEventType() != null ? 1 : 0, 0, 1), 
				checkCardinality("eventDate", (ZonedDateTime) o.getEventDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("nonReportable", (MASNonReportable) o.getNonReportable() != null ? 1 : 0, 0, 1), 
				checkCardinality("technicalRecordId", (String) o.getTechnicalRecordId() != null ? 1 : 0, 1, 1), 
				checkCardinality("counterparty2Name", (String) o.getCounterparty2Name() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionAgentOfCounterparty1", (String) o.getExecutionAgentOfCounterparty1() != null ? 1 : 0, 0, 1), 
				checkCardinality("executionAgentOfCounterparty2DTCC", (String) o.getExecutionAgentOfCounterparty2DTCC() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MASTransactionReport", ValidationResult.ValidationType.CARDINALITY, "MASTransactionReport", path, "", res.getError());
				}
				return success("MASTransactionReport", ValidationResult.ValidationType.CARDINALITY, "MASTransactionReport", path, "");
			})
			.collect(toList());
	}

}
