package drr.regulation.techsprint.g20.mas.functions;

import cdm.base.staticdata.party.Address;
import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(LookupBookingLocation.LookupBookingLocationDefault.class)
public abstract class LookupBookingLocation implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param party 
	* @return bookingLocation 
	*/
	public Address evaluate(Party party) {
		Address.AddressBuilder bookingLocationBuilder = doEvaluate(party);
		
		final Address bookingLocation;
		if (bookingLocationBuilder == null) {
			bookingLocation = null;
		} else {
			bookingLocation = bookingLocationBuilder.build();
			objectValidator.validate(Address.class, bookingLocation);
		}
		
		return bookingLocation;
	}

	protected abstract Address.AddressBuilder doEvaluate(Party party);

	public static class LookupBookingLocationDefault extends LookupBookingLocation {
		@Override
		protected Address.AddressBuilder doEvaluate(Party party) {
			Address.AddressBuilder bookingLocation = Address.builder();
			return assignOutput(bookingLocation, party);
		}
		
		protected Address.AddressBuilder assignOutput(Address.AddressBuilder bookingLocation, Party party) {
			return Optional.ofNullable(bookingLocation)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
