package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(ContractForEventRule.ContractForEventRuleDefault.class)
public abstract class ContractForEventRule implements ReportFunction<TransactionReportInstruction, Trade> {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Trade evaluate(TransactionReportInstruction input) {
		Trade.TradeBuilder outputBuilder = doEvaluate(input);
		
		final Trade output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(Trade.class, output);
		}
		
		return output;
	}

	protected abstract Trade.TradeBuilder doEvaluate(TransactionReportInstruction input);

	public static class ContractForEventRuleDefault extends ContractForEventRule {
		@Override
		protected Trade.TradeBuilder doEvaluate(TransactionReportInstruction input) {
			Trade.TradeBuilder output = Trade.builder();
			return assignOutput(output, input);
		}
		
		protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder output, TransactionReportInstruction input) {
			output = toBuilder(MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<TradeState>mapC("getAfter", businessEvent -> businessEvent.getAfter()).get()).<Trade>map("getTrade", tradeState -> tradeState.getTrade())).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
