package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.RateSpecification;
import cdm.product.common.schedule.PaymentDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(InterestRatePaymentFrequencyPeriodLeg1Rule.InterestRatePaymentFrequencyPeriodLeg1RuleDefault.class)
public abstract class InterestRatePaymentFrequencyPeriodLeg1Rule implements ReportFunction<TransactionReportInstruction, PeriodExtendedEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FixedFloatLeg1Rule fixedFloatLeg1Rule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PeriodExtendedEnum evaluate(TransactionReportInstruction input) {
		PeriodExtendedEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PeriodExtendedEnum doEvaluate(TransactionReportInstruction input);

	public static class InterestRatePaymentFrequencyPeriodLeg1RuleDefault extends InterestRatePaymentFrequencyPeriodLeg1Rule {
		@Override
		protected PeriodExtendedEnum doEvaluate(TransactionReportInstruction input) {
			PeriodExtendedEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PeriodExtendedEnum assignOutput(PeriodExtendedEnum output, TransactionReportInstruction input) {
			final MapperS<InterestRatePayout> thenArg0 = MapperS.of(fixedFloatLeg1Rule.evaluate(input));
			final MapperS<InterestRatePayout> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> exists(item.<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FixedRateSpecification>map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate())).get());
			output = thenArg1
				.mapSingleToItem(item -> item.<PaymentDates>map("getPaymentDates", interestRatePayout -> interestRatePayout.getPaymentDates()).<Frequency>map("getPaymentFrequency", paymentDates -> paymentDates.getPaymentFrequency()).<PeriodExtendedEnum>map("getPeriod", frequency -> frequency.getPeriod())).get();
			
			return output;
		}
	}
}
