package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.event.common.Trade;
import cdm.product.template.ContractualProduct;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetProductQualifier;
import javax.inject.Inject;


@ImplementedBy(UniqueProductIdentifierRule.UniqueProductIdentifierRuleDefault.class)
public abstract class UniqueProductIdentifierRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ContractForEventRule contractForEventRule;
	@Inject protected GetProductQualifier getProductQualifier;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class UniqueProductIdentifierRuleDefault extends UniqueProductIdentifierRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg = MapperS.of(contractForEventRule.evaluate(input));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(getProductQualifier.evaluate(item.<TradableProduct>map("getTradableProduct", trade -> trade.getTradableProduct()).<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<ProductTaxonomy>mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy()).getMulti()))).get();
			
			return output;
		}
	}
}
