/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="AssetTypeEnum")
public enum AssetTypeEnum {
    SECURITY("Security", null),
    CASH("Cash", null),
    COMMODITY("Commodity", null),
    OTHER("Other", null);

    private static Map<String, AssetTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private AssetTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static AssetTypeEnum fromDisplayName(String name) {
        AssetTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, AssetTypeEnum> map = new ConcurrentHashMap<String, AssetTypeEnum>();
        for (AssetTypeEnum instance : AssetTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

