/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FindMatchingIndexTransitionInstructionDefault.class)
public abstract class FindMatchingIndexTransitionInstruction
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceQuantity evaluate(List<? extends PriceQuantity> instructions, PriceQuantity priceQuantity) {
        PriceQuantity matchingInstruction;
        PriceQuantity.PriceQuantityBuilder matchingInstructionBuilder = this.doEvaluate(instructions, priceQuantity);
        if (matchingInstructionBuilder == null) {
            matchingInstruction = null;
        } else {
            matchingInstruction = matchingInstructionBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)matchingInstruction);
        }
        return matchingInstruction;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(List<? extends PriceQuantity> var1, PriceQuantity var2);

    public static class FindMatchingIndexTransitionInstructionDefault
    extends FindMatchingIndexTransitionInstruction {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(List<? extends PriceQuantity> instructions, PriceQuantity priceQuantity) {
            if (instructions == null) {
                instructions = Collections.emptyList();
            }
            PriceQuantity.PriceQuantityBuilder matchingInstruction = PriceQuantity.builder();
            return this.assignOutput(matchingInstruction, instructions, priceQuantity);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder matchingInstruction, List<? extends PriceQuantity> instructions, PriceQuantity priceQuantity) {
            MapperC thenArg = MapperC.of(instructions).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getObservable", _priceQuantity -> _priceQuantity.getObservable()).map("getRateOption", observable -> observable.getRateOption()).map("Type coercion", fieldWithMetaFloatingRateOption0 -> fieldWithMetaFloatingRateOption0 == null ? null : fieldWithMetaFloatingRateOption0.getValue()).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriod", period -> period.getPeriod()), (Mapper)MapperS.of((Object)priceQuantity).map("getObservable", _priceQuantity -> _priceQuantity.getObservable()).map("getRateOption", observable -> observable.getRateOption()).map("Type coercion", fieldWithMetaFloatingRateOption1 -> fieldWithMetaFloatingRateOption1 == null ? null : fieldWithMetaFloatingRateOption1.getValue()).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriod", period -> period.getPeriod()), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)item.map("getObservable", _priceQuantity -> _priceQuantity.getObservable()).map("getRateOption", observable -> observable.getRateOption()).map("Type coercion", fieldWithMetaFloatingRateOption2 -> fieldWithMetaFloatingRateOption2 == null ? null : fieldWithMetaFloatingRateOption2.getValue()).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)priceQuantity).map("getObservable", _priceQuantity -> _priceQuantity.getObservable()).map("getRateOption", observable -> observable.getRateOption()).map("Type coercion", fieldWithMetaFloatingRateOption3 -> fieldWithMetaFloatingRateOption3 == null ? null : fieldWithMetaFloatingRateOption3.getValue()).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (CardinalityOperator)CardinalityOperator.All)).and(ExpressionOperators.areEqual((Mapper)item.mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)item.mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()), (CardinalityOperator)CardinalityOperator.All))).get());
            matchingInstruction = (PriceQuantity.PriceQuantityBuilder)this.toBuilder((RosettaModelObject)thenArg.first().get());
            return Optional.ofNullable(matchingInstruction).map(o -> o.prune()).orElse(null);
        }
    }
}

