/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.Quantity;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ToMoneyDefault.class)
public abstract class ToMoney
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Money evaluate(Quantity quantity) {
        Money money;
        Money.MoneyBuilder moneyBuilder = this.doEvaluate(quantity);
        if (moneyBuilder == null) {
            money = null;
        } else {
            money = moneyBuilder.build();
            this.objectValidator.validate(Money.class, (RosettaModelObject)money);
        }
        return money;
    }

    protected abstract Money.MoneyBuilder doEvaluate(Quantity var1);

    public static class ToMoneyDefault
    extends ToMoney {
        @Override
        protected Money.MoneyBuilder doEvaluate(Quantity quantity) {
            Money.MoneyBuilder money = Money.builder();
            return this.assignOutput(money, quantity);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder money, Quantity quantity) {
            money.setValue((BigDecimal)MapperS.of((Object)quantity).map("getValue", _quantity -> _quantity.getValue()).get());
            money.getOrCreateUnit().setCurrency((FieldWithMetaString)MapperS.of((Object)quantity).map("getUnit", _quantity -> _quantity.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get());
            return Optional.ofNullable(money).map(o -> o.prune()).orElse(null);
        }
    }
}

